#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Install procedure

:author:       Michael Mulich
:copyright:    2010 by Penn State University
:organization: WebLion Group, Penn State University
:license:      GPL, see LICENSE for more detail
"""
import os
import sys
import shutil
from optparse import OptionParser

__version__ = '0.1.0'
RUN_LOCATION = os.path.abspath(os.curdir)
PREFIX = 'dist'
DEFAULT_EXTRACTION_POINT = os.path.join(RUN_LOCATION, 'build')

def store_abs_path(option, opt_str, value, parser):
    setattr(parser.values, option.dest, os.path.abspath(value))

parser = OptionParser()
parser.add_option('--dists', dest='dists',
                  metavar='DIR',
                  type='string', nargs=1,
                  action='callback', callback=store_abs_path,
                  default=os.path.join(DEFAULT_EXTRACTION_POINT, PREFIX),
                  help="distribution library build directory")
parser.add_option('--dists-dest', dest='dists_dest',
                  metavar='DIR',
                  help="distribution library destination")
parser.add_option('--scripts', dest='scripts',
                  metavar="DIR",
                  type='string', nargs=1,
                  action='callback', callback=store_abs_path,
                  default=os.path.join(DEFAULT_EXTRACTION_POINT,
                                       '%s-scripts' % PREFIX),
                  help="distribution scripts source build directory")
parser.add_option('--scripts-dest', dest='scripts_dest',
                  metavar="DIR",
                  help="distribution scripts destination")
parser.add_option('--pth', dest='pth',
                  metavar="DIR",
                  type='string', nargs=1,
                  action='callback', callback=store_abs_path,
                  default=os.path.join(DEFAULT_EXTRACTION_POINT,
                                       '%s-pth' % PREFIX),
                  help="distribution pth file build directory")
parser.add_option('--pth-dest', dest='pth_dest',
                  metavar="DIR",
                  help="distribution pth file target destination")

def main():
    (options, args) = parser.parse_args()

    libs = options.dists
    scripts = options.scripts
    pth_files = options.pth
    pths = [os.path.join(pth_files, pth_file)
            for pth_file in os.listdir(pth_files)]

    libs_dst = options.dists_dest
    scripts_dst = options.scripts_dest
    pth_dst = options.pth_dest

    # Install the libraries
    for d in os.listdir(libs):
        src = os.path.join(libs, d)
        dst = os.path.join(libs_dst, d)
        if os.path.isdir(src):
            copy = shutil.copytree
        else:
            # To allow for zipped distributions (a.k.a. eggs).
            copy = shutil.copy2
        copy(src, dst)

    # Install the scripts
    for s in os.listdir(scripts):
        src = os.path.join(scripts, s)
        dst = os.path.join(scripts_dst, s)
        shutil.copy2(src, dst)

    # Install the pth file
    for pth in pths:
        shutil.copy2(pth, pth_dst)

if __name__ == '__main__':
    main()
