/*
 * High Level Configuration Options
 */
#define CONFIG_E300		1	/* E300 family */

#define CONFIG_KM_DEF_ARCH	"arch=ppc_82xx\0"

/* QE microcode/firmware address */
/* between the u-boot partition and env */

/*
 * System IO Config
 */
/* 0x14000180 SICR_1 */
#ifndef CONFIG_SYS_SICRL
#define CONFIG_SYS_SICRL (0			\
		| SICR_1_UART1_UART1RTS		\
		| SICR_1_I2C_CKSTOP		\
		| SICR_1_IRQ_A_IRQ		\
		| SICR_1_IRQ_B_IRQ		\
		| SICR_1_GPIO_A_GPIO		\
		| SICR_1_GPIO_B_GPIO		\
		| SICR_1_GPIO_C_GPIO		\
		| SICR_1_GPIO_D_GPIO		\
		| SICR_1_GPIO_E_GPIO		\
		| SICR_1_GPIO_F_GPIO		\
		| SICR_1_USB_A_UART2S		\
		| SICR_1_USB_B_UART2RTS		\
		| SICR_1_FEC1_FEC1		\
		| SICR_1_FEC2_FEC2		\
		)
#endif

/* 0x00080400 SICR_2 */
#define CONFIG_SYS_SICRH (0			\
		| SICR_2_FEC3_FEC3		\
		| SICR_2_HDLC1_A_HDLC1		\
		| SICR_2_ELBC_A_LA		\
		| SICR_2_ELBC_B_LCLK		\
		| SICR_2_HDLC2_A_HDLC2		\
		| SICR_2_USB_D_GPIO		\
		| SICR_2_PCI_PCI		\
		| SICR_2_HDLC1_B_HDLC1		\
		| SICR_2_HDLC1_C_HDLC1		\
		| SICR_2_HDLC2_B_GPIO		\
		| SICR_2_HDLC2_C_HDLC2		\
		| SICR_2_QUIESCE_B		\
		)

/* GPR_1 */
#define CONFIG_SYS_GPR1  0x50008060

#define CONFIG_SYS_GP1DIR 0x00000000
#define CONFIG_SYS_GP1ODR 0x00000000
#define CONFIG_SYS_GP2DIR 0xFF000000
#define CONFIG_SYS_GP2ODR 0x00000000

#define CONFIG_SYS_DDRCDR (\
	DDRCDR_EN | \
	DDRCDR_PZ_MAXZ | \
	DDRCDR_NZ_MAXZ | \
	DDRCDR_M_ODR)

#define CONFIG_SYS_DDR_CS0_BNDS		0x0000007f
#define CONFIG_SYS_DDR_SDRAM_CFG	(SDRAM_CFG_SDRAM_TYPE_DDR2 | \
					 SDRAM_CFG_32_BE | \
					 SDRAM_CFG_SREN | \
					 SDRAM_CFG_HSE)

#define CONFIG_SYS_DDR_SDRAM_CFG2	0x00401000
#define CONFIG_SYS_DDR_CLK_CNTL		(DDR_SDRAM_CLK_CNTL_CLK_ADJUST_05)
#define CONFIG_SYS_DDR_INTERVAL	((0x064 << SDRAM_INTERVAL_BSTOPRE_SHIFT) | \
				 (0x200 << SDRAM_INTERVAL_REFINT_SHIFT))

#define CONFIG_SYS_DDR_CS0_CONFIG	(CSCONFIG_EN | CSCONFIG_AP | \
					 CSCONFIG_ODT_RD_NEVER | \
					 CSCONFIG_ODT_WR_ONLY_CURRENT | \
					 CSCONFIG_ROW_BIT_13 | \
					 CSCONFIG_COL_BIT_10)

#define CONFIG_SYS_DDR_MODE	0x47860242
#define CONFIG_SYS_DDR_MODE2	0x8080c000

#define CONFIG_SYS_DDR_TIMING_0	((2 << TIMING_CFG0_MRS_CYC_SHIFT) | \
				 (8 << TIMING_CFG0_ODT_PD_EXIT_SHIFT) | \
				 (2 << TIMING_CFG0_PRE_PD_EXIT_SHIFT) | \
				 (2 << TIMING_CFG0_ACT_PD_EXIT_SHIFT) | \
				 (0 << TIMING_CFG0_WWT_SHIFT) | \
				 (0 << TIMING_CFG0_RRT_SHIFT) | \
				 (0 << TIMING_CFG0_WRT_SHIFT) | \
				 (0 << TIMING_CFG0_RWT_SHIFT))

#define CONFIG_SYS_DDR_TIMING_1	((TIMING_CFG1_CASLAT_40) | \
				 (2 << TIMING_CFG1_WRTORD_SHIFT) | \
				 (2 << TIMING_CFG1_ACTTOACT_SHIFT) | \
				 (3 << TIMING_CFG1_WRREC_SHIFT) | \
				 (7 << TIMING_CFG1_REFREC_SHIFT) | \
				 (3 << TIMING_CFG1_ACTTORW_SHIFT) | \
				 (7 << TIMING_CFG1_ACTTOPRE_SHIFT) | \
				 (3 << TIMING_CFG1_PRETOACT_SHIFT))

#define CONFIG_SYS_DDR_TIMING_2	((8 << TIMING_CFG2_FOUR_ACT_SHIFT) | \
				 (3 << TIMING_CFG2_CKE_PLS_SHIFT) | \
				 (2 << TIMING_CFG2_WR_DATA_DELAY_SHIFT) | \
				 (2 << TIMING_CFG2_RD_TO_PRE_SHIFT) | \
				 (3 << TIMING_CFG2_WR_LAT_DELAY_SHIFT) | \
				 (0 << TIMING_CFG2_ADD_LAT_SHIFT) | \
				 (5 << TIMING_CFG2_CPO_SHIFT))

#define CONFIG_SYS_DDR_TIMING_3	0x00000000

#define CONFIG_SYS_KMBEC_FPGA_BASE	0xE8000000
#define CONFIG_SYS_KMBEC_FPGA_SIZE	128

/* EEprom support */

/* ethernet port connected to piggy (UEC2) */
#define CONFIG_HAS_ETH1
#define CONFIG_UEC_ETH2
#define CONFIG_SYS_UEC2_UCC_NUM		2       /* UCC3 */
#define CONFIG_SYS_UEC2_RX_CLK		QE_CLK_NONE /* not used in RMII Mode */
#define CONFIG_SYS_UEC2_TX_CLK		QE_CLK12
#define CONFIG_SYS_UEC2_ETH_TYPE	FAST_ETH
#define CONFIG_SYS_UEC2_PHY_ADDR	0
#define CONFIG_SYS_UEC2_INTERFACE_TYPE	PHY_INTERFACE_MODE_RMII
#define CONFIG_SYS_UEC2_INTERFACE_SPEED	100
