/** @file cmd_usergetkey.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMD_USERGETKEY_H
#define CMD_USERGETKEY_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef USERGETKEY_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define USERGETKEY_CMDLINE_PARSER_PACKAGE "sxacl"
#endif

#ifndef USERGETKEY_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define USERGETKEY_CMDLINE_PARSER_PACKAGE_NAME "sxacl"
#endif

#ifndef USERGETKEY_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define USERGETKEY_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct usergetkey_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * auth_file_arg;	/**< @brief Store authentication key in given file (instead of stdout).  */
  char * auth_file_orig;	/**< @brief Store authentication key in given file (instead of stdout) original value given at command line.  */
  const char *auth_file_help; /**< @brief Store authentication key in given file (instead of stdout) help description.  */
  int config_link_flag;	/**< @brief Return configuration link instead of authentication key (default=off).  */
  const char *config_link_help; /**< @brief Return configuration link instead of authentication key help description.  */
  char * config_dir_arg;	/**< @brief Path to SX configuration directory.  */
  char * config_dir_orig;	/**< @brief Path to SX configuration directory original value given at command line.  */
  const char *config_dir_help; /**< @brief Path to SX configuration directory help description.  */
  int debug_flag;	/**< @brief Enable debug messages (default=off).  */
  const char *debug_help; /**< @brief Enable debug messages help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int auth_file_given ;	/**< @brief Whether auth-file was given.  */
  unsigned int config_link_given ;	/**< @brief Whether config-link was given.  */
  unsigned int config_dir_given ;	/**< @brief Whether config-dir was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct usergetkey_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure usergetkey_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure usergetkey_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *usergetkey_args_info_purpose;
/** @brief the usage string of the program */
extern const char *usergetkey_args_info_usage;
/** @brief all the lines making the help output */
extern const char *usergetkey_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *usergetkey_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int usergetkey_cmdline_parser (int argc, char **argv,
  struct usergetkey_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use usergetkey_cmdline_parser_ext() instead
 */
int usergetkey_cmdline_parser2 (int argc, char **argv,
  struct usergetkey_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int usergetkey_cmdline_parser_ext (int argc, char **argv,
  struct usergetkey_args_info *args_info,
  struct usergetkey_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int usergetkey_cmdline_parser_dump(FILE *outfile,
  struct usergetkey_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int usergetkey_cmdline_parser_file_save(const char *filename,
  struct usergetkey_args_info *args_info);

/**
 * Print the help
 */
void usergetkey_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void usergetkey_cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void usergetkey_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a usergetkey_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void usergetkey_cmdline_parser_params_init(struct usergetkey_cmdline_parser_params *params);

/**
 * Allocates dynamically a usergetkey_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized usergetkey_cmdline_parser_params structure
 */
struct usergetkey_cmdline_parser_params *usergetkey_cmdline_parser_params_create(void);

/**
 * Initializes the passed usergetkey_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void usergetkey_cmdline_parser_init (struct usergetkey_args_info *args_info);
/**
 * Deallocates the string fields of the usergetkey_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void usergetkey_cmdline_parser_free (struct usergetkey_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int usergetkey_cmdline_parser_required (struct usergetkey_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMD_USERGETKEY_H */
