% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBaseFactor.R
\name{readBaseFactor}
\alias{readBaseFactor}
\alias{loadBaseFactor}
\title{Read a factor from disk}
\usage{
readBaseFactor(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the \code{\link{saveObject}} method for factors.}

\item{metadata}{Named list containing metadata for the object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments, ignored.}
}
\value{
The vector described by \code{info}.
}
\description{
Read a base R \link{factor} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
tmp <- tempfile()
saveObject(factor(letters[1:10], letters), tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,factor-method}"}, for the staging method.
}
\author{
Aaron Lun
}
