/***************************************************************************
 *   Copyright (C) 2007-2014 by Vegeta                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Core.h"

#include <QFileInfo>

Core::Core() : m_Volume(0) {
    resetVariables();
}

Core::~Core(){
};

void Core::resetVariables(){
    m_finishedFiles     = 0;
    m_Errors            = 0;
    m_skippedFiles      = 0;
    m_isDragDropAllowed = true;
    m_isCancel          = false;
    allFiles.clear();
}


// Calculates the time
QString Core::TimeUpdateString(){
    int total   = m_Now.secsTo(QDateTime::currentDateTime());
    int hours   = total / 3600;
    total       = total % 3600;
    int minutes = total / 60;
    int seconds = total % 60;

    return (QString("%1:%2:%3")
            .arg(hours,   2, 10, QChar('0'))
            .arg(minutes, 2, 10, QChar('0'))
            .arg(seconds, 2, 10, QChar('0')));
}


QString Core::FilenameWithoutPath(const int &Nummer){
    if (allFiles.size() > 0 && Nummer < allFiles.size()){
        QFileInfo Dummy(allFiles[Nummer]);
        QString Temp = Dummy.fileName();
        return Temp.left(Temp.lastIndexOf("."));
    }
    return "";
}



