/***************************************************************************
 *   Copyright (C) 2008-2016 by Alexey S. Malakhov <brezerk@gmail.com>     *
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 ***************************************************************************/

#ifndef PROGRESS_H
#define PROGRESS_H

#include <memory>

#include "config.h"

#include "src/q4wine-lib/ui_Process.h"

#include <QDialog>
#include <QWidget>
#include <QDir>
#include <QString>
#include <QStringList>
#include <QTimer>

#ifdef DEBUG
#include <QDebug>
#endif

#include "prefix.h"
#include "icon.h"
#include "dir.h"

//q4wine lib
#include "q4wine-lib.h"

class Progress : public QDialog, public Ui::Process
{
Q_OBJECT
public:
    explicit Progress(int action, QString path = "", QWidget * parent = 0, Qt::WindowFlags f = 0);

signals:

public slots:

private:
    int action, max, current;

    QLibrary libq4wine;
    typedef void *CoreLibPrototype (bool);
    CoreLibPrototype *CoreLibClassPointer;
    std::auto_ptr<corelib> CoreLib;

    Dir db_dir;
    Icon db_icon;
    Prefix db_prefix;

    QString path;

    int importIcons(QString folder);
    //void removeEmptyFolders(QString folder);
    void parseDesktopFile(QString file, QString dirName);
    QStringList iconDirs;
    QStringList iconFiles;

    std::auto_ptr<QTimer> t;

private slots:
    void runAction();
    void cmdCancel_Click();

};

#endif // PROGRESS_H

