# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_autoscale_setting.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="b67f7fec-69fc-4974-9099-a26bd6ffeda3",
    )

    response = client.autoscale_settings.create_or_update(
        resource_group_name="TestingMetricsScaleSet",
        autoscale_setting_name="MySetting",
        parameters={
            "location": "West US",
            "properties": {
                "enabled": True,
                "notifications": [
                    {
                        "email": {
                            "customEmails": ["gu@ms.com", "ge@ns.net"],
                            "sendToSubscriptionAdministrator": True,
                            "sendToSubscriptionCoAdministrators": True,
                        },
                        "operation": "Scale",
                        "webhooks": [{"properties": {}, "serviceUri": "http://myservice.com"}],
                    }
                ],
                "predictiveAutoscalePolicy": {"scaleMode": "Enabled"},
                "profiles": [
                    {
                        "capacity": {"default": "1", "maximum": "10", "minimum": "1"},
                        "fixedDate": {
                            "end": "2015-03-05T14:30:00Z",
                            "start": "2015-03-05T14:00:00Z",
                            "timeZone": "UTC",
                        },
                        "name": "adios",
                        "rules": [
                            {
                                "metricTrigger": {
                                    "dividePerInstance": False,
                                    "metricName": "Percentage CPU",
                                    "metricResourceUri": "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
                                    "operator": "GreaterThan",
                                    "statistic": "Average",
                                    "threshold": 10,
                                    "timeAggregation": "Average",
                                    "timeGrain": "PT1M",
                                    "timeWindow": "PT5M",
                                },
                                "scaleAction": {
                                    "cooldown": "PT5M",
                                    "direction": "Increase",
                                    "type": "ChangeCount",
                                    "value": "1",
                                },
                            },
                            {
                                "metricTrigger": {
                                    "dividePerInstance": False,
                                    "metricName": "Percentage CPU",
                                    "metricResourceUri": "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
                                    "operator": "GreaterThan",
                                    "statistic": "Average",
                                    "threshold": 15,
                                    "timeAggregation": "Average",
                                    "timeGrain": "PT2M",
                                    "timeWindow": "PT5M",
                                },
                                "scaleAction": {
                                    "cooldown": "PT6M",
                                    "direction": "Decrease",
                                    "type": "ChangeCount",
                                    "value": "2",
                                },
                            },
                        ],
                    },
                    {
                        "capacity": {"default": "1", "maximum": "10", "minimum": "1"},
                        "name": "saludos",
                        "recurrence": {
                            "frequency": "Week",
                            "schedule": {"days": ["1"], "hours": [5], "minutes": [15], "timeZone": "UTC"},
                        },
                        "rules": [
                            {
                                "metricTrigger": {
                                    "dividePerInstance": False,
                                    "metricName": "Percentage CPU",
                                    "metricResourceUri": "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
                                    "operator": "GreaterThan",
                                    "statistic": "Average",
                                    "threshold": 10,
                                    "timeAggregation": "Average",
                                    "timeGrain": "PT1M",
                                    "timeWindow": "PT5M",
                                },
                                "scaleAction": {
                                    "cooldown": "PT5M",
                                    "direction": "Increase",
                                    "type": "ChangeCount",
                                    "value": "1",
                                },
                            },
                            {
                                "metricTrigger": {
                                    "dividePerInstance": False,
                                    "metricName": "Percentage CPU",
                                    "metricResourceUri": "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
                                    "operator": "GreaterThan",
                                    "statistic": "Average",
                                    "threshold": 15,
                                    "timeAggregation": "Average",
                                    "timeGrain": "PT2M",
                                    "timeWindow": "PT5M",
                                },
                                "scaleAction": {
                                    "cooldown": "PT6M",
                                    "direction": "Decrease",
                                    "type": "ChangeCount",
                                    "value": "2",
                                },
                            },
                        ],
                    },
                ],
                "targetResourceUri": "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/TestingMetricsScaleSet/providers/Microsoft.Compute/virtualMachineScaleSets/testingsc",
            },
            "tags": {"key1": "value1", "key2": "value2"},
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-10-01/examples/createOrUpdateAutoscaleSetting.json
if __name__ == "__main__":
    main()
