# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Action(_model_base.Model):
    """The action that will be executed.

    :ivar action_type: The type of the action. Known values are: "EmailContacts" and "AutoRenew".
    :vartype action_type: str or ~azure.keyvault.certificates._generated.models.CertificatePolicyAction
    """

    action_type: Optional[Union[str, "_models.CertificatePolicyAction"]] = rest_field()
    """The type of the action. Known values are: \"EmailContacts\" and \"AutoRenew\"."""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.CertificatePolicyAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdministratorDetails(_model_base.Model):
    """Details of the organization administrator of the certificate issuer.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    first_name: Optional[str] = rest_field()
    """First name."""
    last_name: Optional[str] = rest_field()
    """Last name."""
    email_address: Optional[str] = rest_field(name="email")
    """Email address."""
    phone: Optional[str] = rest_field()
    """Phone number."""

    @overload
    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupCertificateResult(_model_base.Model):
    """The backup certificate result, containing the backup blob.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The backup blob containing the backed up certificate.
    :vartype value: bytes
    """

    value: Optional[bytes] = rest_field(visibility=["read"], format="base64url")
    """The backup blob containing the backed up certificate."""


class CertificateAttributes(_model_base.Model):
    """The certificate management attributes.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recoverable_days: softDelete data retention days. Value should be >=7 and <=90 when
     softDelete enabled, otherwise 0.
    :vartype recoverable_days: int
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for certificates
     in the current vault. If it contains 'Purgeable', the certificate can be permanently deleted by
     a privileged user; otherwise, only the system can purge the certificate, at the end of the
     retention interval. Known values are: "Purgeable", "Recoverable+Purgeable", "Recoverable",
     "Recoverable+ProtectedSubscription", "CustomizedRecoverable+Purgeable",
     "CustomizedRecoverable", and "CustomizedRecoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.certificates._generated.models.DeletionRecoveryLevel
    """

    enabled: Optional[bool] = rest_field()
    """Determines whether the object is enabled."""
    not_before: Optional[datetime.datetime] = rest_field(name="nbf", format="unix-timestamp")
    """Not before date in UTC."""
    expires: Optional[datetime.datetime] = rest_field(name="exp", format="unix-timestamp")
    """Expiry date in UTC."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Creation time in UTC."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Last updated time in UTC."""
    recoverable_days: Optional[int] = rest_field(name="recoverableDays", visibility=["read"])
    """softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise
     0."""
    recovery_level: Optional[Union[str, "_models.DeletionRecoveryLevel"]] = rest_field(
        name="recoveryLevel", visibility=["read"]
    )
    """Reflects the deletion recovery level currently in effect for certificates in the current vault.
     If it contains 'Purgeable', the certificate can be permanently deleted by a privileged user;
     otherwise, only the system can purge the certificate, at the end of the retention interval.
     Known values are: \"Purgeable\", \"Recoverable+Purgeable\", \"Recoverable\",
     \"Recoverable+ProtectedSubscription\", \"CustomizedRecoverable+Purgeable\",
     \"CustomizedRecoverable\", and \"CustomizedRecoverable+ProtectedSubscription\"."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateBundle(_model_base.Model):
    """A certificate bundle consists of a certificate (X509) plus its attributes.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret. eg. 'application/x-pem-file' or
     'application/x-pkcs12',.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar preserve_cert_order: Specifies whether the certificate chain preserves its original
     order. The default value is false, which sets the leaf certificate at index 0.
    :vartype preserve_cert_order: bool
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The certificate id."""
    kid: Optional[str] = rest_field(visibility=["read"])
    """The key id."""
    sid: Optional[str] = rest_field(visibility=["read"])
    """The secret id."""
    x509_thumbprint: Optional[bytes] = rest_field(name="x5t", visibility=["read"], format="base64url")
    """Thumbprint of the certificate."""
    policy: Optional["_models.CertificatePolicy"] = rest_field(visibility=["read"])
    """The management policy."""
    cer: Optional[bytes] = rest_field(format="base64")
    """CER contents of x509 certificate."""
    content_type: Optional[str] = rest_field(name="contentType")
    """The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',."""
    attributes: Optional["_models.CertificateAttributes"] = rest_field()
    """The certificate attributes."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    preserve_cert_order: Optional[bool] = rest_field(name="preserveCertOrder")
    """Specifies whether the certificate chain preserves its original order. The default value is
     false, which sets the leaf certificate at index 0."""

    @overload
    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        preserve_cert_order: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateCreateParameters(_model_base.Model):
    """The certificate create parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar preserve_cert_order: Specifies whether the certificate chain preserves its original
     order. The default value is false, which sets the leaf certificate at index 0.
    :vartype preserve_cert_order: bool
    """

    certificate_policy: Optional["_models.CertificatePolicy"] = rest_field(name="policy")
    """The management policy for the certificate."""
    certificate_attributes: Optional["_models.CertificateAttributes"] = rest_field(name="attributes")
    """The attributes of the certificate (optional)."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    preserve_cert_order: Optional[bool] = rest_field(name="preserveCertOrder")
    """Specifies whether the certificate chain preserves its original order. The default value is
     false, which sets the leaf certificate at index 0."""

    @overload
    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        preserve_cert_order: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateImportParameters(_model_base.Model):
    """The certificate import parameters.

    All required parameters must be populated in order to send to server.

    :ivar base64_encoded_certificate: Base64 encoded representation of the certificate object to
     import. This certificate needs to contain the private key. Required.
    :vartype base64_encoded_certificate: str
    :ivar password: If the private key in base64EncodedCertificate is encrypted, the password used
     for encryption.
    :vartype password: str
    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar preserve_cert_order: Specifies whether the certificate chain preserves its original
     order. The default value is false, which sets the leaf certificate at index 0.
    :vartype preserve_cert_order: bool
    """

    base64_encoded_certificate: str = rest_field(name="value")
    """Base64 encoded representation of the certificate object to import. This certificate needs to
     contain the private key. Required."""
    password: Optional[str] = rest_field(name="pwd")
    """If the private key in base64EncodedCertificate is encrypted, the password used for encryption."""
    certificate_policy: Optional["_models.CertificatePolicy"] = rest_field(name="policy")
    """The management policy for the certificate."""
    certificate_attributes: Optional["_models.CertificateAttributes"] = rest_field(name="attributes")
    """The attributes of the certificate (optional)."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    preserve_cert_order: Optional[bool] = rest_field(name="preserveCertOrder")
    """Specifies whether the certificate chain preserves its original order. The default value is
     false, which sets the leaf certificate at index 0."""

    @overload
    def __init__(
        self,
        *,
        base64_encoded_certificate: str,
        password: Optional[str] = None,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        preserve_cert_order: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateIssuerItem(_model_base.Model):
    """The certificate issuer item containing certificate issuer metadata.

    :ivar id: Certificate Identifier.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    """

    id: Optional[str] = rest_field()
    """Certificate Identifier."""
    provider: Optional[str] = rest_field()
    """The issuer provider."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        provider: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateIssuerSetParameters(_model_base.Model):
    """The certificate issuer set parameters.

    All required parameters must be populated in order to send to server.

    :ivar provider: The issuer provider. Required.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.certificates._generated.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.certificates._generated.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.IssuerAttributes
    """

    provider: str = rest_field()
    """The issuer provider. Required."""
    credentials: Optional["_models.IssuerCredentials"] = rest_field()
    """The credentials to be used for the issuer."""
    organization_details: Optional["_models.OrganizationDetails"] = rest_field(name="org_details")
    """Details of the organization as provided to the issuer."""
    attributes: Optional["_models.IssuerAttributes"] = rest_field()
    """Attributes of the issuer object."""

    @overload
    def __init__(
        self,
        *,
        provider: str,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateIssuerUpdateParameters(_model_base.Model):
    """The certificate issuer update parameters.

    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.certificates._generated.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.certificates._generated.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.IssuerAttributes
    """

    provider: Optional[str] = rest_field()
    """The issuer provider."""
    credentials: Optional["_models.IssuerCredentials"] = rest_field()
    """The credentials to be used for the issuer."""
    organization_details: Optional["_models.OrganizationDetails"] = rest_field(name="org_details")
    """Details of the organization as provided to the issuer."""
    attributes: Optional["_models.IssuerAttributes"] = rest_field()
    """Attributes of the issuer object."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateItem(_model_base.Model):
    """The certificate item containing certificate metadata.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    """

    id: Optional[str] = rest_field()
    """Certificate identifier."""
    attributes: Optional["_models.CertificateAttributes"] = rest_field()
    """The certificate management attributes."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    x509_thumbprint: Optional[bytes] = rest_field(name="x5t", format="base64url")
    """Thumbprint of the certificate."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateMergeParameters(_model_base.Model):
    """The certificate merge parameters.

    All required parameters must be populated in order to send to server.

    :ivar x509_certificates: The certificate or the certificate chain to merge. Required.
    :vartype x509_certificates: list[bytes]
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    x509_certificates: List[bytes] = rest_field(name="x5c", format="base64")
    """The certificate or the certificate chain to merge. Required."""
    certificate_attributes: Optional["_models.CertificateAttributes"] = rest_field(name="attributes")
    """The attributes of the certificate (optional)."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""

    @overload
    def __init__(
        self,
        *,
        x509_certificates: List[bytes],
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateOperation(_model_base.Model):
    """A certificate operation is returned in case of asynchronous requests.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.certificates._generated.models.IssuerParameters
    :ivar csr: The certificate signing request (CSR) that is being used in the certificate
     operation.
    :vartype csr: bytes
    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation.
    :vartype cancellation_requested: bool
    :ivar status: Status of the certificate operation.
    :vartype status: str
    :ivar status_details: The status details of the certificate operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the certificate operation.
    :vartype error: ~azure.keyvault.certificates._generated.models.KeyVaultErrorError
    :ivar target: Location which contains the result of the certificate operation.
    :vartype target: str
    :ivar preserve_cert_order: Specifies whether the certificate chain preserves its original
     order. The default value is false, which sets the leaf certificate at index 0.
    :vartype preserve_cert_order: bool
    :ivar request_id: Identifier for the certificate operation.
    :vartype request_id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The certificate id."""
    issuer_parameters: Optional["_models.IssuerParameters"] = rest_field(name="issuer")
    """Parameters for the issuer of the X509 component of a certificate."""
    csr: Optional[bytes] = rest_field(format="base64")
    """The certificate signing request (CSR) that is being used in the certificate operation."""
    cancellation_requested: Optional[bool] = rest_field()
    """Indicates if cancellation was requested on the certificate operation."""
    status: Optional[str] = rest_field()
    """Status of the certificate operation."""
    status_details: Optional[str] = rest_field()
    """The status details of the certificate operation."""
    error: Optional["_models.KeyVaultErrorError"] = rest_field()
    """Error encountered, if any, during the certificate operation."""
    target: Optional[str] = rest_field()
    """Location which contains the result of the certificate operation."""
    preserve_cert_order: Optional[bool] = rest_field(name="preserveCertOrder")
    """Specifies whether the certificate chain preserves its original order. The default value is
     false, which sets the leaf certificate at index 0."""
    request_id: Optional[str] = rest_field()
    """Identifier for the certificate operation."""

    @overload
    def __init__(
        self,
        *,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        csr: Optional[bytes] = None,
        cancellation_requested: Optional[bool] = None,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.KeyVaultErrorError"] = None,
        target: Optional[str] = None,
        preserve_cert_order: Optional[bool] = None,
        request_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateOperationUpdateParameter(_model_base.Model):
    """The certificate operation update parameters.

    All required parameters must be populated in order to send to server.

    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation. Required.
    :vartype cancellation_requested: bool
    """

    cancellation_requested: bool = rest_field()
    """Indicates if cancellation was requested on the certificate operation. Required."""

    @overload
    def __init__(
        self,
        *,
        cancellation_requested: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificatePolicy(_model_base.Model):
    """Management policy for a certificate.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar key_properties: Properties of the key backing a certificate.
    :vartype key_properties: ~azure.keyvault.certificates._generated.models.KeyProperties
    :ivar secret_properties: Properties of the secret backing a certificate.
    :vartype secret_properties: ~azure.keyvault.certificates._generated.models.SecretProperties
    :ivar x509_certificate_properties: Properties of the X509 component of a certificate.
    :vartype x509_certificate_properties:
     ~azure.keyvault.certificates._generated.models.X509CertificateProperties
    :ivar lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
     certificate.
    :vartype lifetime_actions: list[~azure.keyvault.certificates._generated.models.LifetimeAction]
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.certificates._generated.models.IssuerParameters
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The certificate id."""
    key_properties: Optional["_models.KeyProperties"] = rest_field(name="key_props")
    """Properties of the key backing a certificate."""
    secret_properties: Optional["_models.SecretProperties"] = rest_field(name="secret_props")
    """Properties of the secret backing a certificate."""
    x509_certificate_properties: Optional["_models.X509CertificateProperties"] = rest_field(name="x509_props")
    """Properties of the X509 component of a certificate."""
    lifetime_actions: Optional[List["_models.LifetimeAction"]] = rest_field()
    """Actions that will be performed by Key Vault over the lifetime of a certificate."""
    issuer_parameters: Optional["_models.IssuerParameters"] = rest_field(name="issuer")
    """Parameters for the issuer of the X509 component of a certificate."""
    attributes: Optional["_models.CertificateAttributes"] = rest_field()
    """The certificate attributes."""

    @overload
    def __init__(
        self,
        *,
        key_properties: Optional["_models.KeyProperties"] = None,
        secret_properties: Optional["_models.SecretProperties"] = None,
        x509_certificate_properties: Optional["_models.X509CertificateProperties"] = None,
        lifetime_actions: Optional[List["_models.LifetimeAction"]] = None,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateRestoreParameters(_model_base.Model):
    """The certificate restore parameters.

    All required parameters must be populated in order to send to server.

    :ivar certificate_bundle_backup: The backup blob associated with a certificate bundle.
     Required.
    :vartype certificate_bundle_backup: bytes
    """

    certificate_bundle_backup: bytes = rest_field(name="value", format="base64url")
    """The backup blob associated with a certificate bundle. Required."""

    @overload
    def __init__(
        self,
        *,
        certificate_bundle_backup: bytes,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateUpdateParameters(_model_base.Model):
    """The certificate update parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    certificate_policy: Optional["_models.CertificatePolicy"] = rest_field(name="policy")
    """The management policy for the certificate."""
    certificate_attributes: Optional["_models.CertificateAttributes"] = rest_field(name="attributes")
    """The attributes of the certificate (optional)."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""

    @overload
    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Contact(_model_base.Model):
    """The contact information for the vault certificates.

    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar name: Name.
    :vartype name: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    email_address: Optional[str] = rest_field(name="email")
    """Email address."""
    name: Optional[str] = rest_field()
    """Name."""
    phone: Optional[str] = rest_field()
    """Phone number."""

    @overload
    def __init__(
        self,
        *,
        email_address: Optional[str] = None,
        name: Optional[str] = None,
        phone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Contacts(_model_base.Model):
    """The contacts for the vault certificates.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the contacts collection.
    :vartype id: str
    :ivar contact_list: The contact list for the vault certificates.
    :vartype contact_list: list[~azure.keyvault.certificates._generated.models.Contact]
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Identifier for the contacts collection."""
    contact_list: Optional[List["_models.Contact"]] = rest_field(name="contacts")
    """The contact list for the vault certificates."""

    @overload
    def __init__(
        self,
        *,
        contact_list: Optional[List["_models.Contact"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedCertificateBundle(_model_base.Model):
    """A Deleted Certificate consisting of its previous id, attributes and its tags, as well as
    information on when it will be purged.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.certificates._generated.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret. eg. 'application/x-pem-file' or
     'application/x-pkcs12',.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar preserve_cert_order: Specifies whether the certificate chain preserves its original
     order. The default value is false, which sets the leaf certificate at index 0.
    :vartype preserve_cert_order: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The certificate id."""
    kid: Optional[str] = rest_field(visibility=["read"])
    """The key id."""
    sid: Optional[str] = rest_field(visibility=["read"])
    """The secret id."""
    x509_thumbprint: Optional[bytes] = rest_field(name="x5t", visibility=["read"], format="base64url")
    """Thumbprint of the certificate."""
    policy: Optional["_models.CertificatePolicy"] = rest_field(visibility=["read"])
    """The management policy."""
    cer: Optional[bytes] = rest_field(format="base64")
    """CER contents of x509 certificate."""
    content_type: Optional[str] = rest_field(name="contentType")
    """The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',."""
    attributes: Optional["_models.CertificateAttributes"] = rest_field()
    """The certificate attributes."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    preserve_cert_order: Optional[bool] = rest_field(name="preserveCertOrder")
    """Specifies whether the certificate chain preserves its original order. The default value is
     false, which sets the leaf certificate at index 0."""
    recovery_id: Optional[str] = rest_field(name="recoveryId")
    """The url of the recovery object, used to identify and recover the deleted certificate."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the certificate is scheduled to be purged, in UTC."""
    deleted_date: Optional[datetime.datetime] = rest_field(
        name="deletedDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the certificate was deleted, in UTC."""

    @overload
    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        preserve_cert_order: Optional[bool] = None,
        recovery_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedCertificateItem(_model_base.Model):
    """The deleted certificate item containing metadata about the deleted certificate.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    id: Optional[str] = rest_field()
    """Certificate identifier."""
    attributes: Optional["_models.CertificateAttributes"] = rest_field()
    """The certificate management attributes."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Application specific metadata in the form of key-value pairs."""
    x509_thumbprint: Optional[bytes] = rest_field(name="x5t", format="base64url")
    """Thumbprint of the certificate."""
    recovery_id: Optional[str] = rest_field(name="recoveryId")
    """The url of the recovery object, used to identify and recover the deleted certificate."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the certificate is scheduled to be purged, in UTC."""
    deleted_date: Optional[datetime.datetime] = rest_field(
        name="deletedDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the certificate was deleted, in UTC."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
        recovery_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IssuerAttributes(_model_base.Model):
    """The attributes of an issuer managed by the Key Vault service.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the issuer is enabled.
    :vartype enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    enabled: Optional[bool] = rest_field()
    """Determines whether the issuer is enabled."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Creation time in UTC."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Last updated time in UTC."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IssuerBundle(_model_base.Model):
    """The issuer for Key Vault certificate.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the issuer object.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.certificates._generated.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.certificates._generated.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.certificates._generated.models.IssuerAttributes
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Identifier for the issuer object."""
    provider: Optional[str] = rest_field()
    """The issuer provider."""
    credentials: Optional["_models.IssuerCredentials"] = rest_field()
    """The credentials to be used for the issuer."""
    organization_details: Optional["_models.OrganizationDetails"] = rest_field(name="org_details")
    """Details of the organization as provided to the issuer."""
    attributes: Optional["_models.IssuerAttributes"] = rest_field()
    """Attributes of the issuer object."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IssuerCredentials(_model_base.Model):
    """The credentials to be used for the certificate issuer.

    :ivar account_id: The user name/account name/account id.
    :vartype account_id: str
    :ivar password: The password/secret/account key.
    :vartype password: str
    """

    account_id: Optional[str] = rest_field()
    """The user name/account name/account id."""
    password: Optional[str] = rest_field(name="pwd")
    """The password/secret/account key."""

    @overload
    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IssuerParameters(_model_base.Model):
    """Parameters for the issuer of the X509 component of a certificate.

    :ivar name: Name of the referenced issuer object or reserved names; for example, 'Self' or
     'Unknown'.
    :vartype name: str
    :ivar certificate_type: Certificate type as supported by the provider (optional); for example
     'OV-SSL', 'EV-SSL'.
    :vartype certificate_type: str
    :ivar certificate_transparency: Indicates if the certificates generated under this policy
     should be published to certificate transparency logs.
    :vartype certificate_transparency: bool
    """

    name: Optional[str] = rest_field()
    """Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'."""
    certificate_type: Optional[str] = rest_field(name="cty")
    """Certificate type as supported by the provider (optional); for example 'OV-SSL', 'EV-SSL'."""
    certificate_transparency: Optional[bool] = rest_field(name="cert_transparency")
    """Indicates if the certificates generated under this policy should be published to certificate
     transparency logs."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        certificate_type: Optional[str] = None,
        certificate_transparency: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyProperties(_model_base.Model):
    """Properties of the key pair backing a certificate.

    :ivar exportable: Indicates if the private key can be exported. Release policy must be provided
     when creating the first version of an exportable key.
    :vartype exportable: bool
    :ivar key_type: The type of key pair to be used for the certificate. Known values are: "EC",
     "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype key_type: str or ~azure.keyvault.certificates._generated.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar reuse_key: Indicates if the same key pair will be used on certificate renewal.
    :vartype reuse_key: bool
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve: str or ~azure.keyvault.certificates._generated.models.JsonWebKeyCurveName
    """

    exportable: Optional[bool] = rest_field()
    """Indicates if the private key can be exported. Release policy must be provided when creating the
     first version of an exportable key."""
    key_type: Optional[Union[str, "_models.JsonWebKeyType"]] = rest_field(name="kty")
    """The type of key pair to be used for the certificate. Known values are: \"EC\", \"EC-HSM\",
     \"RSA\", \"RSA-HSM\", \"oct\", and \"oct-HSM\"."""
    key_size: Optional[int] = rest_field()
    """The key size in bits. For example: 2048, 3072, or 4096 for RSA."""
    reuse_key: Optional[bool] = rest_field()
    """Indicates if the same key pair will be used on certificate renewal."""
    curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = rest_field(name="crv")
    """Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are: \"P-256\",
     \"P-384\", \"P-521\", and \"P-256K\"."""

    @overload
    def __init__(
        self,
        *,
        exportable: Optional[bool] = None,
        key_type: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_size: Optional[int] = None,
        reuse_key: Optional[bool] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultError(_model_base.Model):
    """The key vault error exception.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.certificates._generated.models.KeyVaultErrorError
    """

    error: Optional["_models.KeyVaultErrorError"] = rest_field(visibility=["read"])
    """The key vault server error."""


class KeyVaultErrorError(_model_base.Model):
    """KeyVaultErrorError.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.certificates._generated.models.KeyVaultErrorError
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    inner_error: Optional["_models.KeyVaultErrorError"] = rest_field(name="innererror", visibility=["read"])
    """The key vault server error."""


class LifetimeAction(_model_base.Model):
    """Action and its trigger that will be performed by Key Vault over the lifetime of a certificate.

    :ivar trigger: The condition that will execute the action.
    :vartype trigger: ~azure.keyvault.certificates._generated.models.Trigger
    :ivar action: The action that will be executed.
    :vartype action: ~azure.keyvault.certificates._generated.models.Action
    """

    trigger: Optional["_models.Trigger"] = rest_field()
    """The condition that will execute the action."""
    action: Optional["_models.Action"] = rest_field()
    """The action that will be executed."""

    @overload
    def __init__(
        self,
        *,
        trigger: Optional["_models.Trigger"] = None,
        action: Optional["_models.Action"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OrganizationDetails(_model_base.Model):
    """Details of the organization of the certificate issuer.

    :ivar id: Id of the organization.
    :vartype id: str
    :ivar admin_details: Details of the organization administrator.
    :vartype admin_details: list[~azure.keyvault.certificates._generated.models.AdministratorDetails]
    """

    id: Optional[str] = rest_field()
    """Id of the organization."""
    admin_details: Optional[List["_models.AdministratorDetails"]] = rest_field()
    """Details of the organization administrator."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        admin_details: Optional[List["_models.AdministratorDetails"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretProperties(_model_base.Model):
    """Properties of the key backing a certificate.

    :ivar content_type: The media type (MIME type).
    :vartype content_type: str
    """

    content_type: Optional[str] = rest_field(name="contentType")
    """The media type (MIME type)."""

    @overload
    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubjectAlternativeNames(_model_base.Model):
    """The subject alternate names of a X509 object.

    :ivar emails: Email addresses.
    :vartype emails: list[str]
    :ivar dns_names: Domain names.
    :vartype dns_names: list[str]
    :ivar upns: User principal names.
    :vartype upns: list[str]
    """

    emails: Optional[List[str]] = rest_field()
    """Email addresses."""
    dns_names: Optional[List[str]] = rest_field()
    """Domain names."""
    upns: Optional[List[str]] = rest_field()
    """User principal names."""

    @overload
    def __init__(
        self,
        *,
        emails: Optional[List[str]] = None,
        dns_names: Optional[List[str]] = None,
        upns: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Trigger(_model_base.Model):
    """A condition to be satisfied for an action to be executed.

    :ivar lifetime_percentage: Percentage of lifetime at which to trigger. Value should be between
     1 and 99.
    :vartype lifetime_percentage: int
    :ivar days_before_expiry: Days before expiry to attempt renewal. Value should be between 1 and
     validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between
     1 and 972 (36 * 27).
    :vartype days_before_expiry: int
    """

    lifetime_percentage: Optional[int] = rest_field()
    """Percentage of lifetime at which to trigger. Value should be between 1 and 99."""
    days_before_expiry: Optional[int] = rest_field()
    """Days before expiry to attempt renewal. Value should be between 1 and validity_in_months
     multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36 *
     27)."""

    @overload
    def __init__(
        self,
        *,
        lifetime_percentage: Optional[int] = None,
        days_before_expiry: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class X509CertificateProperties(_model_base.Model):
    """Properties of the X509 component of a certificate.

    :ivar subject: The subject name. Should be a valid X509 distinguished Name.
    :vartype subject: str
    :ivar ekus: The enhanced key usage.
    :vartype ekus: list[str]
    :ivar subject_alternative_names: The subject alternative names.
    :vartype subject_alternative_names: ~azure.keyvault.certificates._generated.models.SubjectAlternativeNames
    :ivar key_usage: Defines how the certificate's key may be used.
    :vartype key_usage: list[str or ~azure.keyvault.certificates._generated.models.KeyUsageType]
    :ivar validity_in_months: The duration that the certificate is valid in months.
    :vartype validity_in_months: int
    """

    subject: Optional[str] = rest_field()
    """The subject name. Should be a valid X509 distinguished Name."""
    ekus: Optional[List[str]] = rest_field()
    """The enhanced key usage."""
    subject_alternative_names: Optional["_models.SubjectAlternativeNames"] = rest_field(name="sans")
    """The subject alternative names."""
    key_usage: Optional[List[Union[str, "_models.KeyUsageType"]]] = rest_field()
    """Defines how the certificate's key may be used."""
    validity_in_months: Optional[int] = rest_field(name="validity_months")
    """The duration that the certificate is valid in months."""

    @overload
    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        ekus: Optional[List[str]] = None,
        subject_alternative_names: Optional["_models.SubjectAlternativeNames"] = None,
        key_usage: Optional[List[Union[str, "_models.KeyUsageType"]]] = None,
        validity_in_months: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
