# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._views_operations import (
    build_create_or_update_by_scope_request,
    build_create_or_update_request,
    build_delete_by_scope_request,
    build_delete_request,
    build_get_by_scope_request,
    build_get_request,
    build_list_by_scope_request,
    build_list_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ViewsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.costmanagement.aio.CostManagementClient`'s
        :attr:`views` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.View"]:
        """Lists all views by tenant and object.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either View or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.costmanagement.models.View]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ViewListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ViewListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/providers/Microsoft.CostManagement/views"}

    @distributed_trace
    def list_by_scope(self, scope: str, **kwargs: Any) -> AsyncIterable["_models.View"]:
        """Lists all views at the given scope.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either View or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.costmanagement.models.View]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ViewListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_scope_request(
                    scope=scope,
                    api_version=api_version,
                    template_url=self.list_by_scope.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ViewListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_scope.metadata = {"url": "/{scope}/providers/Microsoft.CostManagement/views"}

    @distributed_trace_async
    async def get(self, view_name: str, **kwargs: Any) -> _models.View:
        """Gets the view by view name.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param view_name: View name. Required.
        :type view_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.View] = kwargs.pop("cls", None)

        request = build_get_request(
            view_name=view_name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("View", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/providers/Microsoft.CostManagement/views/{viewName}"}

    @overload
    async def create_or_update(
        self, view_name: str, parameters: _models.View, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Required.
        :type parameters: ~azure.mgmt.costmanagement.models.View
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self, view_name: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self, view_name: str, parameters: Union[_models.View, IO], **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Is either a View
         type or a IO type. Required.
        :type parameters: ~azure.mgmt.costmanagement.models.View or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.View] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "View")

        request = build_create_or_update_request(
            view_name=view_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("View", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("View", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update.metadata = {"url": "/providers/Microsoft.CostManagement/views/{viewName}"}

    @distributed_trace_async
    async def delete(self, view_name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """The operation to delete a view.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param view_name: View name. Required.
        :type view_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            view_name=view_name,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/providers/Microsoft.CostManagement/views/{viewName}"}

    @distributed_trace_async
    async def get_by_scope(self, scope: str, view_name: str, **kwargs: Any) -> _models.View:
        """Gets the view for the defined scope by view name.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :param view_name: View name. Required.
        :type view_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.View] = kwargs.pop("cls", None)

        request = build_get_by_scope_request(
            scope=scope,
            view_name=view_name,
            api_version=api_version,
            template_url=self.get_by_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("View", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_scope.metadata = {"url": "/{scope}/providers/Microsoft.CostManagement/views/{viewName}"}

    @overload
    async def create_or_update_by_scope(
        self,
        scope: str,
        view_name: str,
        parameters: _models.View,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Required.
        :type parameters: ~azure.mgmt.costmanagement.models.View
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_by_scope(
        self, scope: str, view_name: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_by_scope(
        self, scope: str, view_name: str, parameters: Union[_models.View, IO], **kwargs: Any
    ) -> _models.View:
        """The operation to create or update a view. Update operation requires latest eTag to be set in
        the request. You may obtain the latest eTag by performing a get operation. Create operation
        does not require eTag.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :param view_name: View name. Required.
        :type view_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate View operation. Is either a View
         type or a IO type. Required.
        :type parameters: ~azure.mgmt.costmanagement.models.View or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: View or the result of cls(response)
        :rtype: ~azure.mgmt.costmanagement.models.View
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.View] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "View")

        request = build_create_or_update_by_scope_request(
            scope=scope,
            view_name=view_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_by_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("View", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("View", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_by_scope.metadata = {"url": "/{scope}/providers/Microsoft.CostManagement/views/{viewName}"}

    @distributed_trace_async
    async def delete_by_scope(  # pylint: disable=inconsistent-return-statements
        self, scope: str, view_name: str, **kwargs: Any
    ) -> None:
        """The operation to delete a view.

        .. seealso::
           - https://docs.microsoft.com/en-us/rest/api/costmanagement/

        :param scope: The scope associated with view operations. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         External Billing Account scope and
         'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         External Subscription scope. Required.
        :type scope: str
        :param view_name: View name. Required.
        :type view_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_by_scope_request(
            scope=scope,
            view_name=view_name,
            api_version=api_version,
            template_url=self.delete_by_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_by_scope.metadata = {"url": "/{scope}/providers/Microsoft.CostManagement/views/{viewName}"}
