# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EdifactSchemaReference(Model):
    """The Edifact schema reference.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id.
    :type message_id: str
    :param message_version: Required. The message version.
    :type message_version: str
    :param message_release: Required. The message release version.
    :type message_release: str
    :param sender_application_id: The sender application id.
    :type sender_application_id: str
    :param sender_application_qualifier: The sender application qualifier.
    :type sender_application_qualifier: str
    :param association_assigned_code: The association assigned code.
    :type association_assigned_code: str
    :param schema_name: Required. The schema name.
    :type schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'message_version': {'required': True},
        'message_release': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'sender_application_qualifier': {'key': 'senderApplicationQualifier', 'type': 'str'},
        'association_assigned_code': {'key': 'associationAssignedCode', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EdifactSchemaReference, self).__init__(**kwargs)
        self.message_id = kwargs.get('message_id', None)
        self.message_version = kwargs.get('message_version', None)
        self.message_release = kwargs.get('message_release', None)
        self.sender_application_id = kwargs.get('sender_application_id', None)
        self.sender_application_qualifier = kwargs.get('sender_application_qualifier', None)
        self.association_assigned_code = kwargs.get('association_assigned_code', None)
        self.schema_name = kwargs.get('schema_name', None)
