# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .artifact_properties import ArtifactProperties


class BatchConfigurationProperties(ArtifactProperties):
    """The batch configuration properties definition.

    All required parameters must be populated in order to send to Azure.

    :param created_time: The artifact creation time.
    :type created_time: datetime
    :param changed_time: The artifact changed time.
    :type changed_time: datetime
    :param metadata:
    :type metadata: object
    :param batch_group_name: Required. The name of the batch group.
    :type batch_group_name: str
    :param release_criteria: Required. The batch release criteria.
    :type release_criteria: ~azure.mgmt.logic.models.BatchReleaseCriteria
    """

    _validation = {
        'batch_group_name': {'required': True},
        'release_criteria': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'batch_group_name': {'key': 'batchGroupName', 'type': 'str'},
        'release_criteria': {'key': 'releaseCriteria', 'type': 'BatchReleaseCriteria'},
    }

    def __init__(self, **kwargs):
        super(BatchConfigurationProperties, self).__init__(**kwargs)
        self.batch_group_name = kwargs.get('batch_group_name', None)
        self.release_criteria = kwargs.get('release_criteria', None)
