# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResetPasswordPayload(Model):
    """Represents the payload for resetting passwords.

    All required parameters must be populated in order to send to Azure.

    :param environment_id: Required. The resourceId of the environment
    :type environment_id: str
    :param username: The username for which the password will be reset.
    :type username: str
    :param password: The password to assign to the user specified in
    :type password: str
    """

    _validation = {
        'environment_id': {'required': True},
    }

    _attribute_map = {
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, *, environment_id: str, username: str=None, password: str=None, **kwargs) -> None:
        super(ResetPasswordPayload, self).__init__(**kwargs)
        self.environment_id = environment_id
        self.username = username
        self.password = password
