# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ResponseBase(Model):
    """ResponseBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Identifiable

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Identifiable': 'Identifiable'}
    }

    def __init__(self, **kwargs):
        super(ResponseBase, self).__init__(**kwargs)
        self._type = None


class Identifiable(ResponseBase):
    """Defines the identity of a resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Response

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Response': 'Response'}
    }

    def __init__(self, **kwargs):
        super(Identifiable, self).__init__(**kwargs)
        self.id = None
        self._type = 'Identifiable'


class Response(Identifiable):
    """Defines a response. All schemas that could be returned at the root of a
    response should inherit from this.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Thing, SearchResponse, Answer, ErrorResponse

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Thing': 'Thing', 'SearchResponse': 'SearchResponse', 'Answer': 'Answer', 'ErrorResponse': 'ErrorResponse'}
    }

    def __init__(self, **kwargs):
        super(Response, self).__init__(**kwargs)
        self.contractual_rules = None
        self.web_search_url = None
        self._type = 'Response'


class Thing(Response):
    """Thing.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Place, Organization, CreativeWork, Intangible

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Place': 'Place', 'Organization': 'Organization', 'CreativeWork': 'CreativeWork', 'Intangible': 'Intangible'}
    }

    def __init__(self, **kwargs):
        super(Thing, self).__init__(**kwargs)
        self.name = None
        self.url = None
        self.image = None
        self.description = None
        self.entity_presentation_info = None
        self.bing_id = None
        self._type = 'Thing'


class Place(Thing):
    """Defines information about a local entity, such as a restaurant or hotel.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CivicStructure, LocalBusiness, TouristAttraction

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'CivicStructure': 'CivicStructure', 'LocalBusiness': 'LocalBusiness', 'TouristAttraction': 'TouristAttraction'}
    }

    def __init__(self, **kwargs):
        super(Place, self).__init__(**kwargs)
        self.address = None
        self.telephone = None
        self._type = 'Place'


class CivicStructure(Place):
    """CivicStructure.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Airport

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Airport': 'Airport'}
    }

    def __init__(self, **kwargs):
        super(CivicStructure, self).__init__(**kwargs)
        self._type = 'CivicStructure'


class Airport(CivicStructure):
    """Airport.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar iata_code:
    :vartype iata_code: str
    :ivar icao_code:
    :vartype icao_code: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'iata_code': {'readonly': True},
        'icao_code': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'iata_code': {'key': 'iataCode', 'type': 'str'},
        'icao_code': {'key': 'icaoCode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Airport, self).__init__(**kwargs)
        self.iata_code = None
        self.icao_code = None
        self._type = 'Airport'


class Answer(Response):
    """Answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchResultsAnswer

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'SearchResultsAnswer': 'SearchResultsAnswer'}
    }

    def __init__(self, **kwargs):
        super(Answer, self).__init__(**kwargs)
        self._type = 'Answer'


class ContractualRulesContractualRule(Model):
    """ContractualRulesContractualRule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContractualRulesAttribution

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'ContractualRules/Attribution': 'ContractualRulesAttribution'}
    }

    def __init__(self, **kwargs):
        super(ContractualRulesContractualRule, self).__init__(**kwargs)
        self.target_property_name = None
        self._type = None


class ContractualRulesAttribution(ContractualRulesContractualRule):
    """ContractualRulesAttribution.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContractualRulesLicenseAttribution,
    ContractualRulesLinkAttribution, ContractualRulesMediaAttribution,
    ContractualRulesTextAttribution

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
    }

    _subtype_map = {
        '_type': {'ContractualRules/LicenseAttribution': 'ContractualRulesLicenseAttribution', 'ContractualRules/LinkAttribution': 'ContractualRulesLinkAttribution', 'ContractualRules/MediaAttribution': 'ContractualRulesMediaAttribution', 'ContractualRules/TextAttribution': 'ContractualRulesTextAttribution'}
    }

    def __init__(self, **kwargs):
        super(ContractualRulesAttribution, self).__init__(**kwargs)
        self.must_be_close_to_content = None
        self._type = 'ContractualRules/Attribution'


class ContractualRulesLicenseAttribution(ContractualRulesAttribution):
    """Defines a contractual rule for license attribution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    :ivar license: The license under which the content may be used.
    :vartype license:
     ~azure.cognitiveservices.search.entitysearch.models.License
    :ivar license_notice: The license to display next to the targeted field.
    :vartype license_notice: str
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
        'license': {'readonly': True},
        'license_notice': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
        'license': {'key': 'license', 'type': 'License'},
        'license_notice': {'key': 'licenseNotice', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContractualRulesLicenseAttribution, self).__init__(**kwargs)
        self.license = None
        self.license_notice = None
        self._type = 'ContractualRules/LicenseAttribution'


class ContractualRulesLinkAttribution(ContractualRulesAttribution):
    """Defines a contractual rule for link attribution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    :param text: Required. The attribution text.
    :type text: str
    :param url: Required. The URL to the provider's website. Use text and URL
     to create the hyperlink.
    :type url: str
    :ivar optional_for_list_display: Indicates whether this provider's
     attribution is optional.
    :vartype optional_for_list_display: bool
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
        'text': {'required': True},
        'url': {'required': True},
        'optional_for_list_display': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
        'text': {'key': 'text', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'optional_for_list_display': {'key': 'optionalForListDisplay', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ContractualRulesLinkAttribution, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.url = kwargs.get('url', None)
        self.optional_for_list_display = None
        self._type = 'ContractualRules/LinkAttribution'


class ContractualRulesMediaAttribution(ContractualRulesAttribution):
    """Defines a contractual rule for media attribution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    :ivar url: The URL that you use to create of hyperlink of the media
     content. For example, if the target is an image, you would use the URL to
     make the image clickable.
    :vartype url: str
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContractualRulesMediaAttribution, self).__init__(**kwargs)
        self.url = None
        self._type = 'ContractualRules/MediaAttribution'


class ContractualRulesTextAttribution(ContractualRulesAttribution):
    """Defines a contractual rule for text attribution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    :param text: Required. The attribution text. Text attribution applies to
     the entity as a whole and should be displayed immediately following the
     entity presentation. If there are multiple text or link attribution rules
     that do not specify a target, you should concatenate them and display them
     using a "Data from:" label.
    :type text: str
    :ivar optional_for_list_display: Indicates whether this provider's
     attribution is optional.
    :vartype optional_for_list_display: bool
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
        'text': {'required': True},
        'optional_for_list_display': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
        'text': {'key': 'text', 'type': 'str'},
        'optional_for_list_display': {'key': 'optionalForListDisplay', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ContractualRulesTextAttribution, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.optional_for_list_display = None
        self._type = 'ContractualRules/TextAttribution'


class CreativeWork(Thing):
    """CreativeWork.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MediaObject, License

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    :ivar text:
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'MediaObject': 'MediaObject', 'License': 'License'}
    }

    def __init__(self, **kwargs):
        super(CreativeWork, self).__init__(**kwargs)
        self.thumbnail_url = None
        self.provider = None
        self.text = None
        self._type = 'CreativeWork'


class LocalBusiness(Place):
    """LocalBusiness.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EntertainmentBusiness, FoodEstablishment, LodgingBusiness

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'EntertainmentBusiness': 'EntertainmentBusiness', 'FoodEstablishment': 'FoodEstablishment', 'LodgingBusiness': 'LodgingBusiness'}
    }

    def __init__(self, **kwargs):
        super(LocalBusiness, self).__init__(**kwargs)
        self.price_range = None
        self.panoramas = None
        self.is_permanently_closed = None
        self.tag_line = None
        self._type = 'LocalBusiness'


class EntertainmentBusiness(LocalBusiness):
    """EntertainmentBusiness.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MovieTheater

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'MovieTheater': 'MovieTheater'}
    }

    def __init__(self, **kwargs):
        super(EntertainmentBusiness, self).__init__(**kwargs)
        self._type = 'EntertainmentBusiness'


class SearchResultsAnswer(Answer):
    """SearchResultsAnswer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Entities, Places

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.entitysearch.models.QueryContext
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'query_context': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
    }

    _subtype_map = {
        '_type': {'Entities': 'Entities', 'Places': 'Places'}
    }

    def __init__(self, **kwargs):
        super(SearchResultsAnswer, self).__init__(**kwargs)
        self.query_context = None
        self._type = 'SearchResultsAnswer'


class Entities(SearchResultsAnswer):
    """Defines an entity answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.entitysearch.models.QueryContext
    :ivar query_scenario: The supported query scenario. This field is set to
     DominantEntity or DisambiguationItem. The field is set to DominantEntity
     if Bing determines that only a single entity satisfies the request. For
     example, a book, movie, person, or attraction. If multiple entities could
     satisfy the request, the field is set to DisambiguationItem. For example,
     if the request uses the generic title of a movie franchise, the entity's
     type would likely be DisambiguationItem. But, if the request specifies a
     specific title from the franchise, the entity's type would likely be
     DominantEntity. Possible values include: 'DominantEntity',
     'DominantEntityWithDisambiguation', 'Disambiguation', 'List',
     'ListWithPivot'. Default value: "DominantEntity" .
    :vartype query_scenario: str or
     ~azure.cognitiveservices.search.entitysearch.models.EntityQueryScenario
    :param value: Required. A list of entities.
    :type value:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'query_context': {'readonly': True},
        'query_scenario': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'query_scenario': {'key': 'queryScenario', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Thing]'},
    }

    def __init__(self, **kwargs):
        super(Entities, self).__init__(**kwargs)
        self.query_scenario = None
        self.value = kwargs.get('value', None)
        self._type = 'Entities'


class EntitiesEntityPresentationInfo(Model):
    """Defines additional information about an entity such as type hints.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param entity_scenario: Required. The supported scenario. Possible values
     include: 'DominantEntity', 'DisambiguationItem', 'ListItem'. Default
     value: "DominantEntity" .
    :type entity_scenario: str or
     ~azure.cognitiveservices.search.entitysearch.models.EntityScenario
    :ivar entity_type_hints: A list of hints that indicate the entity's type.
     The list could contain a single hint such as Movie or a list of hints such
     as Place, LocalBusiness, Restaurant. Each successive hint in the array
     narrows the entity's type.
    :vartype entity_type_hints: list[str or
     ~azure.cognitiveservices.search.entitysearch.models.EntityType]
    :ivar entity_type_display_hint: A display version of the entity hint. For
     example, if entityTypeHints is Artist, this field may be set to American
     Singer.
    :vartype entity_type_display_hint: str
    """

    _validation = {
        'entity_scenario': {'required': True},
        'entity_type_hints': {'readonly': True},
        'entity_type_display_hint': {'readonly': True},
    }

    _attribute_map = {
        'entity_scenario': {'key': 'entityScenario', 'type': 'str'},
        'entity_type_hints': {'key': 'entityTypeHints', 'type': '[str]'},
        'entity_type_display_hint': {'key': 'entityTypeDisplayHint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntitiesEntityPresentationInfo, self).__init__(**kwargs)
        self.entity_scenario = kwargs.get('entity_scenario', "DominantEntity")
        self.entity_type_hints = None
        self.entity_type_display_hint = None


class Error(Model):
    """Defines the error that occurred.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code that identifies the category of
     error. Possible values include: 'None', 'ServerError', 'InvalidRequest',
     'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'.
     Default value: "None" .
    :type code: str or
     ~azure.cognitiveservices.search.entitysearch.models.ErrorCode
    :ivar sub_code: The error code that further helps to identify the error.
     Possible values include: 'UnexpectedError', 'ResourceError',
     'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue',
     'HttpNotAllowed', 'Blocked', 'AuthorizationMissing',
     'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
    :vartype sub_code: str or
     ~azure.cognitiveservices.search.entitysearch.models.ErrorSubCode
    :param message: Required. A description of the error.
    :type message: str
    :ivar more_details: A description that provides additional information
     about the error.
    :vartype more_details: str
    :ivar parameter: The parameter in the request that caused the error.
    :vartype parameter: str
    :ivar value: The parameter's value in the request that was not valid.
    :vartype value: str
    """

    _validation = {
        'code': {'required': True},
        'sub_code': {'readonly': True},
        'message': {'required': True},
        'more_details': {'readonly': True},
        'parameter': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'sub_code': {'key': 'subCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'more_details': {'key': 'moreDetails', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', "None")
        self.sub_code = None
        self.message = kwargs.get('message', None)
        self.more_details = None
        self.parameter = None
        self.value = None


class ErrorResponse(Response):
    """The top-level response that represents a failed request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :param errors: Required. A list of errors that describe the reasons why
     the request failed.
    :type errors:
     list[~azure.cognitiveservices.search.entitysearch.models.Error]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'errors': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self._type = 'ErrorResponse'


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class FoodEstablishment(LocalBusiness):
    """FoodEstablishment.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Restaurant

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Restaurant': 'Restaurant'}
    }

    def __init__(self, **kwargs):
        super(FoodEstablishment, self).__init__(**kwargs)
        self._type = 'FoodEstablishment'


class LodgingBusiness(LocalBusiness):
    """LodgingBusiness.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Hotel

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Hotel': 'Hotel'}
    }

    def __init__(self, **kwargs):
        super(LodgingBusiness, self).__init__(**kwargs)
        self._type = 'LodgingBusiness'


class Hotel(LodgingBusiness):
    """Hotel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    :ivar hotel_class:
    :vartype hotel_class: str
    :ivar amenities:
    :vartype amenities: list[str]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
        'hotel_class': {'readonly': True},
        'amenities': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
        'hotel_class': {'key': 'hotelClass', 'type': 'str'},
        'amenities': {'key': 'amenities', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(Hotel, self).__init__(**kwargs)
        self.hotel_class = None
        self.amenities = None
        self._type = 'Hotel'


class MediaObject(CreativeWork):
    """MediaObject.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageObject

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
    }

    _subtype_map = {
        '_type': {'ImageObject': 'ImageObject'}
    }

    def __init__(self, **kwargs):
        super(MediaObject, self).__init__(**kwargs)
        self.content_url = None
        self.host_page_url = None
        self.width = None
        self.height = None
        self._type = 'MediaObject'


class ImageObject(MediaObject):
    """Defines an image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    :ivar thumbnail: The URL to a thumbnail of the image
    :vartype thumbnail:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
        'thumbnail': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(ImageObject, self).__init__(**kwargs)
        self.thumbnail = None
        self._type = 'ImageObject'


class Intangible(Thing):
    """Intangible.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StructuredValue

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'StructuredValue': 'StructuredValue'}
    }

    def __init__(self, **kwargs):
        super(Intangible, self).__init__(**kwargs)
        self._type = 'Intangible'


class License(CreativeWork):
    """Defines the license under which the text or photo may be used.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    :ivar text:
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(License, self).__init__(**kwargs)
        self._type = 'License'


class MovieTheater(EntertainmentBusiness):
    """MovieTheater.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    :ivar screen_count:
    :vartype screen_count: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
        'screen_count': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
        'screen_count': {'key': 'screenCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(MovieTheater, self).__init__(**kwargs)
        self.screen_count = None
        self._type = 'MovieTheater'


class Organization(Thing):
    """Defines an organization.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Organization, self).__init__(**kwargs)
        self._type = 'Organization'


class Places(SearchResultsAnswer):
    """Defines a local entity answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.entitysearch.models.QueryContext
    :param value: Required. A list of local entities, such as restaurants or
     hotels.
    :type value:
     list[~azure.cognitiveservices.search.entitysearch.models.Thing]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'query_context': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'value': {'key': 'value', 'type': '[Thing]'},
    }

    def __init__(self, **kwargs):
        super(Places, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self._type = 'Places'


class StructuredValue(Intangible):
    """StructuredValue.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PostalAddress

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'PostalAddress': 'PostalAddress'}
    }

    def __init__(self, **kwargs):
        super(StructuredValue, self).__init__(**kwargs)
        self._type = 'StructuredValue'


class PostalAddress(StructuredValue):
    """Defines a postal address.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar street_address:
    :vartype street_address: str
    :ivar address_locality: The city where the street address is located. For
     example, Seattle.
    :vartype address_locality: str
    :ivar address_subregion:
    :vartype address_subregion: str
    :ivar address_region: The state or province code where the street address
     is located. This could be the two-letter code. For example, WA, or the
     full name , Washington.
    :vartype address_region: str
    :ivar postal_code: The zip code or postal code where the street address is
     located. For example, 98052.
    :vartype postal_code: str
    :ivar post_office_box_number:
    :vartype post_office_box_number: str
    :ivar address_country: The country/region where the street address is
     located. This could be the two-letter ISO code. For example, US, or the
     full name, United States.
    :vartype address_country: str
    :ivar country_iso: The two letter ISO code of this country. For example,
     US.
    :vartype country_iso: str
    :ivar neighborhood: The neighborhood where the street address is located.
     For example, Westlake.
    :vartype neighborhood: str
    :ivar address_region_abbreviation: Region Abbreviation. For example, WA.
    :vartype address_region_abbreviation: str
    :ivar text: The complete address. For example, 2100 Westlake Ave N,
     Bellevue, WA 98052.
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'street_address': {'readonly': True},
        'address_locality': {'readonly': True},
        'address_subregion': {'readonly': True},
        'address_region': {'readonly': True},
        'postal_code': {'readonly': True},
        'post_office_box_number': {'readonly': True},
        'address_country': {'readonly': True},
        'country_iso': {'readonly': True},
        'neighborhood': {'readonly': True},
        'address_region_abbreviation': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'street_address': {'key': 'streetAddress', 'type': 'str'},
        'address_locality': {'key': 'addressLocality', 'type': 'str'},
        'address_subregion': {'key': 'addressSubregion', 'type': 'str'},
        'address_region': {'key': 'addressRegion', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'post_office_box_number': {'key': 'postOfficeBoxNumber', 'type': 'str'},
        'address_country': {'key': 'addressCountry', 'type': 'str'},
        'country_iso': {'key': 'countryIso', 'type': 'str'},
        'neighborhood': {'key': 'neighborhood', 'type': 'str'},
        'address_region_abbreviation': {'key': 'addressRegionAbbreviation', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PostalAddress, self).__init__(**kwargs)
        self.street_address = None
        self.address_locality = None
        self.address_subregion = None
        self.address_region = None
        self.postal_code = None
        self.post_office_box_number = None
        self.address_country = None
        self.country_iso = None
        self.neighborhood = None
        self.address_region_abbreviation = None
        self.text = None
        self._type = 'PostalAddress'


class QueryContext(Model):
    """Defines the query context that Bing used for the request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param original_query: Required. The query string as specified in the
     request.
    :type original_query: str
    :ivar altered_query: The query string used by Bing to perform the query.
     Bing uses the altered query string if the original query string contained
     spelling mistakes. For example, if the query string is "saling downwind",
     the altered query string will be "sailing downwind". This field is
     included only if the original query string contains a spelling mistake.
    :vartype altered_query: str
    :ivar alteration_override_query: The query string to use to force Bing to
     use the original string. For example, if the query string is "saling
     downwind", the override query string will be "+saling downwind". Remember
     to encode the query string which results in "%2Bsaling+downwind". This
     field is included only if the original query string contains a spelling
     mistake.
    :vartype alteration_override_query: str
    :ivar adult_intent: A Boolean value that indicates whether the specified
     query has adult intent. The value is true if the query has adult intent;
     otherwise, false.
    :vartype adult_intent: bool
    :ivar ask_user_for_location: A Boolean value that indicates whether Bing
     requires the user's location to provide accurate results. If you specified
     the user's location by using the X-MSEdge-ClientIP and X-Search-Location
     headers, you can ignore this field. For location aware queries, such as
     "today's weather" or "restaurants near me" that need the user's location
     to provide accurate results, this field is set to true. For location aware
     queries that include the location (for example, "Seattle weather"), this
     field is set to false. This field is also set to false for queries that
     are not location aware, such as "best sellers".
    :vartype ask_user_for_location: bool
    """

    _validation = {
        'original_query': {'required': True},
        'altered_query': {'readonly': True},
        'alteration_override_query': {'readonly': True},
        'adult_intent': {'readonly': True},
        'ask_user_for_location': {'readonly': True},
    }

    _attribute_map = {
        'original_query': {'key': 'originalQuery', 'type': 'str'},
        'altered_query': {'key': 'alteredQuery', 'type': 'str'},
        'alteration_override_query': {'key': 'alterationOverrideQuery', 'type': 'str'},
        'adult_intent': {'key': 'adultIntent', 'type': 'bool'},
        'ask_user_for_location': {'key': 'askUserForLocation', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(QueryContext, self).__init__(**kwargs)
        self.original_query = kwargs.get('original_query', None)
        self.altered_query = None
        self.alteration_override_query = None
        self.adult_intent = None
        self.ask_user_for_location = None


class Restaurant(FoodEstablishment):
    """Restaurant.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    :ivar price_range: $$.
    :vartype price_range: str
    :ivar panoramas:
    :vartype panoramas:
     list[~azure.cognitiveservices.search.entitysearch.models.ImageObject]
    :ivar is_permanently_closed:
    :vartype is_permanently_closed: bool
    :ivar tag_line:
    :vartype tag_line: str
    :ivar accepts_reservations:
    :vartype accepts_reservations: bool
    :ivar reservation_url:
    :vartype reservation_url: str
    :ivar serves_cuisine:
    :vartype serves_cuisine: list[str]
    :ivar menu_url:
    :vartype menu_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
        'price_range': {'readonly': True},
        'panoramas': {'readonly': True},
        'is_permanently_closed': {'readonly': True},
        'tag_line': {'readonly': True},
        'accepts_reservations': {'readonly': True},
        'reservation_url': {'readonly': True},
        'serves_cuisine': {'readonly': True},
        'menu_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
        'price_range': {'key': 'priceRange', 'type': 'str'},
        'panoramas': {'key': 'panoramas', 'type': '[ImageObject]'},
        'is_permanently_closed': {'key': 'isPermanentlyClosed', 'type': 'bool'},
        'tag_line': {'key': 'tagLine', 'type': 'str'},
        'accepts_reservations': {'key': 'acceptsReservations', 'type': 'bool'},
        'reservation_url': {'key': 'reservationUrl', 'type': 'str'},
        'serves_cuisine': {'key': 'servesCuisine', 'type': '[str]'},
        'menu_url': {'key': 'menuUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Restaurant, self).__init__(**kwargs)
        self.accepts_reservations = None
        self.reservation_url = None
        self.serves_cuisine = None
        self.menu_url = None
        self._type = 'Restaurant'


class SearchResponse(Response):
    """Defines the top-level object that the response includes when the request
    succeeds.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar query_context: An object that contains the query string that Bing
     used for the request. This object contains the query string as entered by
     the user. It may also contain an altered query string that Bing used for
     the query if the query string contained a spelling mistake.
    :vartype query_context:
     ~azure.cognitiveservices.search.entitysearch.models.QueryContext
    :ivar entities: A list of entities that are relevant to the search query.
    :vartype entities:
     ~azure.cognitiveservices.search.entitysearch.models.Entities
    :ivar places: A list of local entities such as restaurants or hotels that
     are relevant to the query.
    :vartype places:
     ~azure.cognitiveservices.search.entitysearch.models.Places
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'query_context': {'readonly': True},
        'entities': {'readonly': True},
        'places': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'entities': {'key': 'entities', 'type': 'Entities'},
        'places': {'key': 'places', 'type': 'Places'},
    }

    def __init__(self, **kwargs):
        super(SearchResponse, self).__init__(**kwargs)
        self.query_context = None
        self.entities = None
        self.places = None
        self._type = 'SearchResponse'


class TouristAttraction(Place):
    """TouristAttraction.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar contractual_rules: A list of rules that you must adhere to if you
     display the item.
    :vartype contractual_rules:
     list[~azure.cognitiveservices.search.entitysearch.models.ContractualRulesContractualRule]
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.entitysearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar entity_presentation_info: Additional information about the entity
     such as hints that you can use to determine the entity's type. To
     determine the entity's type, use the entityScenario and entityTypeHint
     fields.
    :vartype entity_presentation_info:
     ~azure.cognitiveservices.search.entitysearch.models.EntitiesEntityPresentationInfo
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar address: The postal address of where the entity is located
    :vartype address:
     ~azure.cognitiveservices.search.entitysearch.models.PostalAddress
    :ivar telephone: The entity's telephone number
    :vartype telephone: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'contractual_rules': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'entity_presentation_info': {'readonly': True},
        'bing_id': {'readonly': True},
        'address': {'readonly': True},
        'telephone': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'contractual_rules': {'key': 'contractualRules', 'type': '[ContractualRulesContractualRule]'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'entity_presentation_info': {'key': 'entityPresentationInfo', 'type': 'EntitiesEntityPresentationInfo'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'PostalAddress'},
        'telephone': {'key': 'telephone', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TouristAttraction, self).__init__(**kwargs)
        self._type = 'TouristAttraction'
