# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApiDefinitionInfo(Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, *, url: str=None, **kwargs) -> None:
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = url


class AppServiceCertificate(Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values
     include: 'Initialized', 'WaitingOnCertificateOrder', 'Succeeded',
     'CertificateOrderFailed', 'OperationNotPermittedOnKeyVault',
     'AzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultDoesNotExist',
     'KeyVaultSecretDoesNotExist', 'UnknownError', 'ExternalPrivateKey',
     'Unknown'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'KeyVaultSecretStatus'},
    }

    def __init__(self, *, key_vault_id: str=None, key_vault_secret_name: str=None, **kwargs) -> None:
        super(AppServiceCertificate, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class Resource(Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, kind: str=None, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str,
     ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
     Default value: 1 .
    :type validity_in_years: int
    :param key_size: Certificate key size. Default value: 2048 .
    :type key_size: int
    :param product_type: Required. Certificate product type. Possible values
     include: 'StandardDomainValidatedSsl',
     'StandardDomainValidatedWildCardSsl'
    :type product_type: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :param auto_renew: <code>true</code> if the certificate should be
     automatically renewed when it expires; otherwise, <code>false</code>.
     Default value: True .
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values
     include: 'Succeeded', 'Failed', 'Canceled', 'InProgress', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include:
     'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied',
     'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
    :vartype status: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate:
     ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate:
     ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: datetime
    :ivar is_private_key_external: <code>true</code> if private key is
     external; otherwise, <code>false</code>.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App
     Service Certificate is not renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would
     be auto renewed next
    :vartype next_auto_renewal_time_stamp: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'product_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'CertificateProductType'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'status': {'key': 'properties.status', 'type': 'CertificateOrderStatus'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(self, *, location: str, product_type, kind: str=None, tags=None, certificates=None, distinguished_name: str=None, validity_in_years: int=1, key_size: int=2048, auto_renew: bool=True, csr: str=None, **kwargs) -> None:
        super(AppServiceCertificateOrder, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class ProxyOnlyResource(Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource
    Manager.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, **kwargs) -> None:
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str,
     ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be between 1 and 3).
     Default value: 1 .
    :type validity_in_years: int
    :param key_size: Certificate key size. Default value: 2048 .
    :type key_size: int
    :param product_type: Required. Certificate product type. Possible values
     include: 'StandardDomainValidatedSsl',
     'StandardDomainValidatedWildCardSsl'
    :type product_type: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :param auto_renew: <code>true</code> if the certificate should be
     automatically renewed when it expires; otherwise, <code>false</code>.
     Default value: True .
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values
     include: 'Succeeded', 'Failed', 'Canceled', 'InProgress', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include:
     'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied',
     'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
    :vartype status: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate:
     ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate:
     ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: datetime
    :ivar is_private_key_external: <code>true</code> if private key is
     external; otherwise, <code>false</code>.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App
     Service Certificate is not renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would
     be auto renewed next
    :vartype next_auto_renewal_time_stamp: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'validity_in_years': {'maximum': 3, 'minimum': 1},
        'product_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'CertificateProductType'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'status': {'key': 'properties.status', 'type': 'CertificateOrderStatus'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(self, *, product_type, kind: str=None, certificates=None, distinguished_name: str=None, validity_in_years: int=1, key_size: int=2048, auto_renew: bool=True, csr: str=None, **kwargs) -> None:
        super(AppServiceCertificateOrderPatchResource, self).__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased
    through Azure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values
     include: 'Initialized', 'WaitingOnCertificateOrder', 'Succeeded',
     'CertificateOrderFailed', 'OperationNotPermittedOnKeyVault',
     'AzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultDoesNotExist',
     'KeyVaultSecretDoesNotExist', 'UnknownError', 'ExternalPrivateKey',
     'Unknown'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'KeyVaultSecretStatus'},
    }

    def __init__(self, *, kind: str=None, key_vault_id: str=None, key_vault_secret_name: str=None, **kwargs) -> None:
        super(AppServiceCertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased
    through Azure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values
     include: 'Initialized', 'WaitingOnCertificateOrder', 'Succeeded',
     'CertificateOrderFailed', 'OperationNotPermittedOnKeyVault',
     'AzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultDoesNotExist',
     'KeyVaultSecretDoesNotExist', 'UnknownError', 'ExternalPrivateKey',
     'Unknown'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'KeyVaultSecretStatus'},
    }

    def __init__(self, *, location: str, kind: str=None, tags=None, key_vault_id: str=None, key_vault_secret_name: str=None, **kwargs) -> None:
        super(AppServiceCertificateResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param app_service_plan_name: Required. Name for the App Service plan.
    :type app_service_plan_name: str
    :param worker_tier_name: Target worker tier assigned to the App Service
     plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: 'Ready',
     'Pending', 'Creating'
    :vartype status: str or ~azure.mgmt.web.v2015_08_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param admin_site_name: App Service plan administration site.
    :type admin_site_name: str
    :param hosting_environment_profile: Specification for the App Service
     Environment to use for the App Service plan.
    :type hosting_environment_profile:
     ~azure.mgmt.web.v2015_08_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be
     assigned to this App Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If <code>true</code>, apps assigned to this App
     Service plan can be scaled independently.
     If <code>false</code>, apps assigned to this App Service plan will scale
     to all instances of the plan. Default value: False .
    :type per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If <code>true</code>, this App Service Plan owns spot
     instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid
     only if it is a spot server farm.
    :type spot_expiration_time: datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan <code>true</code>,
     <code>false</code> otherwise. Default value: False .
    :type reserved: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service
     Environment. Possible values include: 'Succeeded', 'Failed', 'Canceled',
     'InProgress', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :param sku:
    :type sku: ~azure.mgmt.web.v2015_08_01.models.SkuDescription
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'app_service_plan_name': {'required': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'app_service_plan_name': {'key': 'properties.name', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'StatusOptions'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'admin_site_name': {'key': 'properties.adminSiteName', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
    }

    def __init__(self, *, location: str, app_service_plan_name: str, kind: str=None, tags=None, worker_tier_name: str=None, admin_site_name: str=None, hosting_environment_profile=None, per_site_scaling: bool=False, is_spot: bool=None, spot_expiration_time=None, reserved: bool=False, target_worker_count: int=None, target_worker_size_id: int=None, sku=None, **kwargs) -> None:
        super(AppServicePlan, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.app_service_plan_name = app_service_plan_name
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None
        self.sku = sku


class AutoHealActions(Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values
     include: 'Recycle', 'LogEvent', 'CustomAction'
    :type action_type: str or
     ~azure.mgmt.web.v2015_08_01.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action:
     ~azure.mgmt.web.v2015_08_01.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'AutoHealActionType'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(self, *, action_type=None, custom_action=None, min_process_execution_time: str=None, **kwargs) -> None:
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(self, *, exe: str=None, parameters: str=None, **kwargs) -> None:
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal
     actions.
    :type triggers: ~azure.mgmt.web.v2015_08_01.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.v2015_08_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(self, *, triggers=None, actions=None, **kwargs) -> None:
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.v2015_08_01.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes:
     list[~azure.mgmt.web.v2015_08_01.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests:
     ~azure.mgmt.web.v2015_08_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(self, *, requests=None, private_bytes_in_kb: int=None, status_codes=None, slow_requests=None, **kwargs) -> None:
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class Capability(Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :param name: Name of the SKU capability.
    :type name: str
    :param value: Value of the SKU capability.
    :type value: str
    :param reason: Reason of the SKU capability.
    :type reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, reason: str=None, **kwargs) -> None:
        super(Capability, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class CertificateDetails(Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        'version': {'readonly': True},
        'serial_number': {'readonly': True},
        'thumbprint': {'readonly': True},
        'subject': {'readonly': True},
        'not_before': {'readonly': True},
        'not_after': {'readonly': True},
        'signature_algorithm': {'readonly': True},
        'issuer': {'readonly': True},
        'raw_data': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'not_before': {'key': 'notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'raw_data': {'key': 'rawData', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CertificateDetails, self).__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param email_id: Email id.
    :type email_id: str
    :param time_stamp: Time stamp.
    :type time_stamp: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email_id': {'key': 'properties.emailId', 'type': 'str'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
    }

    def __init__(self, *, kind: str=None, email_id: str=None, time_stamp=None, **kwargs) -> None:
        super(CertificateEmail, self).__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param certificate_order_action_type: Action type. Possible values
     include: 'CertificateIssued', 'CertificateOrderCanceled',
     'CertificateOrderCreated', 'CertificateRevoked',
     'DomainValidationComplete', 'FraudDetected', 'OrgNameChange',
     'OrgValidationComplete', 'SanDrop', 'FraudCleared', 'CertificateExpired',
     'CertificateExpirationWarning', 'FraudDocumentationRequired', 'Unknown'
    :type certificate_order_action_type: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateOrderActionType
    :param created_at: Time at which the certificate action was performed.
    :type created_at: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificate_order_action_type': {'key': 'properties.type', 'type': 'CertificateOrderActionType'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, kind: str=None, certificate_order_action_type=None, created_at=None, **kwargs) -> None:
        super(CertificateOrderAction, self).__init__(kind=kind, **kwargs)
        self.certificate_order_action_type = certificate_order_action_type
        self.created_at = created_at


class CloningInfo(Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties
     multiple cloning operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: <code>true</code> to overwrite destination app;
     otherwise, <code>false</code>.
    :type overwrite: bool
    :param clone_custom_host_names: <code>true</code> to clone custom
     hostnames from source app; otherwise, <code>false</code>.
    :type clone_custom_host_names: bool
    :param clone_source_control: <code>true</code> to clone source control
     from source app; otherwise, <code>false</code>.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App
     resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned
     app. If specified, these settings override the settings cloned
     from source app. Otherwise, application settings from source app are
     retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: <code>true</code> to configure load
     balancing for source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager
     profile to use, if it exists. Traffic Manager resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to
     create. This is only needed if Traffic Manager profile does not already
     exist.
    :type traffic_manager_profile_name: str
    :param ignore_quotas: <code>true</code> if quotas should be ignored;
     otherwise, <code>false</code>.
    :type ignore_quotas: bool
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
        'ignore_quotas': {'key': 'ignoreQuotas', 'type': 'bool'},
    }

    def __init__(self, *, source_web_app_id: str, correlation_id: str=None, overwrite: bool=None, clone_custom_host_names: bool=None, clone_source_control: bool=None, hosting_environment: str=None, app_settings_overrides=None, configure_load_balancing: bool=None, traffic_manager_profile_id: str=None, traffic_manager_profile_name: str=None, ignore_quotas: bool=None, **kwargs) -> None:
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name
        self.ignore_quotas = ignore_quotas


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConnStringInfo(Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: 'MySql',
     'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus',
     'EventHub', 'ApiHub', 'DocDb', 'RedisCache', 'PostgreSQL'
    :type type: str or ~azure.mgmt.web.v2015_08_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ConnectionStringType'},
    }

    def __init__(self, *, name: str=None, connection_string: str=None, type=None, **kwargs) -> None:
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class CorsSettings(Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be
     allowed to make cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
    }

    def __init__(self, *, allowed_origins=None, **kwargs) -> None:
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins


class CsmOperationDescription(Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDisplay
    :param origin:
    :type origin: str
    :param properties:
    :type properties:
     ~azure.mgmt.web.v2015_08_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, properties=None, **kwargs) -> None:
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :param service_specification:
    :type service_specification:
     ~azure.mgmt.web.v2015_08_01.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, *, service_specification=None, **kwargs) -> None:
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(Model):
    """Meta data about operation used for display in portal.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Dimension(Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests
    for a web app,
    where instance name is dimension of the metric HTTP request.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param internal_name:
    :type internal_name: str
    :param to_be_exported_for_shoebox:
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, internal_name: str=None, to_be_exported_for_shoebox: bool=None, **kwargs) -> None:
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Experiments(Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.v2015_08_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(self, *, ramp_up_rules=None, **kwargs) -> None:
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class HandlerMapping(Model):
    """The IIS handler mappings used to define which handler processes HTTP
    requests with certain extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP
    requests with *.php extension.

    :param extension: Requests with this extension will be handled using the
     specified FastCGI application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script
     processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(self, *, extension: str=None, script_processor: str=None, arguments: str=None, **kwargs) -> None:
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentProfile(Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostNameSslState(Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: 'Disabled',
     'SniEnabled', 'IpBasedEnabled'
    :type ssl_state: str or ~azure.mgmt.web.v2015_08_01.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based
     SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to <code>true</code> to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or
     repository hostname. Possible values include: 'Standard', 'Repository'
    :type host_type: str or ~azure.mgmt.web.v2015_08_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'SslState'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'HostType'},
    }

    def __init__(self, *, name: str=None, ssl_state=None, virtual_ip: str=None, thumbprint: str=None, to_update: bool=None, host_type=None, **kwargs) -> None:
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send
     permissions. This is used to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to
     authenticate to Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By
     default this is .servicebus.windows.net
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, service_bus_namespace: str=None, relay_name: str=None, relay_arm_uri: str=None, hostname: str=None, port: int=None, send_key_name: str=None, send_key_value: str=None, service_bus_suffix: str=None, **kwargs) -> None:
        super(HybridConnection, self).__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a
    Hybrid Connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, **kwargs) -> None:
        super(HybridConnectionKey, self).__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param identifier_id: String representation of the identity.
    :type identifier_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, identifier_id: str=None, **kwargs) -> None:
        super(Identifier, self).__init__(kind=kind, **kwargs)
        self.identifier_id = identifier_id


class IpSecurityRestriction(Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to Azure.

    :param ip_address: Required. IP address the security restriction is valid
     for.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the
     restriction is valid for.
    :type subnet_mask: str
    """

    _validation = {
        'ip_address': {'required': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
    }

    def __init__(self, *, ip_address: str, subnet_mask: str=None, **kwargs) -> None:
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask


class ManagedServiceIdentity(Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: Type of managed service identity. Possible values include:
     'SystemAssigned'
    :type type: str or
     ~azure.mgmt.web.v2015_08_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None


class MetricAvailability(Model):
    """Retention policy of a resource metric.

    :param time_grain:
    :type time_grain: str
    :param blob_duration:
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, time_grain: str=None, blob_duration: str=None, **kwargs) -> None:
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(Model):
    """Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param display_description:
    :type display_description: str
    :param unit:
    :type unit: str
    :param aggregation_type:
    :type aggregation_type: str
    :param supports_instance_level_aggregation:
    :type supports_instance_level_aggregation: bool
    :param enable_regional_mdm_account:
    :type enable_regional_mdm_account: bool
    :param source_mdm_account:
    :type source_mdm_account: str
    :param source_mdm_namespace:
    :type source_mdm_namespace: str
    :param metric_filter_pattern:
    :type metric_filter_pattern: str
    :param fill_gap_with_zero:
    :type fill_gap_with_zero: bool
    :param is_internal:
    :type is_internal: bool
    :param dimensions:
    :type dimensions: list[~azure.mgmt.web.v2015_08_01.models.Dimension]
    :param category:
    :type category: str
    :param availabilities:
    :type availabilities:
     list[~azure.mgmt.web.v2015_08_01.models.MetricAvailability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, aggregation_type: str=None, supports_instance_level_aggregation: bool=None, enable_regional_mdm_account: bool=None, source_mdm_account: str=None, source_mdm_namespace: str=None, metric_filter_pattern: str=None, fill_gap_with_zero: bool=None, is_internal: bool=None, dimensions=None, category: str=None, availabilities=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class NameIdentifier(Model):
    """Identifies an object.

    :param name: Name of the object.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = name


class NameValuePair(Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, **kwargs) -> None:
        super(NameValuePair, self).__init__(**kwargs)
        self.name = name
        self.value = value


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Required. Gets or sets a flag indicating whether
     the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of
     tags that are whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list
     of tags that require user authentication to be used in the push
     registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of
     dynamic tags that will be evaluated from user claims in the push
     registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_push_enabled': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(self, *, is_push_enabled: bool, kind: str=None, tag_whitelist_json: str=None, tags_requiring_auth: str=None, dynamic_tags_json: str=None, **kwargs) -> None:
        super(PushSettings, self).__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(Model):
    """Routing rules for ramp up testing. This rule allows to redirect static
    traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be
     redirected if decided to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be
     redirected to <code>ActionHostName</code>.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to
     add/remove from <code>ReroutePercentage</code> until it reaches
     <code>MinReroutePercentage</code> or <code>MaxReroutePercentage</code>.
     Site metrics are checked every N minutes specified in
     <code>ChangeIntervalInMinutes</code>.
     Custom decision algorithm can be provided in TiPCallback site extension
     which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to
     reevaluate ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which
     ReroutePercentage will stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which
     ReroutePercentage will stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be
     provided in TiPCallback site extension which URL can be specified. See
     TiPCallback site extension for the scaffold and contracts.
     https://www.siteextensions.net/packages/TiPCallback/
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to
     point to the slot which will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, action_host_name: str=None, reroute_percentage: float=None, change_step: float=None, change_interval_in_minutes: int=None, min_reroute_percentage: float=None, max_reroute_percentage: float=None, change_decision_callback_url: str=None, name: str=None, **kwargs) -> None:
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param delay_existing_revoke_in_hours: Delay in hours to revoke existing
     certificate after the new certificate is issued.
    :type delay_existing_revoke_in_hours: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from
     managed private key to external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'delay_existing_revoke_in_hours': {'key': 'properties.delayExistingRevokeInHours', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(self, *, kind: str=None, key_size: int=None, delay_existing_revoke_in_hours: int=None, csr: str=None, is_private_key_external: bool=None, **kwargs) -> None:
        super(ReissueCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from
     managed private key to external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(self, *, kind: str=None, key_size: int=None, csr: str=None, is_private_key_external: bool=None, **kwargs) -> None:
        super(RenewCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RequestsBasedTrigger(Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, *, count: int=None, time_interval: str=None, **kwargs) -> None:
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceMetricAvailability(Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_metric_definition_name: Name of the metric.
    :vartype resource_metric_definition_name:
     ~azure.mgmt.web.v2015_08_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric
     together with retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2015_08_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar resource_metric_definition_id: Resource ID.
    :vartype resource_metric_definition_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_metric_definition_name': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'resource_metric_definition_id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_metric_definition_name': {'key': 'properties.name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'resource_metric_definition_id': {'key': 'properties.id', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(self, *, kind: str=None, **kwargs) -> None:
        super(ResourceMetricDefinition, self).__init__(kind=kind, **kwargs)
        self.resource_metric_definition_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.resource_metric_definition_id = None
        self.properties = None


class ResourceMetricName(Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ResourceMetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ServiceSpecification(Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :param metric_specifications:
    :type metric_specifications:
     list[~azure.mgmt.web.v2015_08_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota
     usage. Read-only. Possible values include: 'Normal', 'Exceeded'
    :vartype usage_state: str or ~azure.mgmt.web.v2015_08_01.models.UsageState
    :param enabled: <code>true</code> if the app is enabled; otherwise,
     <code>false</code>. Setting this value to false disables the app (takes
     the app offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to
     be assigned (see HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for
     the app. Possible values include: 'Normal', 'Limited',
     'DisasterRecoveryMode'
    :vartype availability_state: str or
     ~azure.mgmt.web.v2015_08_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the
     SSL bindings for app's hostnames.
    :type host_name_ssl_states:
     list[~azure.mgmt.web.v2015_08_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan,
     formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: <code>true</code> if reserved; otherwise,
     <code>false</code>. Default value: False .
    :type reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC.
     Read-only.
    :vartype last_modified_time_utc: datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2015_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames
     associated with the app. Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: <code>true</code> to stop SCM (KUDU) site
     when the app is stopped; otherwise, <code>false</code>. The default is
     <code>false</code>. Default value: False .
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap
     into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the
     app.
    :type hosting_environment_profile:
     ~azure.mgmt.web.v2015_08_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: <code>true</code> to enable client
     affinity; <code>false</code> to stop sending session affinity cookies,
     which route client requests in the same session to the same instance.
     Default is <code>true</code>.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: <code>true</code> to enable client certificate
     authentication (TLS mutual authentication); otherwise, <code>false</code>.
     Default is <code>false</code>.
    :type client_cert_enabled: bool
    :param host_names_disabled: <code>true</code> to disable the public
     hostnames of the app; otherwise, <code>false</code>.
     If <code>true</code>, the app is only accessible via API management
     process.
    :type host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for
     outbound connections (e.g. database access). Includes VIPs from tenants
     that site can be hosted with current settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app
     uses for outbound connections (e.g. database access). Includes VIPs from
     all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota
     (applicable on dynamic apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is
     exceeded.
    :vartype suspended_till: datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned
     from a source app.
    :type cloning_info: ~azure.mgmt.web.v2015_08_01.models.CloningInfo
    :param snapshot_info: If specified during app creation, the app is created
     from a previous snapshot.
    :type snapshot_info:
     ~azure.mgmt.web.v2015_08_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to.
     Read-only.
    :vartype resource_group: str
    :ivar is_default_container: <code>true</code> if the app is a default
     container; otherwise, <code>false</code>.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status:
     ~azure.mgmt.web.v2015_08_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https
     requests. Issues redirect for
     http requests
    :type https_only: bool
    :param identity:
    :type identity: ~azure.mgmt.web.v2015_08_01.models.ManagedServiceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'UsageState'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'SiteAvailabilityState'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, location: str, kind: str=None, tags=None, enabled: bool=None, host_name_ssl_states=None, server_farm_id: str=None, reserved: bool=False, site_config=None, scm_site_also_stopped: bool=False, hosting_environment_profile=None, client_affinity_enabled: bool=None, client_cert_enabled: bool=None, host_names_disabled: bool=None, container_size: int=None, daily_memory_time_quota: int=None, cloning_info=None, snapshot_info=None, https_only: bool=None, identity=None, **kwargs) -> None:
        super(Site, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.snapshot_info = snapshot_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.identity = identity


class SiteConfig(Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version. Default value:
     "v4.6" .
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param linux_fx_version: Linux App Framework and version
    :type linux_fx_version: str
    :param request_tracing_enabled: <code>true</code> if request tracing is
     enabled; otherwise, <code>false</code>.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: datetime
    :param remote_debugging_enabled: <code>true</code> if remote debugging is
     enabled; otherwise, <code>false</code>.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: <code>true</code> if HTTP logging is enabled;
     otherwise, <code>false</code>.
    :type http_logging_enabled: bool
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: <code>true</code> if detailed error
     logging is enabled; otherwise, <code>false</code>.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2015_08_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings:
     list[~azure.mgmt.web.v2015_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2015_08_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings:
     list[~azure.mgmt.web.v2015_08_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: 'None', 'Dropbox',
     'Tfs', 'LocalGit', 'GitHub', 'CodePlexGit', 'CodePlexHg', 'BitbucketGit',
     'BitbucketHg', 'ExternalGit', 'ExternalHg', 'OneDrive', 'VSO'
    :type scm_type: str or ~azure.mgmt.web.v2015_08_01.models.ScmType
    :param use32_bit_worker_process: <code>true</code> to use 32-bit worker
     process; otherwise, <code>false</code>.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: <code>true</code> if WebSocket is enabled;
     otherwise, <code>false</code>.
    :type web_sockets_enabled: bool
    :param always_on: <code>true</code> if Always On is enabled; otherwise,
     <code>false</code>.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values
     include: 'Integrated', 'Classic'
    :type managed_pipeline_mode: str or
     ~azure.mgmt.web.v2015_08_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications:
     list[~azure.mgmt.web.v2015_08_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include:
     'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime',
     'WeightedTotalTraffic', 'RequestHash'
    :type load_balancing: str or
     ~azure.mgmt.web.v2015_08_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2015_08_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2015_08_01.models.SiteLimits
    :param auto_heal_enabled: <code>true</code> if Auto Heal is enabled;
     otherwise, <code>false</code>.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2015_08_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2015_08_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2015_08_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the
     app.
    :type api_definition: ~azure.mgmt.web.v2015_08_01.models.ApiDefinitionInfo
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: <code>true</code> to enable local MySQL;
     otherwise, <code>false</code>. Default value: False .
    :type local_my_sql_enabled: bool
    :param ip_security_restrictions: IP security restrictions.
    :type ip_security_restrictions:
     list[~azure.mgmt.web.v2015_08_01.models.IpSecurityRestriction]
    :param http20_enabled: Http20Enabled: configures a web site to allow
     clients to connect over http2.0. Default value: True .
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of
     TLS required for SSL requests. Possible values include: '1.0', '1.1',
     '1.2'
    :type min_tls_version: str or
     ~azure.mgmt.web.v2015_08_01.models.SupportedTlsVersions
    """

    _validation = {
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'ManagedPipelineMode'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'SiteLoadBalancing'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
    }

    def __init__(self, *, number_of_workers: int=None, default_documents=None, net_framework_version: str="v4.6", php_version: str=None, python_version: str=None, node_version: str=None, linux_fx_version: str=None, request_tracing_enabled: bool=None, request_tracing_expiration_time=None, remote_debugging_enabled: bool=None, remote_debugging_version: str=None, http_logging_enabled: bool=None, logs_directory_size_limit: int=None, detailed_error_logging_enabled: bool=None, publishing_username: str=None, app_settings=None, connection_strings=None, handler_mappings=None, document_root: str=None, scm_type=None, use32_bit_worker_process: bool=None, web_sockets_enabled: bool=None, always_on: bool=None, java_version: str=None, java_container: str=None, java_container_version: str=None, app_command_line: str=None, managed_pipeline_mode=None, virtual_applications=None, load_balancing=None, experiments=None, limits=None, auto_heal_enabled: bool=None, auto_heal_rules=None, tracing_options: str=None, vnet_name: str=None, cors=None, push=None, api_definition=None, auto_swap_slot_name: str=None, local_my_sql_enabled: bool=False, ip_security_restrictions=None, http20_enabled: bool=True, min_tls_version=None, **kwargs) -> None:
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.ip_security_restrictions = ip_security_restrictions
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version


class SiteLimits(Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(self, *, max_percentage_cpu: float=None, max_memory_in_mb: int=None, max_disk_size_in_mb: int=None, **kwargs) -> None:
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteMachineKey(Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(self, *, validation: str=None, validation_key: str=None, decryption: str=None, decryption_key: str=None, **kwargs) -> None:
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SiteSeal(Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :param html: Required. HTML snippet
    :type html: str
    """

    _validation = {
        'html': {'required': True},
    }

    _attribute_map = {
        'html': {'key': 'html', 'type': 'str'},
    }

    def __init__(self, *, html: str, **kwargs) -> None:
        super(SiteSeal, self).__init__(**kwargs)
        self.html = html


class SiteSealRequest(Model):
    """Site seal request.

    :param light_theme: If <code>true</code> use the light color theme for
     site seal; otherwise, use the default color theme.
    :type light_theme: bool
    :param locale: Locale of site seal.
    :type locale: str
    """

    _attribute_map = {
        'light_theme': {'key': 'lightTheme', 'type': 'bool'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(self, *, light_theme: bool=None, locale: str=None, **kwargs) -> None:
        super(SiteSealRequest, self).__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SkuCapacity(Model):
    """Description of the App Service plan scale options.

    :param minimum: Minimum number of workers for this App Service plan SKU.
    :type minimum: int
    :param maximum: Maximum number of workers for this App Service plan SKU.
    :type maximum: int
    :param default: Default number of workers for this App Service plan SKU.
    :type default: int
    :param scale_type: Available scale configurations for an App Service plan.
    :type scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(self, *, minimum: int=None, maximum: int=None, default: int=None, scale_type: str=None, **kwargs) -> None:
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(Model):
    """Description of a SKU for a scalable resource.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Current number of instances assigned to the resource.
    :type capacity: int
    :param sku_capacity: Min, max, and default scale values of the SKU.
    :type sku_capacity: ~azure.mgmt.web.v2015_08_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager
     enabled?
    :type capabilities: list[~azure.mgmt.web.v2015_08_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(self, *, name: str=None, tier: str=None, size: str=None, family: str=None, capacity: int=None, sku_capacity=None, locations=None, capabilities=None, **kwargs) -> None:
        super(SkuDescription, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SlotSwapStatus(Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap
     operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, *, time_taken: str=None, count: int=None, time_interval: str=None, **kwargs) -> None:
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param snapshot_time: Point in time in which the app recovery should be
     attempted, formatted as a DateTime string.
    :type snapshot_time: str
    :param recovery_target: Specifies the web app that snapshot contents will
     be written to.
    :type recovery_target:
     ~azure.mgmt.web.v2015_08_01.models.SnapshotRecoveryTarget
    :param overwrite: Required. If <code>true</code> the recovery operation
     can overwrite source app; otherwise, <code>false</code>.
    :type overwrite: bool
    :param recover_configuration: If true, site configuration, in addition to
     content, will be reverted.
    :type recover_configuration: bool
    :param ignore_conflicting_host_names: If true, custom hostname conflicts
     will be ignored when recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :type ignore_conflicting_host_names: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'overwrite': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_target': {'key': 'properties.recoveryTarget', 'type': 'SnapshotRecoveryTarget'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
    }

    def __init__(self, *, overwrite: bool, kind: str=None, snapshot_time: str=None, recovery_target=None, recover_configuration: bool=None, ignore_conflicting_host_names: bool=None, **kwargs) -> None:
        super(SnapshotRecoveryRequest, self).__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_target = recovery_target
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names


class SnapshotRecoveryTarget(Model):
    """Specifies the web app that snapshot contents will be written to.

    :param location: Geographical location of the target web app, e.g.
     SouthEastAsia, SouthCentralUS
    :type location: str
    :param id: ARM resource ID of the target app.
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, id: str=None, **kwargs) -> None:
        super(SnapshotRecoveryTarget, self).__init__(**kwargs)
        self.location = location
        self.id = id


class StatusCodesBasedTrigger(Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(self, *, status: int=None, sub_status: int=None, win32_status: int=None, count: int=None, time_interval: str=None, **kwargs) -> None:
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param user_name: Username
    :type user_name: str
    :param publishing_user_name: Required. Username used for publishing.
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing.
    :type publishing_password: str
    :param publishing_password_hash: Password hash used for publishing.
    :type publishing_password_hash: str
    :param publishing_password_hash_salt: Password hash salt used for
     publishing.
    :type publishing_password_hash_salt: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'publishing_user_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'properties.name', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
    }

    def __init__(self, *, publishing_user_name: str, kind: str=None, user_name: str=None, publishing_password: str=None, publishing_password_hash: str=None, publishing_password_hash_salt: str=None, **kwargs) -> None:
        super(User, self).__init__(kind=kind, **kwargs)
        self.user_name = user_name
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt


class VirtualApplication(Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: <code>true</code> if preloading is enabled;
     otherwise, <code>false</code>.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories:
     list[~azure.mgmt.web.v2015_08_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(self, *, virtual_path: str=None, physical_path: str=None, preload_enabled: bool=None, virtual_directories=None, **kwargs) -> None:
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(self, *, virtual_path: str=None, physical_path: str=None, **kwargs) -> None:
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual
    Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: Required. The URI where the VPN package can be
     downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'vpn_package_uri': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(self, *, vpn_package_uri: str, kind: str=None, vnet_name: str=None, **kwargs) -> None:
        super(VnetGateway, self).__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key
     of the private key used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: bytearray
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2015_08_01.models.VnetRoute]
    :ivar resync_required: <code>true</code> if a resync is required;
     otherwise, <code>false</code>.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This
     should be a comma-separated list of IP addresses.
    :type dns_servers: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'bytearray'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, vnet_resource_id: str=None, cert_blob: bytearray=None, dns_servers: str=None, **kwargs) -> None:
        super(VnetInfo, self).__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = None
        self.cert_blob = cert_blob
        self.routes = None
        self.resync_required = None
        self.dns_servers = dns_servers


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a
    Virtual Network.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_route_name: The name of this route. This is only returned by
     the server and does not need to be set by the client.
    :type vnet_route_name: str
    :param start_address: The starting address for this route. This may also
     include a CIDR notation, in which case the end address must not be
     specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start
     address is specified in CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges
     specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
     These values will be used for syncing an app's routes with those from a
     Virtual Network. Possible values include: 'DEFAULT', 'INHERITED', 'STATIC'
    :type route_type: str or ~azure.mgmt.web.v2015_08_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_route_name': {'key': 'properties.name', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, vnet_route_name: str=None, start_address: str=None, end_address: str=None, route_type=None, **kwargs) -> None:
        super(VnetRoute, self).__init__(kind=kind, **kwargs)
        self.vnet_route_name = vnet_route_name
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type
