/*
 *   Copyright © 2009 Rob Scheepmaker <r.scheepmaker@student.utwente.nl>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SERVICEJOB_P_H
#define SERVICEJOB_P_H

#include "../servicejob.h"

#include <QString>
#include <QVariant>
#include <QHash>

namespace Plasma
{

class ServiceJobPrivate
{
public:
    ServiceJobPrivate(ServiceJob *owner,
                      const QString &dest,
                      const QString &op,
                      const QVariantMap &params);

    void preventAutoStart();
    void autoStart();

    ServiceJob *q;
    QString destination;
    QString operation;
    QVariantMap parameters;
    QVariant result;
    bool m_allowAutoStart;
};

}
#endif // SERVICEJOB_P_H
