Minutes from 15th OpenVDB TSC meeting, May 2, 2019

Attendees: *Ken* M., *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel)

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) Status update (6.1)
4) Release schedule
5) SIGGRAPH (course and BOF)
6) Response to MRES
7) Other
8) Schedule next meeting

1) A quorum was confirmed

2) Secretary - Nick Avramoussis

3) Status update (6.1)

The CMake refactor (#382) and Circle CI frameworks (#409) have been
merged and a ticket has been created to track outstanding CMake and
CI work (https://jira.aswf.io/browse/OVDB-89). There were a few minor
updates to the CMake implementation after merge, notably adding missing
unit tests to the source file list. #378 (warnings as errors) has also
been merged. A few outstanding PRs exist for 6.1; CMake syntax
improvements and Houdini deprecations.

The deprecations of some Houdini utility functions initiated discussion
on the Houdini utilities deployed with OpenVDB. Some are not actively
being used in the OpenVDB codebase. The original source of these methods
stems from a separate standalone library being used at Dreamworks. They
are a useful place for generalized Houdini development tools. It would
be worth considering a separate module for the Houdini utilities which
doesn't depend on OpenVDB (but could still be deployed with it). There
is interest outside of OpenVDB for users wishing to use some of these
methods, but who don't want to rely on or pull in an unnecessary OpenVDB
dependency.

Some methods in particular worth discussing. duplicateSourceStealable()
could be removed though it would force any users inheriting from
SOP_OpenVDBNode to verbify their SOPs to gain similar performance
benefits. Note that as long as a sop is marked as INPLACE, mainline
Houdini will perform a "duplicateSourceStealable" in the same
circumstances. Consensus to mark as deprecated for now. It would be worth
taking another look at the DS Houdini workflow for parameters to
better resolve parameter dependencies for verbified SOPs
(https://jira.aswf.io/browse/OVDB-22). Currently VDB doesn't know how
to handle 'disable whens' when resolving these. ScopedInputLock to
remain in place. OP_NodeChain was being used in the OpenVDB Filter
nodes but has been removed as part of removing the pre 16.5 logic (for
non verbified nodes). The Houdini mindset on these types of methods is
that nodes should not be analyzing the surrounding graph network for
optimizations. OP_NodeChain is theoretically slightly more efficient
than the verbification implementation as it doesn't need to construct
duplicates of the same filter classes, but the performance differences
should be minimal.

4) Release schedule

Consensus to release 6.1.0 early next week (beginning 6th May). The CI
has been completely transitioned to circle and travis implementation
has been removed. The Makefile is no longer being tested. AppVeyor is
running. We're still missing a Mac and Maya CI build. The TAC is
moving towards Azure pipelines over circle.

5) SIGGRAPH

The SIGGRAPH course has been accepted and there will also be an OpenVDB
Birds of a Feather with a block of time just for the OpenVDB TSC
(allocated by the ASWF). We should continue to collect course material
for submission and clarify the submission requirements and deadlines.

6) Response to MRES

Ken to put together an initial document with some feedback from the TSC
which other can extend. Primary question is that we're still unclear
why a stack of OpenVDB grids is not necessary better or as valid an
approach to the currently proposed MRES structure. We would ultimately
like to see a solution to one of the proposed problems outlined in the
response.

Discussion lead to OpenVDBs Tree resolution flexibility at compile
time. It was proposed to consider locking down the available Tree
templates instantiations to improve portability and compile times
whilst decreasing code bloat. It's still not clear if this is a
realistic goal due as we're unsure how users (if at all) are
utilizing the available flexibility of the Tree node structures and
how exactly we would introduce these limitations.

Additional discussion on the idea of a read only Tree (static or const)
following on from last weeks metadata conversation. It's not clear
what a static Tree configuration (specialized with potentially a
different ABI) would give over a const Tree, but it would be worth
exploring this idea.

7) Other

Briefly discussed the idea of blog posts and other more "user friendly"
ways of relaying documentation as alternatives to doxygen.

8) Next Meeting

May 9th 2019.  3pm-4pm EDT (GMT-4).
