\name{computeTruncatedNormalPdf}
\alias{computeTruncatedNormalPdf}
\title{Compute the Pdf of a TruncatedNormal Distribution}
\description{
This ROT function, called from a Distribution C++ object,
is given a point and the necessary distribution parameters.
It then computes the Pdf at the point.
}
\usage{
computeTruncatedNormalPdf(point, mu, sigma, a, b)
}
\arguments{
\item{point}{Point(s) where the Pdf is computed. (vector)}
  \item{mu}{The TruncatedNormal distribution mu.}
  \item{sigma}{The TruncatedNormal distribution sigma.}
  \item{a}{The TruncatedNormal distribution aParameter.}
  \item{b}{The TruncatedNormal distribution bParameter.}
}
\details{
The truncated normal distribution has the following density function:
$$f(x, mu, sigma, a, b) = 1[a, b](x) * (1 / sigma) * phi((x - mu) / sigma) / (phi((b - mu) / sigma) - phi((a - mu) / sigma))$$
}
\value{
  The TruncatedNormal Pdf value (vector)}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{# Standard TruncatedNormal distribution example. 

point <- runif(1000) * 14 - 6
plot(point, computeTruncatedNormalPdf(point, 1, 2, - 2, 6))}
\keyword{distribution}
