//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/type-conversion.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, imports, buffer) {
    "use asm";

    var fround = global.Math.fround;
    var getInt32 = imports.getInt32;
    var getDouble = imports.getDouble;
    var getString = imports.getString;
    var getBoolean = imports.getBoolean;

    function convertIntToFloat(x) {
        x = x | 0;
        return fround(x | 0);
    }

    function convertUnsignedIntToFloat(x) {
        x = x | 0;
        return fround(x >>> 0);
    }

    function convertIntToDouble(x) {
        x = x | 0;
        return +(x | 0);
    }

    function convertUnsignedIntToDouble(x) {
        x = x | 0;
        return +(x >>> 0);
    }

    function convertFloatToInt(x) {
        x = fround(x);
        return ~~x;
    }

    function convertFloatToDouble(x) {
        x = fround(x);
        return +x;
    }

    function convertDoubleToInt(x) {
        x = +x;
        return ~~x;
    }

    function convertDoubleToFloat(x) {
        x = +x;
        return fround(x);
    }

    function takeAndReturnInt32(x) {
        x = x | 0;
        return x | 0;
    }

    function takeAndReturnFloat(x) {
        x = fround(x);
        return x;
    }

    function takeAndReturnDouble(x) {
        x = +x;
        return x;
    }

    function returnInt32FromInt32() {
        return getInt32() | 0;
    }

    function returnInt32FromDouble() {
        return getDouble() | 0;
    }

    function returnInt32FromString() {
        return getString() | 0;
    }

    function returnInt32FromBoolean() {
        return getBoolean() | 0;
    }

    function returnDoubleFromInt32() {
        return +getInt32();
    }

    function returnDoubleFromDouble() {
        return +getDouble();
    }

    function returnDoubleFromString() {
        return +getString();
    }

    function returnDoubleFromBoolean() {
        return +getBoolean();
    }

    return {
        convertIntToFloat: convertIntToFloat,
        convertUnsignedIntToFloat: convertUnsignedIntToFloat,
        convertIntToDouble: convertIntToDouble,
        convertUnsignedIntToDouble: convertUnsignedIntToDouble,
        convertFloatToInt: convertFloatToInt,
        convertFloatToDouble: convertFloatToDouble,
        convertDoubleToInt: convertDoubleToInt,
        convertDoubleToFloat: convertDoubleToFloat,

        takeAndReturnInt32: takeAndReturnInt32,
        takeAndReturnFloat: takeAndReturnFloat,
        takeAndReturnDouble: takeAndReturnDouble,

        returnInt32FromInt32: returnInt32FromInt32,
        returnInt32FromDouble: returnInt32FromDouble,
        returnInt32FromString: returnInt32FromString,
        returnInt32FromBoolean: returnInt32FromBoolean,
        returnDoubleFromInt32: returnDoubleFromInt32,
        returnDoubleFromDouble: returnDoubleFromDouble,
        returnDoubleFromString: returnDoubleFromString,
        returnDoubleFromBoolean: returnDoubleFromBoolean,
    };
}
*/

var imports = {
    getInt32: () => 42,
    getDouble: () => 4.2,
    getString: () => "4.2",
    getBoolean: () => true,
};
var module = loadWebAssembly("wasm/type-conversion.wasm", imports);

shouldBe(module.convertIntToFloat(-1), -1);
shouldBe(module.convertUnsignedIntToFloat(-1), 4294967296);
shouldBe(module.convertIntToDouble(-1), -1);
shouldBe(module.convertUnsignedIntToDouble(-1), 4294967295);
shouldBe(module.convertFloatToInt(4.2), 4);
shouldBe(module.convertFloatToDouble(4.2), 4.199999809265137);
shouldBe(module.convertDoubleToInt(4.2), 4);
shouldBe(module.convertDoubleToFloat(4.2), 4.199999809265137);

var two = {
    valueOf() { return 2; }
};

shouldBe(module.takeAndReturnInt32(1), 1);
shouldBe(module.takeAndReturnInt32("1"), 1);
shouldBe(module.takeAndReturnInt32(1.9), 1);
shouldBe(module.takeAndReturnInt32(true), 1);
shouldBe(module.takeAndReturnInt32(false), 0);
shouldBe(module.takeAndReturnInt32("one"), 0);
shouldBe(module.takeAndReturnInt32({ }), 0);
shouldBe(module.takeAndReturnInt32([2.5]), 2);
shouldBe(module.takeAndReturnInt32(two), 2);

shouldBe(module.takeAndReturnFloat(0.1), 0.10000000149011612);
shouldBe(module.takeAndReturnFloat("0.1"), 0.10000000149011612);
shouldBe(module.takeAndReturnFloat(1), 1);
shouldBe(module.takeAndReturnFloat(true), 1);
shouldBe(module.takeAndReturnFloat(false), 0);
shouldBe(isNaN(module.takeAndReturnFloat("one")), true);
shouldBe(isNaN(module.takeAndReturnFloat({ })), true);
shouldBe(module.takeAndReturnFloat([2.5]), 2.5);
shouldBe(module.takeAndReturnFloat(two), 2);

shouldBe(module.takeAndReturnDouble(1.5), 1.5);
shouldBe(module.takeAndReturnDouble("1.5"), 1.5);
shouldBe(module.takeAndReturnDouble(1), 1);
shouldBe(module.takeAndReturnDouble(true), 1);
shouldBe(module.takeAndReturnDouble(false), 0);
shouldBe(isNaN(module.takeAndReturnDouble("one")), true);
shouldBe(isNaN(module.takeAndReturnDouble({ })), true);
shouldBe(module.takeAndReturnDouble([2.5]), 2.5);
shouldBe(module.takeAndReturnDouble(two), 2);

shouldBe(module.returnInt32FromInt32(), 42);
shouldBe(module.returnInt32FromDouble(), 4);
shouldBe(module.returnInt32FromString(), 4);
shouldBe(module.returnInt32FromBoolean(), 1);
shouldBe(module.returnDoubleFromInt32(), 42);
shouldBe(module.returnDoubleFromDouble(), 4.2);
shouldBe(module.returnDoubleFromString(), 4.2);
shouldBe(module.returnDoubleFromBoolean(), 1);
