/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Factory_p.h"

#include "Entry.h"
#include "Group.h"
#include "ParameterEntry.h"
#include "TextEntry.h"
#include "ValueEntry.h"

using namespace GTLCore::Metadata;

const Entry* Factory::createEntry( const GTLCore::String& _name)
{
  return new Entry( _name );
}

const TextEntry* Factory::createTextEntry( const GTLCore::String& _name, const GTLCore::String& _text)
{
  return new TextEntry( _name, _text );
}

const Group* Factory::createGroup( const GTLCore::String& _name, const std::list< const Entry* >& _entries)
{
  return new Group( _name, _entries );
}

void Factory::deleteEntry( const Entry* _entry )
{
  delete _entry;
}

const ParameterEntry* Factory::createParameterEntry( const GTLCore::String& _name, const std::list< const Entry* >& _entries )
{
  return new ParameterEntry( _name, _entries );
}

const ValueEntry* Factory::createValueEntry( const GTLCore::String& _name, const GTLCore::Value& _value  )
{
  return new ValueEntry( _name, _value );
}
