#!/usr/bin/env python3
# package-tracker - Compare and track package versions in debian repositories
# Copyright (C) 2017 Andreas Kreuzer <andreas.kreuzer@open-infrastructure.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import os
import os.path
import argparse
import apt
import apt_pkg
import re
import logging

software = u"package-tracker"
program = sys.argv[0]
install_path = "/"
apt_root_path = "var/" + software
config_path = "etc/" + software
log_file = "var/log/" + software + "/" + software + ".log"
template_path = "usr/share/" + software + "/templates"

file_path = os.path.join(install_path, template_path)
f = open(file_path + '/report.html', 'r')
if (not f):
    print('ERROR')
    sys.exit(1)

content = f.read()
f.close()

template_element = ''
m = re.search(r'{%PT_CONTENT_ELEMENT%}(.+?){%/PT_CONTENT_ELEMENT%}', content, re.DOTALL)
if (m):
    template_element = m.group(1)

else:
    print('no match')

template_element = template_element.replace('{%PT_ELEMENT/%}', 'foobar')

content = re.sub(r'{%PT_CONTENT_ELEMENT%}(.+?){%/PT_CONTENT_ELEMENT%}',
            template_element, content, flags=re.DOTALL)

print(content)
