      SUBROUTINE ccsd_t_doubles_l(a_i0,
     &d_t2,d_v2,k_t2_offset,k_v2_offset,t
     &_h1b,t_h2b,t_h3b,t_p4b,t_p5b,t_p6b,toggle)
C     $Id$
C     This is a Fortran77 program generated by Tensor Contraction Engine v.1.0
C     Copyright (c) Battelle & Pacific Northwest National Laboratory (2002)
C     i0 ( p4 p5 p6 h1 h2 h3 )_vt + = -1 * P( 9 ) * Sum ( h7 ) * t ( p4 p5 h1 h7 )_t * v ( h7 p6 h2 h3 )_v
C     i0 ( p4 p5 p6 h1 h2 h3 )_vt + = -1 * P( 9 ) * Sum ( p7 ) * t ( p4 p7 h1 h2 )_t * v ( p5 p6 h3 p7 )_v
      IMPLICIT NONE
#include "global.fh"
#include "mafdecls.fh"
#include "util.fh"
#include "errquit.fh"
#include "tce.fh"
#include "offl.fh"
      INTEGER t_p4b
      INTEGER t_p5b
      INTEGER t_p6b
      INTEGER t_h1b
      INTEGER t_h2b
      INTEGER t_h3b
      INTEGER toggle
      INTEGER d_t2
      INTEGER k_t2_offset
      INTEGER d_v2
      INTEGER k_v2_offset
      integer l_v2sub
      integer l_t2sub
      integer l_scratch
      DOUBLE PRECISION a_i0(*)
#ifdef USE_F90_ALLOCATABLE
      double precision, allocatable :: d_t2sub(:)
      double precision, allocatable :: d_v2sub(:)
      double precision, allocatable :: d_scratch(:)
      integer alloc_error
#else
      integer k_t2sub
      integer k_scratch
      integer k_v2sub
#endif
      logical offload_enabled
      external offload_enabled
      integer range_p4,range_h1,ii
      integer t2size,v2size
      
      
c *** debug ***
c      write(6,*)'I am in ccsd_t_doubles',ga_nodeid()
c      call util_flush(6)
c *************
      call ccsd_t_v2t2lgth(t2size,v2size)
#if USE_F90_ALLOCATABLE
      allocate(d_t2sub(1:t2size), stat=alloc_error)
      if (alloc_error.ne.0) then
        call errquit('ccsd_t_doubles_t: MA error d_t2sub',0,MA_ERR)
      endif
      allocate(d_scratch(1:max(t2size,v2size)), stat=alloc_error)
      if (alloc_error.ne.0) then
        call errquit('ccsd_t_doubles_t: MA error d_scratch',0,MA_ERR)
      endif
      allocate(d_v2sub(1:v2size), stat=alloc_error)
      if (alloc_error.ne.0) then
        call errquit('ccsd_t_doubles_t: MA error d_v2sub',0,MA_ERR)
      endif
#else
      IF (.not.MA_PUSH_GET(mt_dbl,t2size,'t2sub',
     L     l_t2sub,k_t2sub)) CALL
     & ERRQUIT('ccsd_t_doubles t2sub',101,MA_ERR)
      IF (.not.MA_PUSH_GET(mt_dbl,max(t2size,v2size),'scratch',
     L     l_scratch,k_scratch)) CALL
     & ERRQUIT('ccsd_t_doubles scratch',102,MA_ERR)
      IF (.not.MA_PUSH_GET(mt_dbl,v2size,'v2sub',
     L     l_v2sub,k_v2sub)) CALL
     & ERRQUIT('ccsd_t_doubles v2sub',103,MA_ERR)
#endif

      IF (toggle .eq. 2) then
#if USE_OFFLOAD
#if USE_OPENMP
      if(offload_enabled()) then
         CALL offl0_ccsd_t_doubles_l_12(d_t2,
     &        k_t2_offset,d_v2,k_v2_offset,
     A        a_i0,t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b,
#if USE_F90_ALLOCATABLE
     T        d_v2sub,d_t2sub,d_scratch)
#else
     T        dbl_mb(k_v2sub),dbl_mb(k_t2sub),
     S        dbl_mb(k_scratch))
#endif
      else
#endif
#endif
         CALL ccsd_t_doubles_l_12(d_t2,
     &        k_t2_offset,d_v2,k_v2_offset,
     A        a_i0,t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b,
#if USE_F90_ALLOCATABLE
     T        d_v2sub,d_t2sub,d_scratch)
#else
     T        dbl_mb(k_v2sub),dbl_mb(k_t2sub),
     S        dbl_mb(k_scratch))
#endif
#if USE_OPENMP
#if USE_OFFLOAD
         endif
#endif
#endif
      endif
#if USE_F90_ALLOCATABLE
      deallocate(d_v2sub)
      deallocate(d_scratch)
      deallocate(d_t2sub)
#else
      IF (.not.MA_chop_stack(l_t2sub)) CALL
     & ERRQUIT('ccsd_t_doubles_1',103,MA_ERR)
#endif
      RETURN
      END
      subroutine ccsd_t_v2t2lgth(t2size,v2size)
      implicit none
#include "mafdecls.fh"
#include "tce.fh"
c     compute v2sub and t2sub max length
      integer t2size,v2size ! [out]
c
      integer range_p4,range_h1,ii
c
      range_p4=0
      do ii = noab+1,noab+nvab
         range_p4 = max(range_p4,int_mb(k_range+ii-1))
      enddo
      range_h1=0
      do ii = 1,noab
         range_h1 = max(range_h1,int_mb(k_range+ii-1))
      enddo
      t2size=(range_p4**2)*(range_h1**2)
      v2size=max((range_p4)*(range_h1**3),
     M     (range_p4**3)*(range_h1))
      call util_align64(t2size)
      call util_align64(v2size)
      return
      end
      subroutine util_align64(in)
      implicit none
#include "mafdecls.fh"
      integer in,alignval
      alignval=64/MA_sizeof(MT_DBL,1,MT_BYTE)
      if(mod(in,alignval).ne.0) in=(1+in/alignval)*alignval
      in=in+alignval
      return
      end
