/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.migrator;

import java.io.File;
import java.io.FileWriter;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.velocity.util.StringUtils;

public class Migrator {
    protected String originalSourceFile;
    protected Perl5Util perl;
    protected String pathSeparator = File.separator;
    protected String[] res = new String[]{"#if\\s*[(]\\s*(.*\\S)\\s*[)]\\s*(#begin|{)[ \\t]?", "#if( $1 )", "[ \\t]?(#end|})\\s*#else\\s*(#begin|{)[ \\t]?(\\w)", "#else#**#$3", "[ \\t]?(#end|})\\s*#else\\s*(#begin|{)[ \\t]?", "#else", "#foreach\\s+(\\$\\w+)\\s+in\\s+(\\$[^\\s#]+)\\s*(#begin|{)[ \\t]?", "#foreach( $1 in $2 )", "\n}", "\n#end", "#set\\s+(\\$[^\\s=]+)\\s*=\\s*(.*\\S)[ \\t]*", "#set( $1 = $2 )", "(##[# \\t\\w]*)\\)", ")$1", "#parse\\s+([^\\s#]+)[ \\t]?", "#parse( $1 )", "#include\\s+([^\\s#]+)[ \\t]?", "#include( $1 )", "\\$\\(([^\\)]+)\\)", "${$1}", "\\${([^}\\(]+)\\(([^}]+)}\\)", "${$1($2)}", "\\$_", "$l_", "\\${(_[^}]+)}", "${l$1}", "\\.wm", ".vm"};

    public void migrate(String[] args) {
        File file;
        if (args.length < 1) {
            this.usage();
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println("The specified template or directory does not exist");
            System.exit(1);
        }
        if (file.isDirectory()) {
            String basedir = args[0];
            String newBasedir = basedir + ".new";
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                this.writeSource(files[i], basedir, newBasedir);
                ++i;
            }
        } else {
            this.writeSource(args[0], "", "");
        }
    }

    private boolean writeSource(String file, String basedir, String newBasedir) {
        String newSourceFile;
        String sourceFile;
        System.out.println("Converting " + file + "...");
        if (basedir.length() == 0) {
            sourceFile = file;
            String sourceDir = "";
            String string = file;
        } else {
            sourceFile = basedir + this.pathSeparator + file;
            String sourceDir = newBasedir + this.pathSeparator + file.substring(0, file.lastIndexOf(this.pathSeparator));
            File outputDirectory = new File(sourceDir);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            newSourceFile = newBasedir + this.pathSeparator + file;
        }
        String convertedSourceFile = this.convertSourceFile(sourceFile);
        try {
            FileWriter fw = new FileWriter(newSourceFile);
            fw.write(convertedSourceFile);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void usage() {
        System.err.println("Usage: directory");
        System.exit(1);
    }

    /*
     * Unable to fully structure code
     */
    public String convertSourceFile(String sourceFile) {
        this.originalSourceFile = StringUtils.fileContentsToString(sourceFile);
        if (!this.originalSourceFile.endsWith("\n")) {
            this.originalSourceFile = this.originalSourceFile + "\n";
        }
        this.perl = new Perl5Util();
        i = 0;
        ** GOTO lbl11
        {
            this.originalSourceFile = this.perl.substitute("s/" + this.res[i] + "/" + this.res[i + 1] + "/", this.originalSourceFile);
            do {
                if (this.perl.match("/" + this.res[i] + "/", this.originalSourceFile)) continue block0;
                i += 2;
lbl11:
                // 2 sources

            } while (i < this.res.length);
        }
        return this.originalSourceFile;
    }

    public static void main(String[] args) {
        Migrator migrator = new Migrator();
        migrator.migrate(args);
    }
}

