<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [emulateVisionDeficiency](./puppeteer.page.emulatevisiondeficiency.md)

## Page.emulateVisionDeficiency() method

Simulates the given vision deficiency on the page.

<b>Signature:</b>

```typescript
emulateVisionDeficiency(type?: Protocol.Emulation.SetEmulatedVisionDeficiencyRequest['type']): Promise<void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  type | Protocol.Emulation.SetEmulatedVisionDeficiencyRequest\['type'\] | the type of deficiency to simulate, or <code>'none'</code> to reset. |

<b>Returns:</b>

Promise&lt;void&gt;

## Example


```js
const puppeteer = require('puppeteer');

(async () => {
  const browser = await puppeteer.launch();
  const page = await browser.newPage();
  await page.goto('https://v8.dev/blog/10-years');

  await page.emulateVisionDeficiency('achromatopsia');
  await page.screenshot({ path: 'achromatopsia.png' });

  await page.emulateVisionDeficiency('deuteranopia');
  await page.screenshot({ path: 'deuteranopia.png' });

  await page.emulateVisionDeficiency('blurredVision');
  await page.screenshot({ path: 'blurred-vision.png' });

  await browser.close();
})();

```

