<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [HTTPRequest](./puppeteer.httprequest.md) &gt; [redirectChain](./puppeteer.httprequest.redirectchain.md)

## HTTPRequest.redirectChain() method

A `redirectChain` is a chain of requests initiated to fetch a resource.

<b>Signature:</b>

```typescript
redirectChain(): HTTPRequest[];
```
<b>Returns:</b>

[HTTPRequest](./puppeteer.httprequest.md)\[\]

the chain of requests - if a server responds with at least a single redirect, this chain will contain all requests that were redirected.

## Remarks

`redirectChain` is shared between all the requests of the same chain.

For example, if the website `http://example.com` has a single redirect to `https://example.com`, then the chain will contain one request:

```js
const response = await page.goto('http://example.com');
const chain = response.request().redirectChain();
console.log(chain.length); // 1
console.log(chain[0].url()); // 'http://example.com'

```
If the website `https://google.com` has no redirects, then the chain will be empty:

```js
const response = await page.goto('https://google.com');
const chain = response.request().redirectChain();
console.log(chain.length); // 0

```

