/*
 * This file is part of Flowplayer, http://flowplayer.org
 *
 * By: Daniel Rossi, <electroteque@gmail.com>, Anssi Piirainen Flowplayer Oy
 * Copyright (c) 2008-2011 Flowplayer Oy *
 * Released under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 */

package org.flowplayer.cluster {
	
	
	public class ClusterConfig {
		
		/**
		 * Hosts IP Array List For Fallback and Round Robin Systems
		 * 
		 * @private
		 * @default	null
		 */
		private var _hosts:Array = new Array();
		
		private var _netConnectionUrl:String;
		
		/** 
		 * Connect Attempt Retry Timer Timeout in milliseconds
		 * 
		 * @private
		 * @default	5000
		 */
			 
		private var _connectTimeout:Number = 2000;
		
		private var _connectCount:Number = 3;
		
		private var _loadBalance:Boolean = false;
		
		private var _failureExpiry:int = -1;
		
		private var _connectionArgs:* = null;
		
		private var _serverType:String = "http";
		
		public function get netConnectionUrl():String {
			return _netConnectionUrl;
		}
		
		public function set netConnectionUrl(netConnectionUrl:String):void {
			_netConnectionUrl = netConnectionUrl;
		}
		
		public function set connectionArgs(args:*):void
		{
			_connectionArgs = args;
		}
		
		public function get connectionArgs():*
		{
			return _connectionArgs;
		}
		
		public function set hosts(hosts:Array):void
		{
			_hosts = hosts;
		}
		
		public function get hosts():Array
		{
			return _hosts;
		}
		
		public function set connectTimeout(timeout:Number):void
		{
			_connectTimeout = timeout;
		}
		
		public function get connectTimeout():Number
		{
			return _connectTimeout;
		}
		
		public function set connectCount(count:Number):void
		{
			_connectCount = count;
		}
		
		public function get connectCount():Number
		{
			return _connectCount;
		}
		
		public function set loadBalance(value:Boolean):void
		{
			_loadBalance = value;
		}
		
		public function get loadBalance():Boolean
		{
			return _loadBalance;
		}
		
		public function set failureExpiry(expiry:Number):void
		{
			_failureExpiry = expiry;
		}
		
		public function get failureExpiry():Number
		{
			if (_failureExpiry >= 0) return _failureExpiry;
            if (! hosts || hosts.length == 0) return _connectTimeout + 1000;
            return hosts.length * _connectTimeout + 1000;
		}
		
		public function set serverType(value:String):void
		{
			_serverType = value;
		}
		
		public function get serverType():String
		{
			return _serverType;
		}
	}
}
