﻿/*
 * This file is part of Flowplayer, http://flowplayer.org
 *
 * Copyright (c) 2008-2011 Flowplayer Oy *
 * Released under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 */
 
package org.flowplayer {
	import flash.display.Sprite;
	import flash.text.TextField;
	
	import org.flowplayer.model.Plugin;
	import org.flowplayer.util.Arrange;
	import org.flowplayer.model.PluginModel;
	import org.flowplayer.view.Flowplayer;	

	public class SimpleHelloWorld extends Sprite implements Plugin {

		private var _text:TextField;
		
		public function SimpleHelloWorld() {
			_text = new TextField();
			_text.text = "Hello World!";
			_text.height = 20;
			addChild(_text);
		}

		public override function set width(newWidth:Number):void {
			super.width = newWidth;
			arrangeChildren();
		}

		public override function set height(newHeight:Number):void {
			super.width = newHeight;
			arrangeChildren();
		}

		private function arrangeChildren():void {
			Arrange.center(_text, width, height);			
		}
		
		/**
		 * Gets the default configuration for this plugin.
		 */
		public function getDefaultConfig():Object {
			return { top: "70%", left: '50%', width: '40%', height: 50, opacity: 0.9 };
		}
		
		public function onConfig(configProps:PluginModel):void {
		}
		
		public function onLoad(player:Flowplayer):void {
		}
	}
}
