// Copyright (c) Microsoft Corp., 2004. All rights reserved.
#region Using directives

using System;
using System.Workflow.Runtime;
using System.Collections.Generic;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;

#endregion

namespace System.Workflow.Runtime.DebugEngine
{
    //
    // IMPORTANT: Do not edit this file without consulting Break Safe Synchronization.doc!
    //

    #region interface IInstanceTable

    [Obsolete("The System.Workflow.* types are deprecated.  Instead, please use the new types from System.Activities.*")]
    public interface IInstanceTable
    {
        Activity GetActivity(string instanceId, string activityName);
    }

    #endregion

    #region Class InstanceData

    internal sealed class InstanceData : ICloneable
    {
        Activity rootActivity;

        public Activity RootActivity
        {
            get
            {
                return this.rootActivity;
            }
            set
            {
                this.rootActivity = value;
            }
        }

        public InstanceData(Activity rootActivity)
        {
            this.rootActivity = rootActivity;
        }

        object ICloneable.Clone()
        {
            InstanceData instanceData = new InstanceData(this.rootActivity);
            return instanceData;
        }
    }

    internal sealed class InstanceMap : Dictionary<Guid, InstanceData>, ICloneable
    {
        object ICloneable.Clone()
        {
            InstanceMap data = new InstanceMap();
            foreach (Guid instsanceId in Keys)
                data.Add(instsanceId, (InstanceData)(((ICloneable)(this[instsanceId])).Clone()));

            return data;
        }
    }

    #endregion

    #region Class InstanceTable

    internal sealed class InstanceTable : BreakSafeBase<InstanceMap>, IInstanceTable
    {
        public InstanceTable(int controllerManagedThreadId)
            : base(controllerManagedThreadId)
        { }

        // Controller invoked.
        public void AddInstance(Guid instanceId, Activity rootActivity)
        {
            try
            {
                Lock();

                InstanceMap instanceMap = GetWriterData();
                instanceMap[instanceId] = new InstanceData(rootActivity);
                SaveData(instanceMap);
            }
            finally
            {
                Unlock();
            }
        }

        // Controller invoked.
        public void RemoveInstance(Guid instanceId)
        {
            try
            {
                Lock();

                InstanceMap instanceMap = GetWriterData();
                instanceMap.Remove(instanceId);
                SaveData(instanceMap);
            }
            finally
            {
                Unlock();
            }
        }

        // Controller invoked during Dynamic Update notification subscription changes.
        public Activity GetRootActivity(Guid instanceId)
        {
            try
            {
                Lock();

                return GetReaderData()[instanceId].RootActivity;
            }
            finally
            {
                Unlock();
            }
        }

        // Controller invoked during Dynamic Update notification subscription changes.
        public void UpdateRootActivity(Guid instanceId, Activity rootActivity)
        {
            try
            {
                Lock();

                InstanceMap instanceMap = GetWriterData();
                instanceMap[instanceId].RootActivity = rootActivity;
                SaveData(instanceMap);
            }
            finally
            {
                Unlock();
            }
        }

        // DE invoked for watches through expression evaluation.
        Activity IInstanceTable.GetActivity(string instanceId, string activityQualifiedName)
        {
            try
            {
                Lock();


                Activity rootActivity = GetReaderData()[new Guid(instanceId)].RootActivity;
                return DebuggerHelpers.ParseActivity(rootActivity, activityQualifiedName);
            }
            finally
            {
                Unlock();
            }
        }
    }

    #endregion
}
