i-PI path integral interface examples
=====================================

This folder contains an example to run LAMMPS as a client,
exchanging information on the atomic configurations, energy and forces
with the [http://ipi-code.org](i-PI Python interface).  These
examples require a working copy of i-PI and compiling LAMMPS in a UNIX
environment. 
i-PI can be installed from source or from `pip`. Please refer to the
documentation for up-to-date installation instruction.

Note that the i-PI examples listed here have been tested to work with the
3.0 version of i-PI. Refer to the LAMMPS examples distributed with i-PI if you
are using a different version.

Path integral simulation of graphene
------------------------------------

The example in this folder uses the external wrapper i-PI to perform 
path integral molecular dynamics simulation of a graphene sheet, using 
LAMMPS as the force back-end. The output is generated by i-PI. Please
refer to its documentation for an explanation of the input parameters
and the format of the output.

How to run i-PI
---------------

You should have a relatively recent (>=3.5) version of Python and Numpy,
and the public version of i-PI. You can then run i-PI by executing

```bash
   $PATHTOIPI/i-pi i-pi_input.xml
```

In a separate terminal, then, you should run LAMMPS compiled to provide 
`fix_ipi` functionalities.

```bash
   $LAMMPS -in in.graphene
```

You can run multiple instances of LAMMPS if you want to exploit the 
parallelism over the path integral beads.
