/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef IMPORTCERTIFICATEDIALOG_H
#define IMPORTCERTIFICATEDIALOG_H

#include <QProcess>
#include <QtCore/QString>
#include <QtCore/QStringList>

#include <kdialog.h>

#include "ui_importcertificatedialogbase4.h"
#include "kvpncconfig.h"

class ImportCertificateDialog : public KDialog
{
    Q_OBJECT

public:
    enum ImportType {
        pkcs12_freeswan = 0,
        pkcs12_racoon = 1,
        ca_der = 2,
        pkcs12_openvpn = 3,
        cisco = 4,
        ciscoca = 5,
        ciscouserca = 6
    };

    ImportCertificateDialog(QWidget *parent, const char* caption, KVpncConfig *GlobalConfig);
    ~ImportCertificateDialog();

    void canAccept();
    Ui_ImportCertificateDialogBase *main;

protected:
    QProcess *ImportProcess;
    KVpncConfig *GlobalConfig;
    bool done;
    int askpasscount;
    QStringList *env;

public slots:
    void accept();
    void reject();
    void exit(int, QProcess::ExitStatus);
    void typeToggeled(int type);
    void usePrivateKeyPassToggled(bool);
    void removePrivateKey(int, QProcess::ExitStatus);
    void readFromStdout_import();
    void readFromStderr_import();
    void doLink(int, QProcess::ExitStatus);
    void doCacert(int, QProcess::ExitStatus);
    void doPrivateKey(int, QProcess::ExitStatus);
    void doCreateHash(int, QProcess::ExitStatus);
    void ciscoCertMgrExited(int, QProcess::ExitStatus);

public:
    QString filename;
    QString certpath;
    QString importpassword;
    QString privatekeypassword;
    QString privatekeyagainpassword;
    QString pathToOpenSSL;
    QString certHash;
    QString certName;
    QString CertFullPath;
    QString CaCertFullPath;
    bool importOk;
    bool doHash;
    bool importSuccess;
    bool doExit;
    bool error_found;
};

#endif
