/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/refactoring/safeDeleteMultiModule")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiModuleSafeDeleteTestGenerated extends AbstractMultiModuleSafeDeleteTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInSafeDeleteMultiModule() throws Exception {
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(this.getClass(), new File("idea/testData/refactoring/safeDeleteMultiModule"), Pattern.compile("^(.+)\\.test$"), TargetBackend.ANY);
    }

    @TestMetadata("byActualClass/byActualClass.test")
    public void testByActualClass_ByActualClass() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClass/byActualClass.test");
    }

    @TestMetadata("byActualClassMemberFun/byActualClassMemberFun.test")
    public void testByActualClassMemberFun_ByActualClassMemberFun() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassMemberFun/byActualClassMemberFun.test");
    }

    @TestMetadata("byActualClassMemberFunParameterLiftingToExpect/byActualClassMemberFunParameterLiftingToExpect.test")
    public void testByActualClassMemberFunParameterLiftingToExpect_ByActualClassMemberFunParameterLiftingToExpect() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassMemberFunParameterLiftingToExpect/byActualClassMemberFunParameterLiftingToExpect.test");
    }

    @TestMetadata("byActualClassMemberVal/byActualClassMemberVal.test")
    public void testByActualClassMemberVal_ByActualClassMemberVal() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassMemberVal/byActualClassMemberVal.test");
    }

    @TestMetadata("byActualClassPrimaryConstructorParameterLiftingToExpect/expectsAndActualsByActualClassPrimaryConstructorParameter.test")
    public void testByActualClassPrimaryConstructorParameterLiftingToExpect_ExpectsAndActualsByActualClassPrimaryConstructorParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassPrimaryConstructorParameterLiftingToExpect/expectsAndActualsByActualClassPrimaryConstructorParameter.test");
    }

    @TestMetadata("byActualClassPrimaryConstructorPropertyLiftingToExpect/expectsAndActualsByActualClassPrimaryConstructorProperty.test")
    public void testByActualClassPrimaryConstructorPropertyLiftingToExpect_ExpectsAndActualsByActualClassPrimaryConstructorProperty() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassPrimaryConstructorPropertyLiftingToExpect/expectsAndActualsByActualClassPrimaryConstructorProperty.test");
    }

    @TestMetadata("byActualClassSecondaryConstructor/byActualClassSecondaryConstructor.test")
    public void testByActualClassSecondaryConstructor_ByActualClassSecondaryConstructor() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassSecondaryConstructor/byActualClassSecondaryConstructor.test");
    }

    @TestMetadata("byActualClassSecondaryConstructorParameterLiftingToExpect/expectsAndActualsByActualClassSecondaryConstructorParameter.test")
    public void testByActualClassSecondaryConstructorParameterLiftingToExpect_ExpectsAndActualsByActualClassSecondaryConstructorParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualClassSecondaryConstructorParameterLiftingToExpect/expectsAndActualsByActualClassSecondaryConstructorParameter.test");
    }

    @TestMetadata("byActualFun/byActualFun.test")
    public void testByActualFun_ByActualFun() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualFun/byActualFun.test");
    }

    @TestMetadata("byActualFunParamererLiftingToExpect/byActualFunParameterLiftingToExpect.test")
    public void testByActualFunParamererLiftingToExpect_ByActualFunParameterLiftingToExpect() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualFunParamererLiftingToExpect/byActualFunParameterLiftingToExpect.test");
    }

    @TestMetadata("byActualFunParamererNoLiftingToExpect/byActualFunParameterNoLiftingToExpect.test")
    public void testByActualFunParamererNoLiftingToExpect_ByActualFunParameterNoLiftingToExpect() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualFunParamererNoLiftingToExpect/byActualFunParameterNoLiftingToExpect.test");
    }

    @TestMetadata("byActualVal/byActualVal.test")
    public void testByActualVal_ByActualVal() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byActualVal/byActualVal.test");
    }

    @TestMetadata("byExpectClass/byExpectClass.test")
    public void testByExpectClass_ByExpectClass() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClass/byExpectClass.test");
    }

    @TestMetadata("byExpectClassMemberFun/byExpectClassMemberFun.test")
    public void testByExpectClassMemberFun_ByExpectClassMemberFun() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassMemberFun/byExpectClassMemberFun.test");
    }

    @TestMetadata("byExpectClassMemberFunParameter/byExpectClassMemberFunParameter.test")
    public void testByExpectClassMemberFunParameter_ByExpectClassMemberFunParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassMemberFunParameter/byExpectClassMemberFunParameter.test");
    }

    @TestMetadata("byExpectClassMemberVal/byExpectClassMemberVal.test")
    public void testByExpectClassMemberVal_ByExpectClassMemberVal() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassMemberVal/byExpectClassMemberVal.test");
    }

    @TestMetadata("byExpectClassPrimaryConstructorParameter/expectsAndActualsByExpectClassPrimaryConstructorParameter.test")
    public void testByExpectClassPrimaryConstructorParameter_ExpectsAndActualsByExpectClassPrimaryConstructorParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassPrimaryConstructorParameter/expectsAndActualsByExpectClassPrimaryConstructorParameter.test");
    }

    @TestMetadata("byExpectClassSecondaryConstructor/byExpectClassSecondaryConstructor.test")
    public void testByExpectClassSecondaryConstructor_ByExpectClassSecondaryConstructor() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassSecondaryConstructor/byExpectClassSecondaryConstructor.test");
    }

    @TestMetadata("byExpectClassSecondaryConstructorParameter/expectsAndActualsByExpectClassSecondaryConstructorParameter.test")
    public void testByExpectClassSecondaryConstructorParameter_ExpectsAndActualsByExpectClassSecondaryConstructorParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectClassSecondaryConstructorParameter/expectsAndActualsByExpectClassSecondaryConstructorParameter.test");
    }

    @TestMetadata("byExpectCompanion/byExpectCompanion.test")
    public void testByExpectCompanion_ByExpectCompanion() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectCompanion/byExpectCompanion.test");
    }

    @TestMetadata("byExpectFun/byExpectFun.test")
    public void testByExpectFun_ByExpectFun() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectFun/byExpectFun.test");
    }

    @TestMetadata("byExpectFunParamerer/byExpectFunParameter.test")
    public void testByExpectFunParamerer_ByExpectFunParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectFunParamerer/byExpectFunParameter.test");
    }

    @TestMetadata("byExpectFunVarargParamerer/byExpectFunVarargParameter.test")
    public void testByExpectFunVarargParamerer_ByExpectFunVarargParameter() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectFunVarargParamerer/byExpectFunVarargParameter.test");
    }

    @TestMetadata("byExpectObject/byExpectObject.test")
    public void testByExpectObject_ByExpectObject() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectObject/byExpectObject.test");
    }

    @TestMetadata("byExpectVal/byExpectVal.test")
    public void testByExpectVal_ByExpectVal() throws Exception {
        runTest("idea/testData/refactoring/safeDeleteMultiModule/byExpectVal/byExpectVal.test");
    }
}
