/*
 * MIT License
 *
 * Copyright (c) 2021 Todd Ginsberg
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.ginsberg.junit.exit;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class DisallowExitSecurityManagerTest {

    @Test
    @DisplayName("Captures first exit status code only")
    void capturesFirstExitCode() {
        final DisallowExitSecurityManager securityManager = new DisallowExitSecurityManager(null);
        exit(securityManager, 1);
        exit(securityManager, 2);
        assertEquals(Integer.valueOf(1), securityManager.getFirstExitStatusCode());
    }

    @Test
    @DisplayName("Counts number of exits prevented")
    void countsExitsPrevented() {
        final DisallowExitSecurityManager securityManager = new DisallowExitSecurityManager(null);
        exit(securityManager, 1);
        exit(securityManager, 2);
        assertEquals(2, securityManager.getPreventedSystemExitCount());
    }

    private void exit(final SecurityManager securityManager, int code) {
        try {
            securityManager.checkExit(code);
        } catch (final SystemExitPreventedException e) {
            assertEquals(code, e.getStatusCode());
            // Gulp!
        }
    }

}