#!/bin/sh
set -e

DEB_VERSION_UPSTREAM=$2
UPSTREAM_TARBALL=$3
DEB_SOURCE=jruby-maven-plugins
DEB_VERSION="${DEB_VERSION_UPSTREAM}.ds1"
REPACKED_DIR="./${DEB_SOURCE}-${DEB_VERSION}.orig"
REPACKED_TARBALL="./${DEB_SOURCE}_${DEB_VERSION}.orig.tar.gz"
TAR_FLAGS="--numeric-owner --owner=0 --group=0"

mkdir "${REPACKED_DIR}" && tar xzf "${UPSTREAM_TARBALL}" --strip=1 -C "${REPACKED_DIR}"
find "${REPACKED_DIR}" -type f -name 'ant-*.pom' -delete
find "${REPACKED_DIR}" -type f -name '*.jar' -delete
GZIP=--best tar $TAR_FLAGS -czf "${REPACKED_TARBALL}" "${REPACKED_DIR}"
rm -rf "${REPACKED_DIR}" "${UPSTREAM_TARBALL}"
