/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.cache;
public class CacheBuilderTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.cache.testModule";
}
public void testConcurrencyLevel_large() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testConcurrencyLevel_large();
}

public void testConcurrencyLevel_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testConcurrencyLevel_setTwice();
}

public void testConcurrencyLevel_zero() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testConcurrencyLevel_zero();
}

public void testInitialCapacity_large() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testInitialCapacity_large();
}

public void testInitialCapacity_negative() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testInitialCapacity_negative();
}

public void testInitialCapacity_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testInitialCapacity_setTwice();
}

public void testMaximumSize_negative() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testMaximumSize_negative();
}

public void testMaximumSize_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testMaximumSize_setTwice();
}

public void testNewBuilder() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testNewBuilder();
}

public void testRemovalListener_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testRemovalListener_setTwice();
}

public void testTicker_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTicker_setTwice();
}

public void testTimeToIdleAndToLive() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToIdleAndToLive();
}

public void testTimeToIdle_negative() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToIdle_negative();
}

public void testTimeToIdle_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToIdle_setTwice();
}

public void testTimeToIdle_small() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToIdle_small();
}

public void testTimeToLive_negative() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToLive_negative();
}

public void testTimeToLive_setTwice() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToLive_setTwice();
}

public void testTimeToLive_small() throws Exception {
  com.google.common.cache.CacheBuilderTest testCase = new com.google.common.cache.CacheBuilderTest();
  testCase.testTimeToLive_small();
}
}
