#!/usr/bin/perl -w
#
# Convert a single gnuplot demo script to a web page
# Usage:
#	webify xxx
#
# Reads xxx.dem and creates xxx.html along with associated 
# png images output to xxx.<n>.png 
#
# If gpsavediff is present also create a set of scripts
# xxx.<n>.gnu corresponding to the minimal set of commands 
# needed to generate that png image.
#
# If gnuplot_demo.css is present, link to it as a stylesheet.
#
# Ethan A Merritt <merritt@u.washington.edu>
# December 2003
#
# EAM Jan 2004
#   use gpsavediff if available
#   link to gnuplot_demo.css if available
#
# EAM Aug 2005
# If DEMOTERM is present as an environmental variable, then use
#    set term DEMOTERM
# rather than the default terminal settings
# E.g. (for image demo)
#    setenv DEMOTERM "png truecolor enhanced font arial 8 transparent size 420,320"
#    ./webify.pl image
#
# EAM Apr 2011
# Mouseable demos
#
use Env qw(DEMOTERM GNUPLOT_LIB);

use Time::localtime;
use HTML::Entities;

# Use the in-tree copy of gnuplot if there is one
	my $gnuplot = ( -x "../../src/gnuplot" ) ? "../../src/gnuplot" : "gnuplot" ;

	if ((!defined $ENV{GNUPLOT_LIB}) || $GNUPLOT_LIB eq "") {
	    $GNUPLOT_LIB = "..";
	}
	my $date = ctime();
	my $plot = 1;
	my $mousing = 0;
	my $name = "foo";

# options
	my $iar = 0;
	if ($ARGV[$iar] eq "--mouse") {
	    $mousing = 1;
	    $iar++;
	}
	$name = $ARGV[$iar];

print STDERR $name, "\n";

# input and output files
	open(IN,  "<$GNUPLOT_LIB/$name.dem") or die "can't open $GNUPLOT_LIB/$name.dem";
	open(OUT, ">$name.html") or die "can't open $name.html";
	binmode IN, ":encoding(UTF-8)";
	binmode OUT,":encoding(UTF-8)";

# open pipe to gnuplot and set terminal type
	open(GNUPLOT, "|$gnuplot") or die "can't find gnuplot";
	binmode GNUPLOT,":encoding(UTF-8)";
	if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
	    print GNUPLOT "set term $DEMOTERM\n";
	} else {
	    if ($mousing) {
		print GNUPLOT "set term svg enhanced font 'arial,10' mouse name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
	    } else {
		print GNUPLOT "set term svg enhanced font 'arial,10' name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
	    }
	}
	print GNUPLOT "set output \"$name.$plot.svg\"\n";

# suppress animations
 	print GNUPLOT "NO_ANIMATION = 1\n";

# find out if gpsavediff is available in current path
	my $savescripts = T;
	{local $^W=0; $savescripts = open(FOO, "|gpsavediff") }
	close FOO if ($savescripts);

# Boiler plate header
	print OUT "<!DOCTYPE HTML>\n";
	print OUT "<html>\n<head>\n<title>gnuplot demo script: $name.dem </title>\n";
	print OUT "<meta charset=\"UTF-8\" />\n";
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot_demo.css\" type=\"text/css\">\n"
		  if (-e "gnuplot_demo.css");
	print OUT "</head>\n";
	print OUT "<body>\n";
	print OUT "<a href=index.html><image src=return.png alt=\"Back to demo index\" class=\"float-right\"></a>\n";
	
	print OUT "<h2>gnuplot demo script: <font color=blue>$name.dem</font> </h2>\n";
	print OUT "<i>autogenerated by webify.pl on $date</i>";

# try to find gnuplot version
	$version = `$gnuplot --version`;
	print OUT "\n<br><i>gnuplot version $version</i>";
	print OUT "<hr>\n";

# Start processing
	print OUT "<table><tr><td valign=top>\n";
	print OUT "<object data=\"$name.$plot.svg\" type=\"image/svg+xml\" width=600 height=400 class=\"float-right\"/>\n";
	print OUT "</td><td>\n";


	print OUT "<pre>\n";

	while (<IN>) {
		if (/^ *pause -1/) {
			if ($savescripts) {
			    print OUT "<br>Click <a href=$name.$plot.gnu>here</a> ",
				  "for minimal script to generate this plot\n";
			    print GNUPLOT "save \"| gpsavediff > $name.$plot.gnu\"\n";
			}
			print OUT "</pre></td></tr></table>\n<br clear=all>\n<hr>\n";
			$plot++;
			print OUT "<table class=\"noborder\"><tr><td>\n";
			print OUT "<object data=\"$name.$plot.svg\" type=\"image/svg+xml\" width=600 height=400 class=\"float-right\"/>\n";
			print OUT "</td><td valign=top>\n";

			print OUT "<pre>\n";
			if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
			    print GNUPLOT "set term $DEMOTERM\n";
			} else {
			    if ($mousing) {
				print GNUPLOT "set term svg enhanced font 'arial,10' mouse name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
			    } else {
				print GNUPLOT "set term svg enhanced font 'arial,10' name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
			    }
			}
			print GNUPLOT "set output \"$name.$plot.svg\"\n";
		} elsif (/^pause/) {
			if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
			    print GNUPLOT "set term $DEMOTERM\n";
			} else {
			    if ($mousing) {
				print GNUPLOT "set term svg enhanced font 'arial,10' mouse name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
			    } else {
				print GNUPLOT "set term svg enhanced font 'arial,10' name \"$name"."_$plot\" jsdir '.' size 600,400 dynamic\n";
			    }
			}
			print GNUPLOT "set output \"$name.$plot.svg\"\n";
		} else {
			print OUT HTML::Entities::encode($_);
			print GNUPLOT;
		}
	}

# Amazingly enough, that's it.
# Replace leftover empty file with a legal svg empty plot before leaving.
	close GNUPLOT;
	unlink("$name.$plot.svg");
	open(EMPTY, ">$name.$plot.svg") or die "can't open empty plot";
	print EMPTY <<MT
<?xml version="1.0"  standalone="no"?>
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" 
 "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg width="1" height="1"
 xmlns="http://www.w3.org/2000/svg"
 xmlns:xlink="http://www.w3.org/1999/xlink">
</svg>
MT
;
	print OUT "</pre></td></tr><table>\n";
	print OUT "</body>\n</html>\n";

