/* cmthandler.c generated by valac 0.16.1, the Vala compiler
 * generated from cmthandler.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Denis 'GNUtoo' Carikli <GNUtoo@no-log.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <alsa/asoundlib.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <cmtspeech.h>
#include <fsoaudio.h>
#include <errno.h>
#include <libcmtspeechdata.h>


#define TYPE_RING_BUFFER (ring_buffer_get_type ())
#define RING_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RING_BUFFER, RingBuffer))
#define RING_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RING_BUFFER, RingBufferClass))
#define IS_RING_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RING_BUFFER))
#define IS_RING_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RING_BUFFER))
#define RING_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RING_BUFFER, RingBufferClass))

typedef struct _RingBuffer RingBuffer;
typedef struct _RingBufferClass RingBufferClass;
typedef struct _RingBufferPrivate RingBufferPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CMT_HANDLER (cmt_handler_get_type ())
#define CMT_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CMT_HANDLER, CmtHandler))
#define CMT_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CMT_HANDLER, CmtHandlerClass))
#define IS_CMT_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CMT_HANDLER))
#define IS_CMT_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CMT_HANDLER))
#define CMT_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CMT_HANDLER, CmtHandlerClass))

typedef struct _CmtHandler CmtHandler;
typedef struct _CmtHandlerClass CmtHandlerClass;
typedef struct _CmtHandlerPrivate CmtHandlerPrivate;
#define _cmtspeech_close0(var) ((var == NULL) ? NULL : (var = (cmtspeech_close (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _fso_audio_pcm_device_unref0(var) ((var == NULL) ? NULL : (var = (fso_audio_pcm_device_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))

/**
 * @class RingBuffer
 *
 * Provides a ring buffer for alsa frames
 **/
typedef enum  {
	RING_ERROR_Overflow,
	RING_ERROR_Underflow
} RingError;
#define RING_ERROR ring_error_quark ()
struct _RingBuffer {
	FsoFrameworkAbstractObject parent_instance;
	RingBufferPrivate * priv;
};

struct _RingBufferClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _RingBufferPrivate {
	guint8* ring;
	gint ring_length1;
	gint _ring_size_;
	gint ring_head;
	gint ring_tail;
	gint ring_size;
};

struct _CmtHandler {
	FsoFrameworkAbstractObject parent_instance;
	CmtHandlerPrivate * priv;
};

struct _CmtHandlerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _CmtHandlerPrivate {
	cmtspeech_t* connection;
	GIOChannel* channel;
	FsoAudioPcmDevice* pcmout;
	FsoAudioPcmDevice* pcmin;
	gboolean status;
	snd_pcm_format_t format;
	snd_pcm_access_t access;
	guint8* silence_buffer;
	gint silence_buffer_length1;
	gint _silence_buffer_size_;
	GThread* playbackThread;
	gint runPlaybackThread;
	GMutex* playbackMutex;
	RingBuffer* fromModem;
	GThread* recordThread;
	gboolean runRecordThread;
	GMutex* recordMutex;
	RingBuffer* toModem;
	gint timing;
};


static gpointer ring_buffer_parent_class = NULL;
static GType ring_buffer_type_id = 0;
static gpointer cmt_handler_parent_class = NULL;
static GType cmt_handler_type_id = 0;

gint snd_pcm_format_set_silence (snd_pcm_format_t format, void* data, guint samples);
GQuark ring_error_quark (void);
GType ring_buffer_get_type (void) G_GNUC_CONST;
GType ring_buffer_register_type (GTypeModule * module);
#define RING_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RING_BUFFER, RingBufferPrivate))
enum  {
	RING_BUFFER_DUMMY_PROPERTY
};
RingBuffer* ring_buffer_new (gint size);
RingBuffer* ring_buffer_construct (GType object_type, gint size);
void ring_buffer_write (RingBuffer* self, guint8* x, int x_length1, gint count, GError** error);
void ring_buffer_read (RingBuffer* self, guint8* x, int x_length1, gint count, GError** error);
void ring_buffer_reset (RingBuffer* self);
static gchar* ring_buffer_real_repr (FsoFrameworkAbstractObject* base);
static void ring_buffer_finalize (GObject* obj);
GType cmt_handler_get_type (void) G_GNUC_CONST;
GType cmt_handler_register_type (GTypeModule * module);
#define CMT_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CMT_HANDLER, CmtHandlerPrivate))
enum  {
	CMT_HANDLER_DUMMY_PROPERTY
};
#define CMT_HANDLER_FCOUNT 160
#define CMT_HANDLER_FRAMESIZE 2
#define CMT_HANDLER_BUFSIZE ((3 * CMT_HANDLER_FCOUNT) * CMT_HANDLER_FRAMESIZE)
CmtHandler* cmt_handler_new (void);
CmtHandler* cmt_handler_construct (GType object_type);
static gboolean cmt_handler_onInputFromChannel (CmtHandler* self, GIOChannel* source, GIOCondition condition);
static gboolean _cmt_handler_onInputFromChannel_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void cmt_handler_play_silence (CmtHandler* self, gint count);
static gboolean cmt_handler_feed_to_modem (CmtHandler* self);
static void* cmt_handler_playbackThreadFunc (CmtHandler* self);
static void* cmt_handler_recordThreadFunc (CmtHandler* self);
static gboolean _cmt_handler_feed_to_modem_gsource_func (gpointer self);
static void cmt_handler_alsaSinkSetup (CmtHandler* self);
static gpointer _cmt_handler_playbackThreadFunc_gthread_func (gpointer self);
static void cmt_handler_alsaSrcSetup (CmtHandler* self);
static gpointer _cmt_handler_recordThreadFunc_gthread_func (gpointer self);
static void cmt_handler_alsaSinkCleanup (CmtHandler* self);
static void cmt_handler_alsaSrcCleanup (CmtHandler* self);
static void cmt_handler_handleTimingUpdate (CmtHandler* self, struct cmtspeech_event_s* event);
static void cmt_handler_handleDataEvent (CmtHandler* self);
const gchar* cmtspeech_state_to_string (gint self);
static const char* _cmtspeech_state_to_string (gint value);
static void cmt_handler_handleControlEvent (CmtHandler* self);
const gchar* cmtspeech_transition_to_string (gint self);
static const char* _cmtspeech_transition_to_string (gint value);
static gchar* cmt_handler_real_repr (FsoFrameworkAbstractObject* base);
void cmt_handler_setAudioStatus (CmtHandler* self, gboolean enabled);
static void cmt_handler_finalize (GObject* obj);


GQuark ring_error_quark (void) {
	return g_quark_from_static_string ("ring_error-quark");
}


RingBuffer* ring_buffer_construct (GType object_type, gint size) {
	RingBuffer * self = NULL;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	gint _tmp2_;
	self = (RingBuffer*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = size;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	self->priv->ring = (g_free (self->priv->ring), NULL);
	self->priv->ring = _tmp1_;
	self->priv->ring_length1 = _tmp0_;
	self->priv->_ring_size_ = self->priv->ring_length1;
	self->priv->ring_head = 0;
	self->priv->ring_tail = 0;
	_tmp2_ = size;
	self->priv->ring_size = _tmp2_;
	return self;
}


RingBuffer* ring_buffer_new (gint size) {
	return ring_buffer_construct (TYPE_RING_BUFFER, size);
}


void ring_buffer_write (RingBuffer* self, guint8* x, int x_length1, gint count, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint new_ring_head;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint free;
	gint _tmp7_;
	FsoFrameworkLogger* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	FsoFrameworkLogger* _tmp36_;
	gint _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	gint _tmp43_;
	gboolean _tmp46_;
	gint _tmp83_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ring_head;
	_tmp1_ = count;
	_tmp2_ = self->priv->ring_size;
	new_ring_head = (_tmp0_ + _tmp1_) % _tmp2_;
	_tmp3_ = self->priv->ring_size;
	_tmp4_ = self->priv->ring_tail;
	_tmp5_ = self->priv->ring_head;
	_tmp6_ = self->priv->ring_size;
	free = ((_tmp3_ + _tmp4_) - _tmp5_) % _tmp6_;
	_tmp7_ = free;
	if (_tmp7_ == 0) {
		gint _tmp8_;
		_tmp8_ = self->priv->ring_size;
		free = _tmp8_;
	}
	_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp10_ = self->priv->ring_head;
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->ring_tail;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = count;
	_tmp17_ = g_strdup_printf ("%i", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = free;
	_tmp20_ = g_strdup_printf ("%i", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("RingBuffer.write: ring_head=", _tmp12_, ", ring_tail=", _tmp15_, ", count=", _tmp18_, ", free=", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	fso_framework_logger_debug (_tmp9_, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp24_ = count;
	_tmp25_ = free;
	if (_tmp24_ > _tmp25_) {
		gint _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		_tmp26_ = free;
		_tmp27_ = g_strdup_printf ("%i", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = count;
		_tmp30_ = g_strdup_printf ("%i", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat ("Buffer is full (free: ", _tmp28_, " / wanted to write: ", _tmp31_, ")", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (RING_ERROR, RING_ERROR_Overflow, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
		_inner_error_ = _tmp35_;
		if (_inner_error_->domain == RING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp36_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp37_ = new_ring_head;
	_tmp38_ = g_strdup_printf ("%i", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat ("RingBuffer.write: new ring_head would be ", _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	fso_framework_logger_debug (_tmp36_, _tmp41_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp43_ = new_ring_head;
	if (_tmp43_ == 0) {
		_tmp42_ = TRUE;
	} else {
		gint _tmp44_;
		gint _tmp45_;
		_tmp44_ = new_ring_head;
		_tmp45_ = self->priv->ring_head;
		_tmp42_ = _tmp44_ > _tmp45_;
	}
	_tmp46_ = _tmp42_;
	if (_tmp46_) {
		FsoFrameworkLogger* _tmp47_;
		gint _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		guint8* _tmp53_;
		gint _tmp53__length1;
		gint _tmp54_;
		guint8* _tmp55_;
		gint _tmp55__length1;
		gint _tmp56_;
		_tmp47_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp48_ = count;
		_tmp49_ = g_strdup_printf ("%i", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat ("RingBuffer.write: does not overlap - chunk = ", _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		fso_framework_logger_debug (_tmp47_, _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_tmp53_ = self->priv->ring;
		_tmp53__length1 = self->priv->ring_length1;
		_tmp54_ = self->priv->ring_head;
		_tmp55_ = x;
		_tmp55__length1 = x_length1;
		_tmp56_ = count;
		memcpy (&_tmp53_[_tmp54_], _tmp55_, (gsize) _tmp56_);
	} else {
		FsoFrameworkLogger* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_;
		guint8* _tmp64_;
		gint _tmp64__length1;
		gint _tmp65_;
		guint8* _tmp66_;
		gint _tmp66__length1;
		gint _tmp67_;
		gint _tmp68_;
		FsoFrameworkLogger* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		guint8* _tmp76_;
		gint _tmp76__length1;
		guint8* _tmp77_;
		gint _tmp77__length1;
		gint _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		_tmp57_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp58_ = self->priv->ring_size;
		_tmp59_ = self->priv->ring_head;
		_tmp60_ = g_strdup_printf ("%i", _tmp58_ - _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat ("RingBuffer.write: does overlap - first chunk = ", _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		fso_framework_logger_debug (_tmp57_, _tmp63_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		_tmp64_ = self->priv->ring;
		_tmp64__length1 = self->priv->ring_length1;
		_tmp65_ = self->priv->ring_head;
		_tmp66_ = x;
		_tmp66__length1 = x_length1;
		_tmp67_ = self->priv->ring_size;
		_tmp68_ = self->priv->ring_head;
		memcpy (&_tmp64_[_tmp65_], _tmp66_, (gsize) (_tmp67_ - _tmp68_));
		_tmp69_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp70_ = self->priv->ring_size;
		_tmp71_ = self->priv->ring_head;
		_tmp72_ = g_strdup_printf ("%i", _tmp70_ - _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strconcat ("RingBuffer.write: second chunk = ", _tmp73_, NULL);
		_tmp75_ = _tmp74_;
		fso_framework_logger_debug (_tmp69_, _tmp75_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		_tmp76_ = self->priv->ring;
		_tmp76__length1 = self->priv->ring_length1;
		_tmp77_ = x;
		_tmp77__length1 = x_length1;
		_tmp78_ = self->priv->ring_size;
		_tmp79_ = self->priv->ring_head;
		_tmp80_ = count;
		_tmp81_ = self->priv->ring_size;
		_tmp82_ = self->priv->ring_head;
		memcpy (&_tmp76_[0], &_tmp77_[_tmp78_ - _tmp79_], (gsize) (_tmp80_ - (_tmp81_ - _tmp82_)));
	}
	_tmp83_ = new_ring_head;
	self->priv->ring_head = _tmp83_;
}


void ring_buffer_read (RingBuffer* self, guint8* x, int x_length1, gint count, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint avail;
	FsoFrameworkLogger* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint new_ring_tail;
	FsoFrameworkLogger* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_;
	gboolean _tmp44_;
	gint _tmp82_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ring_size;
	_tmp1_ = self->priv->ring_head;
	_tmp2_ = self->priv->ring_tail;
	_tmp3_ = self->priv->ring_size;
	avail = ((_tmp0_ + _tmp1_) - _tmp2_) % _tmp3_;
	_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp5_ = self->priv->ring_head;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->ring_tail;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = count;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = avail;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("RingBuffer.read: ring_head=", _tmp7_, ", ring_tail=", _tmp10_, ", count=", _tmp13_, ", avail=", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	fso_framework_logger_debug (_tmp4_, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_tmp19_ = avail;
	_tmp20_ = count;
	if (_tmp19_ < _tmp20_) {
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		GError* _tmp29_;
		GError* _tmp30_;
		_tmp21_ = avail;
		_tmp22_ = g_strdup_printf ("%i", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = count;
		_tmp25_ = g_strdup_printf ("%i", _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat ("Buffer has only ", _tmp23_, " bytes available (", _tmp26_, " requested)", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_error_new_literal (RING_ERROR, RING_ERROR_Underflow, _tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		_inner_error_ = _tmp30_;
		if (_inner_error_->domain == RING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp31_ = self->priv->ring_tail;
	_tmp32_ = count;
	_tmp33_ = self->priv->ring_size;
	new_ring_tail = (_tmp31_ + _tmp32_) % _tmp33_;
	_tmp34_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp35_ = new_ring_tail;
	_tmp36_ = g_strdup_printf ("%i", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat ("RingBuffer.read: new_ring_tail would be ", _tmp37_, NULL);
	_tmp39_ = _tmp38_;
	fso_framework_logger_debug (_tmp34_, _tmp39_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_tmp41_ = new_ring_tail;
	if (_tmp41_ == 0) {
		_tmp40_ = TRUE;
	} else {
		gint _tmp42_;
		gint _tmp43_;
		_tmp42_ = new_ring_tail;
		_tmp43_ = self->priv->ring_tail;
		_tmp40_ = _tmp42_ > _tmp43_;
	}
	_tmp44_ = _tmp40_;
	if (_tmp44_) {
		FsoFrameworkLogger* _tmp45_;
		gint _tmp46_;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		guint8* _tmp51_;
		gint _tmp51__length1;
		guint8* _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		gint _tmp54_;
		_tmp45_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp46_ = count;
		_tmp47_ = g_strdup_printf ("%i", _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat ("RingBuffer.read: does not wrap - chunk = ", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		fso_framework_logger_debug (_tmp45_, _tmp50_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_tmp51_ = x;
		_tmp51__length1 = x_length1;
		_tmp52_ = self->priv->ring;
		_tmp52__length1 = self->priv->ring_length1;
		_tmp53_ = self->priv->ring_tail;
		_tmp54_ = count;
		memcpy (_tmp51_, &_tmp52_[_tmp53_], (gsize) _tmp54_);
	} else {
		FsoFrameworkLogger* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_;
		guint8* _tmp62_;
		gint _tmp62__length1;
		guint8* _tmp63_;
		gint _tmp63__length1;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		FsoFrameworkLogger* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_;
		guint8* _tmp75_;
		gint _tmp75__length1;
		gint _tmp76_;
		gint _tmp77_;
		guint8* _tmp78_;
		gint _tmp78__length1;
		gint _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		_tmp55_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp56_ = self->priv->ring_size;
		_tmp57_ = self->priv->ring_tail;
		_tmp58_ = g_strdup_printf ("%i", _tmp56_ - _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strconcat ("RingBuffer.read: does overwrap - first chunk = ", _tmp59_, NULL);
		_tmp61_ = _tmp60_;
		fso_framework_logger_debug (_tmp55_, _tmp61_);
		_g_free0 (_tmp61_);
		_g_free0 (_tmp59_);
		_tmp62_ = x;
		_tmp62__length1 = x_length1;
		_tmp63_ = self->priv->ring;
		_tmp63__length1 = self->priv->ring_length1;
		_tmp64_ = self->priv->ring_tail;
		_tmp65_ = self->priv->ring_size;
		_tmp66_ = self->priv->ring_tail;
		memcpy (_tmp62_, &_tmp63_[_tmp64_], (gsize) (_tmp65_ - _tmp66_));
		_tmp67_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp68_ = count;
		_tmp69_ = self->priv->ring_size;
		_tmp70_ = self->priv->ring_tail;
		_tmp71_ = g_strdup_printf ("%i", _tmp68_ - (_tmp69_ - _tmp70_));
		_tmp72_ = _tmp71_;
		_tmp73_ = g_strconcat ("RingBuffer.read: second chunk = ", _tmp72_, NULL);
		_tmp74_ = _tmp73_;
		fso_framework_logger_debug (_tmp67_, _tmp74_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		_tmp75_ = x;
		_tmp75__length1 = x_length1;
		_tmp76_ = self->priv->ring_size;
		_tmp77_ = self->priv->ring_tail;
		_tmp78_ = self->priv->ring;
		_tmp78__length1 = self->priv->ring_length1;
		_tmp79_ = count;
		_tmp80_ = self->priv->ring_size;
		_tmp81_ = self->priv->ring_tail;
		memcpy (&_tmp75_[_tmp76_ - _tmp77_], _tmp78_, (gsize) (_tmp79_ - (_tmp80_ - _tmp81_)));
	}
	_tmp82_ = new_ring_tail;
	self->priv->ring_tail = _tmp82_;
}


void ring_buffer_reset (RingBuffer* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ring_head = 0;
	_tmp0_ = self->priv->ring_head;
	self->priv->ring_tail = _tmp0_;
}


static gchar* ring_buffer_real_repr (FsoFrameworkAbstractObject* base) {
	RingBuffer * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (RingBuffer*) base;
	_tmp0_ = g_strdup ("<RingBuffer>");
	result = _tmp0_;
	return result;
}


static void ring_buffer_class_init (RingBufferClass * klass) {
	ring_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RingBufferPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = ring_buffer_real_repr;
	G_OBJECT_CLASS (klass)->finalize = ring_buffer_finalize;
}


static void ring_buffer_instance_init (RingBuffer * self) {
	self->priv = RING_BUFFER_GET_PRIVATE (self);
}


static void ring_buffer_finalize (GObject* obj) {
	RingBuffer * self;
	self = RING_BUFFER (obj);
	self->priv->ring = (g_free (self->priv->ring), NULL);
	G_OBJECT_CLASS (ring_buffer_parent_class)->finalize (obj);
}


GType ring_buffer_get_type (void) {
	return ring_buffer_type_id;
}


GType ring_buffer_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RingBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ring_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RingBuffer), 0, (GInstanceInitFunc) ring_buffer_instance_init, NULL };
	ring_buffer_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "RingBuffer", &g_define_type_info, 0);
	return ring_buffer_type_id;
}


static gboolean _cmt_handler_onInputFromChannel_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = cmt_handler_onInputFromChannel (self, source, condition);
	return result;
}


CmtHandler* cmt_handler_construct (GType object_type) {
	CmtHandler * self = NULL;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FsoFrameworkLogger* _tmp2_;
	gboolean _tmp3_ = FALSE;
	FsoFrameworkLogger* _tmp4_;
	gboolean _tmp5_ = FALSE;
	cmtspeech_t* _tmp6_;
	cmtspeech_t* _tmp7_;
	cmtspeech_t* _tmp9_;
	gint _tmp10_ = 0;
	gint fd;
	gint _tmp11_;
	RingBuffer* _tmp13_;
	RingBuffer* _tmp14_;
	FsoFrameworkLogger* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	GIOChannel* _tmp18_;
	GIOChannel* _tmp19_;
	guint8* _tmp20_ = NULL;
	snd_pcm_format_t _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	FsoFrameworkLogger* _tmp23_;
	self = (CmtHandler*) fso_framework_abstract_object_construct (object_type);
	self->priv->status = FALSE;
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Initializing cmtspeech");
	g_assert (_tmp1_);
	cmtspeech_init ();
	_tmp2_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp3_ = fso_framework_logger_debug (_tmp2_, "Setting up traces");
	g_assert (_tmp3_);
	cmtspeech_trace_toggle (CMTSPEECH_TRACE_STATE_CHANGE, TRUE);
	cmtspeech_trace_toggle (CMTSPEECH_TRACE_IO, TRUE);
	cmtspeech_trace_toggle (CMTSPEECH_TRACE_DEBUG, TRUE);
	_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp5_ = fso_framework_logger_debug (_tmp4_, "Instanciating connection");
	g_assert (_tmp5_);
	_tmp6_ = cmtspeech_open ();
	_cmtspeech_close0 (self->priv->connection);
	self->priv->connection = _tmp6_;
	_tmp7_ = self->priv->connection;
	if (_tmp7_ == NULL) {
		FsoFrameworkLogger* _tmp8_;
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_error (_tmp8_, "Can't instanciate connection");
		return self;
	}
	_tmp9_ = self->priv->connection;
	_tmp10_ = cmtspeech_descriptor (_tmp9_);
	fd = _tmp10_;
	_tmp11_ = fd;
	if (_tmp11_ == (-1)) {
		FsoFrameworkLogger* _tmp12_;
		_tmp12_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_error (_tmp12_, "Cmtspeech file descriptor invalid");
	}
	self->priv->timing = 50;
	_tmp13_ = ring_buffer_new (CMT_HANDLER_BUFSIZE);
	_g_object_unref0 (self->priv->fromModem);
	self->priv->fromModem = _tmp13_;
	_tmp14_ = ring_buffer_new (CMT_HANDLER_BUFSIZE);
	_g_object_unref0 (self->priv->toModem);
	self->priv->toModem = _tmp14_;
	_tmp15_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp16_ = fso_framework_logger_debug (_tmp15_, "Hooking up fd with main loop");
	g_assert (_tmp16_);
	_tmp17_ = fd;
	_tmp18_ = g_io_channel_unix_new (_tmp17_);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->channel = _tmp18_;
	_tmp19_ = self->priv->channel;
	g_io_add_watch (_tmp19_, G_IO_IN | G_IO_HUP, _cmt_handler_onInputFromChannel_gio_func, self);
	_tmp20_ = g_new0 (guint8, CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE);
	self->priv->silence_buffer = (g_free (self->priv->silence_buffer), NULL);
	self->priv->silence_buffer = _tmp20_;
	self->priv->silence_buffer_length1 = CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE;
	self->priv->_silence_buffer_size_ = self->priv->silence_buffer_length1;
	_tmp21_ = self->priv->format;
	_tmp22_ = self->priv->silence_buffer;
	_tmp22__length1 = self->priv->silence_buffer_length1;
	snd_pcm_format_set_silence (_tmp21_, _tmp22_, (guint) CMT_HANDLER_FCOUNT);
	_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp23_, "Created");
	return self;
}


CmtHandler* cmt_handler_new (void) {
	return cmt_handler_construct (TYPE_CMT_HANDLER);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void cmt_handler_play_silence (CmtHandler* self, gint count) {
	snd_pcm_sframes_t ret = {0};
	gint retries;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	retries = 3;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gboolean _tmp3_;
		_tmp1_ = count;
		if (_tmp1_ > 0) {
			gint _tmp2_;
			_tmp2_ = retries;
			_tmp0_ = _tmp2_ > 0;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
		{
			FsoAudioPcmDevice* _tmp4_;
			guint8* _tmp5_;
			gint _tmp5__length1;
			snd_pcm_sframes_t _tmp6_ = {0};
			snd_pcm_sframes_t _tmp7_;
			snd_pcm_sframes_t _tmp8_;
			_tmp4_ = self->priv->pcmout;
			_tmp5_ = self->priv->silence_buffer;
			_tmp5__length1 = self->priv->silence_buffer_length1;
			_tmp6_ = fso_audio_pcm_device_writei (_tmp4_, _tmp5_, _tmp5__length1, (snd_pcm_uframes_t) CMT_HANDLER_FCOUNT, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch1_fso_audio_sound_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			ret = _tmp7_;
			_tmp8_ = ret;
			if (_tmp8_ == ((snd_pcm_sframes_t) (-EPIPE))) {
				FsoAudioPcmDevice* _tmp9_;
				gint _tmp10_;
				_tmp9_ = self->priv->pcmout;
				fso_audio_pcm_device_recover (_tmp9_, -EPIPE, 0);
				_tmp10_ = retries;
				retries = _tmp10_ - 1;
			} else {
				gint _tmp11_;
				_tmp11_ = count;
				count = _tmp11_ - 1;
			}
		}
		goto __finally1;
		__catch1_fso_audio_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			_tmp15_ = string_to_string (_tmp14_);
			_tmp16_ = g_strconcat ("Error: ", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			fso_framework_logger_error (_tmp12_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_error_free0 (e);
			return;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean cmt_handler_feed_to_modem (CmtHandler* self) {
	gboolean result = FALSE;
	struct cmtspeech_buffer_s* ulbuf;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	cmtspeech_t* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	ulbuf = NULL;
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "feeding from ringbuffer to modem");
	g_assert (_tmp1_);
	_tmp2_ = self->priv->connection;
	_tmp3_ = cmtspeech_is_active (_tmp2_);
	if (_tmp3_) {
		cmtspeech_t* _tmp4_;
		struct cmtspeech_buffer_s* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint ok;
		gint _tmp7_;
		_tmp4_ = self->priv->connection;
		_tmp6_ = cmtspeech_ul_buffer_acquire (_tmp4_, &_tmp5_);
		_0 (ulbuf);
		ulbuf = _tmp5_;
		ok = _tmp6_;
		_tmp7_ = ok;
		if (_tmp7_ == 0) {
			FsoFrameworkLogger* _tmp8_;
			gboolean _tmp9_ = FALSE;
			cmtspeech_t* _tmp27_;
			struct cmtspeech_buffer_s* _tmp28_;
			_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp9_ = fso_framework_logger_debug (_tmp8_, "protocol state is ACTIVE_DLUL, uploading as well...");
			g_assert (_tmp9_);
			{
				GMutex* _tmp10_;
				RingBuffer* _tmp11_;
				struct cmtspeech_buffer_s* _tmp12_;
				guint8* _tmp13_;
				struct cmtspeech_buffer_s* _tmp14_;
				gint _tmp15_;
				GMutex* _tmp16_;
				_tmp10_ = self->priv->recordMutex;
				g_mutex_lock (_tmp10_);
				_tmp11_ = self->priv->toModem;
				_tmp12_ = ulbuf;
				_tmp13_ = _tmp12_->payload;
				_tmp14_ = ulbuf;
				_tmp15_ = _tmp14_->pcount;
				ring_buffer_read (_tmp11_, (guint8*) _tmp13_, -1, _tmp15_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RING_ERROR) {
						goto __catch2_ring_error;
					}
					_0 (ulbuf);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp16_ = self->priv->recordMutex;
				g_mutex_unlock (_tmp16_);
			}
			goto __finally2;
			__catch2_ring_error:
			{
				GError* e = NULL;
				GMutex* _tmp17_;
				gint _tmp18_ = 0;
				struct cmtspeech_buffer_s* _tmp19_;
				gint _tmp20_;
				struct cmtspeech_buffer_s* _tmp23_;
				guint8* _tmp24_;
				guint8* _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp17_ = self->priv->recordMutex;
				g_mutex_unlock (_tmp17_);
				_tmp19_ = ulbuf;
				_tmp20_ = _tmp19_->pcount;
				if (_tmp20_ > (CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE)) {
					_tmp18_ = CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE;
				} else {
					struct cmtspeech_buffer_s* _tmp21_;
					gint _tmp22_;
					_tmp21_ = ulbuf;
					_tmp22_ = _tmp21_->pcount;
					_tmp18_ = _tmp22_;
				}
				_tmp23_ = ulbuf;
				_tmp24_ = _tmp23_->payload;
				_tmp25_ = self->priv->silence_buffer;
				_tmp25__length1 = self->priv->silence_buffer_length1;
				_tmp26_ = _tmp18_;
				memcpy (_tmp24_, _tmp25_, (gsize) _tmp26_);
				_g_error_free0 (e);
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_0 (ulbuf);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp27_ = self->priv->connection;
			_tmp28_ = ulbuf;
			cmtspeech_ul_buffer_release (_tmp27_, _tmp28_);
		}
	}
	result = FALSE;
	_0 (ulbuf);
	return result;
}


static void* cmt_handler_playbackThreadFunc (CmtHandler* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	while (TRUE) {
		gint _tmp0_;
		guint8* _tmp1_ = NULL;
		guint8* buf;
		gint buf_length1;
		gint _buf_size_;
		snd_pcm_sframes_t frames = {0};
		_tmp0_ = self->priv->runPlaybackThread;
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = g_new0 (guint8, CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE);
		buf = _tmp1_;
		buf_length1 = CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE;
		_buf_size_ = buf_length1;
		{
			GMutex* _tmp2_;
			RingBuffer* _tmp3_;
			guint8* _tmp4_;
			gint _tmp4__length1;
			GMutex* _tmp5_;
			FsoAudioPcmDevice* _tmp6_;
			guint8* _tmp7_;
			gint _tmp7__length1;
			snd_pcm_sframes_t _tmp8_ = {0};
			snd_pcm_sframes_t _tmp9_;
			snd_pcm_sframes_t _tmp10_;
			_tmp2_ = self->priv->playbackMutex;
			g_mutex_lock (_tmp2_);
			_tmp3_ = self->priv->fromModem;
			_tmp4_ = buf;
			_tmp4__length1 = buf_length1;
			ring_buffer_read (_tmp3_, _tmp4_, _tmp4__length1, CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch3_fso_audio_sound_error;
				}
				if (_inner_error_->domain == RING_ERROR) {
					goto __catch3_ring_error;
				}
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp5_ = self->priv->playbackMutex;
			g_mutex_unlock (_tmp5_);
			_tmp6_ = self->priv->pcmout;
			_tmp7_ = buf;
			_tmp7__length1 = buf_length1;
			_tmp8_ = fso_audio_pcm_device_writei (_tmp6_, (guint8*) _tmp7_, _tmp7__length1, (snd_pcm_uframes_t) CMT_HANDLER_FCOUNT, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch3_fso_audio_sound_error;
				}
				if (_inner_error_->domain == RING_ERROR) {
					goto __catch3_ring_error;
				}
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			frames = _tmp9_;
			_tmp10_ = frames;
			if (_tmp10_ != ((snd_pcm_sframes_t) CMT_HANDLER_FCOUNT)) {
				FsoFrameworkLogger* _tmp11_;
				snd_pcm_sframes_t _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp11_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp12_ = frames;
				_tmp13_ = g_strdup_printf ("%li", (glong) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat ("frames: ", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				fso_framework_logger_debug (_tmp11_, _tmp16_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
			} else {
				snd_pcm_sframes_t _tmp17_;
				_tmp17_ = frames;
				if (_tmp17_ == ((snd_pcm_sframes_t) (-EPIPE))) {
					FsoAudioPcmDevice* _tmp18_;
					_tmp18_ = self->priv->pcmout;
					fso_audio_pcm_device_recover (_tmp18_, -EPIPE, 0);
				}
			}
		}
		goto __finally3;
		__catch3_fso_audio_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			_tmp22_ = string_to_string (_tmp21_);
			_tmp23_ = g_strconcat ("Error: ", _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			fso_framework_logger_error (_tmp19_, _tmp24_);
			_g_free0 (_tmp24_);
			_g_error_free0 (e);
		}
		goto __finally3;
		__catch3_ring_error:
		{
			GError* e = NULL;
			GMutex* _tmp25_;
			FsoFrameworkLogger* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = self->priv->playbackMutex;
			g_mutex_unlock (_tmp25_);
			_tmp26_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			_tmp29_ = string_to_string (_tmp28_);
			_tmp30_ = g_strconcat ("RingBuffer error: ", _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			fso_framework_logger_warning (_tmp26_, _tmp31_);
			_g_free0 (_tmp31_);
			cmt_handler_play_silence (self, 1);
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		buf = (g_free (buf), NULL);
	}
	result = NULL;
	return result;
}


static gboolean _cmt_handler_feed_to_modem_gsource_func (gpointer self) {
	gboolean result;
	result = cmt_handler_feed_to_modem (self);
	return result;
}


static void* cmt_handler_recordThreadFunc (CmtHandler* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	while (TRUE) {
		gboolean _tmp0_;
		guint8* _tmp1_ = NULL;
		guint8* buf;
		gint buf_length1;
		gint _buf_size_;
		snd_pcm_sframes_t frames = {0};
		gint _tmp2_;
		_tmp0_ = self->priv->runRecordThread;
		if (!(_tmp0_ == TRUE)) {
			break;
		}
		_tmp1_ = g_new0 (guint8, CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE);
		buf = _tmp1_;
		buf_length1 = CMT_HANDLER_FCOUNT * CMT_HANDLER_FRAMESIZE;
		_buf_size_ = buf_length1;
		_tmp2_ = self->priv->timing;
		g_timeout_add_full (G_PRIORITY_HIGH, (guint) _tmp2_, _cmt_handler_feed_to_modem_gsource_func, g_object_ref (self), g_object_unref);
		{
			FsoAudioPcmDevice* _tmp3_;
			guint8* _tmp4_;
			gint _tmp4__length1;
			snd_pcm_sframes_t _tmp5_ = {0};
			snd_pcm_sframes_t _tmp6_;
			snd_pcm_sframes_t _tmp7_;
			GMutex* _tmp9_;
			RingBuffer* _tmp10_;
			guint8* _tmp11_;
			gint _tmp11__length1;
			snd_pcm_sframes_t _tmp12_;
			GMutex* _tmp13_;
			_tmp3_ = self->priv->pcmin;
			_tmp4_ = buf;
			_tmp4__length1 = buf_length1;
			_tmp5_ = fso_audio_pcm_device_readi (_tmp3_, (guint8*) _tmp4_, _tmp4__length1, (snd_pcm_uframes_t) CMT_HANDLER_FCOUNT, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch4_fso_audio_sound_error;
				}
				if (_inner_error_->domain == RING_ERROR) {
					goto __catch4_ring_error;
				}
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			frames = _tmp6_;
			_tmp7_ = frames;
			if (_tmp7_ == ((snd_pcm_sframes_t) (-EPIPE))) {
				FsoAudioPcmDevice* _tmp8_;
				_tmp8_ = self->priv->pcmin;
				fso_audio_pcm_device_prepare (_tmp8_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
						goto __catch4_fso_audio_sound_error;
					}
					if (_inner_error_->domain == RING_ERROR) {
						goto __catch4_ring_error;
					}
					buf = (g_free (buf), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = self->priv->recordMutex;
			g_mutex_lock (_tmp9_);
			_tmp10_ = self->priv->toModem;
			_tmp11_ = buf;
			_tmp11__length1 = buf_length1;
			_tmp12_ = frames;
			ring_buffer_write (_tmp10_, _tmp11_, _tmp11__length1, ((gint) _tmp12_) * CMT_HANDLER_FRAMESIZE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch4_fso_audio_sound_error;
				}
				if (_inner_error_->domain == RING_ERROR) {
					goto __catch4_ring_error;
				}
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp13_ = self->priv->recordMutex;
			g_mutex_unlock (_tmp13_);
		}
		goto __finally4;
		__catch4_fso_audio_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			_tmp17_ = string_to_string (_tmp16_);
			_tmp18_ = g_strconcat ("SoundError: ", _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			fso_framework_logger_error (_tmp14_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_error_free0 (e);
		}
		goto __finally4;
		__catch4_ring_error:
		{
			GError* e = NULL;
			GMutex* _tmp20_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = self->priv->recordMutex;
			g_mutex_unlock (_tmp20_);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		buf = (g_free (buf), NULL);
	}
	result = NULL;
	return result;
}


static gpointer _cmt_handler_playbackThreadFunc_gthread_func (gpointer self) {
	gpointer result;
	result = cmt_handler_playbackThreadFunc (self);
	return result;
}


static void cmt_handler_alsaSinkSetup (CmtHandler* self) {
	gint channels;
	gint rate;
	FsoAudioPcmDevice* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	channels = 1;
	rate = 8000;
	_tmp0_ = fso_audio_pcm_device_new ();
	_fso_audio_pcm_device_unref0 (self->priv->pcmout);
	self->priv->pcmout = _tmp0_;
	_tmp1_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp2_ = fso_framework_logger_debug (_tmp1_, "Setup alsa sink for modem audio");
	g_assert (_tmp2_);
	{
		FsoAudioPcmDevice* _tmp3_;
		FsoAudioPcmDevice* _tmp4_;
		snd_pcm_access_t _tmp5_;
		snd_pcm_format_t _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->pcmout;
		fso_audio_pcm_device_open (_tmp3_, "plug:dmix", SND_PCM_STREAM_PLAYBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp4_ = self->priv->pcmout;
		_tmp5_ = self->priv->access;
		_tmp6_ = self->priv->format;
		_tmp7_ = rate;
		_tmp8_ = channels;
		fso_audio_pcm_device_setFormat (_tmp4_, _tmp5_, _tmp6_, _tmp7_, (guint) _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Error: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		fso_framework_logger_error (_tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = g_thread_supported ();
	if (!_tmp15_) {
		FsoFrameworkLogger* _tmp16_;
		_tmp16_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp16_, "Cannot run without thread support!");
	} else {
		GThread* _tmp17_;
		_tmp17_ = self->priv->playbackThread;
		if (_tmp17_ == NULL) {
			{
				GThread* _tmp18_ = NULL;
				GThread* _tmp19_;
				_tmp18_ = g_thread_create (_cmt_handler_playbackThreadFunc_gthread_func, self, TRUE, &_inner_error_);
				_tmp19_ = _tmp18_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_THREAD_ERROR) {
						goto __catch6_g_thread_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->playbackThread = _tmp19_;
			}
			goto __finally6;
			__catch6_g_thread_error:
			{
				GError* e = NULL;
				FsoFrameworkLogger* _tmp20_;
				GError* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp20_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				_tmp23_ = string_to_string (_tmp22_);
				_tmp24_ = g_strconcat ("Error: ", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				fso_framework_logger_debug (_tmp20_, _tmp25_);
				_g_free0 (_tmp25_);
				_g_error_free0 (e);
				return;
			}
			__finally6:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			FsoFrameworkLogger* _tmp26_;
			_tmp26_ = ((FsoFrameworkAbstractObject*) self)->logger;
			fso_framework_logger_debug (_tmp26_, "Thread already launched");
		}
		g_atomic_int_set ((volatile gint *) (&self->priv->runPlaybackThread), 1);
	}
}


static gpointer _cmt_handler_recordThreadFunc_gthread_func (gpointer self) {
	gpointer result;
	result = cmt_handler_recordThreadFunc (self);
	return result;
}


static void cmt_handler_alsaSrcSetup (CmtHandler* self) {
	gint channels;
	gint rate;
	FsoAudioPcmDevice* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	channels = 1;
	rate = 8000;
	_tmp0_ = fso_audio_pcm_device_new ();
	_fso_audio_pcm_device_unref0 (self->priv->pcmin);
	self->priv->pcmin = _tmp0_;
	_tmp1_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp2_ = fso_framework_logger_debug (_tmp1_, "Setup alsa source for modem audio");
	g_assert (_tmp2_);
	{
		FsoAudioPcmDevice* _tmp3_;
		FsoAudioPcmDevice* _tmp4_;
		snd_pcm_access_t _tmp5_;
		snd_pcm_format_t _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->pcmin;
		fso_audio_pcm_device_open (_tmp3_, "plug:dsnoop", SND_PCM_STREAM_CAPTURE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp4_ = self->priv->pcmin;
		_tmp5_ = self->priv->access;
		_tmp6_ = self->priv->format;
		_tmp7_ = rate;
		_tmp8_ = channels;
		fso_audio_pcm_device_setFormat (_tmp4_, _tmp5_, _tmp6_, _tmp7_, (guint) _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Error: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		fso_framework_logger_error (_tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = g_thread_supported ();
	if (!_tmp15_) {
		FsoFrameworkLogger* _tmp16_;
		_tmp16_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp16_, "Cannot run without thread support!");
	} else {
		GThread* _tmp17_;
		_tmp17_ = self->priv->recordThread;
		if (_tmp17_ == NULL) {
			{
				GThread* _tmp18_ = NULL;
				GThread* _tmp19_;
				_tmp18_ = g_thread_create (_cmt_handler_recordThreadFunc_gthread_func, self, TRUE, &_inner_error_);
				_tmp19_ = _tmp18_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_THREAD_ERROR) {
						goto __catch8_g_thread_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->recordThread = _tmp19_;
			}
			goto __finally8;
			__catch8_g_thread_error:
			{
				GError* e = NULL;
				FsoFrameworkLogger* _tmp20_;
				GError* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp20_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				_tmp23_ = string_to_string (_tmp22_);
				_tmp24_ = g_strconcat ("Error: ", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				fso_framework_logger_debug (_tmp20_, _tmp25_);
				_g_free0 (_tmp25_);
				_g_error_free0 (e);
				return;
			}
			__finally8:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			FsoFrameworkLogger* _tmp26_;
			_tmp26_ = ((FsoFrameworkAbstractObject*) self)->logger;
			fso_framework_logger_debug (_tmp26_, "Thread already launched");
		}
		self->priv->runRecordThread = TRUE;
	}
}


static void cmt_handler_alsaSinkCleanup (CmtHandler* self) {
	GThread* _tmp0_;
	FsoAudioPcmDevice* _tmp1_;
	RingBuffer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_atomic_int_set ((volatile gint *) (&self->priv->runPlaybackThread), 0);
	_tmp0_ = self->priv->playbackThread;
	g_thread_join (_tmp0_);
	self->priv->playbackThread = NULL;
	_tmp1_ = self->priv->pcmout;
	fso_audio_pcm_device_close (_tmp1_);
	_fso_audio_pcm_device_unref0 (self->priv->pcmout);
	self->priv->pcmout = NULL;
	_tmp2_ = self->priv->fromModem;
	ring_buffer_reset (_tmp2_);
}


static void cmt_handler_alsaSrcCleanup (CmtHandler* self) {
	GThread* _tmp0_;
	FsoAudioPcmDevice* _tmp1_;
	RingBuffer* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->runRecordThread = FALSE;
	_tmp0_ = self->priv->recordThread;
	g_thread_join (_tmp0_);
	self->priv->recordThread = NULL;
	_tmp1_ = self->priv->pcmin;
	fso_audio_pcm_device_close (_tmp1_);
	_fso_audio_pcm_device_unref0 (self->priv->pcmin);
	self->priv->pcmin = NULL;
	_tmp2_ = self->priv->toModem;
	ring_buffer_reset (_tmp2_);
}


static void cmt_handler_handleTimingUpdate (CmtHandler* self, struct cmtspeech_event_s* event) {
	CmtSpeechEventData* msg;
	FsoFrameworkLogger* _tmp0_;
	CmtSpeechTimingConfigNtf _tmp1_;
	guint16 _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	CmtSpeechTimingConfigNtf _tmp5_;
	guint16 _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	CmtSpeechTimingConfigNtf _tmp12_;
	guint16 _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	msg = (CmtSpeechEventData*) (&(*event).msg);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = (*msg).timing_config_ntf;
	_tmp2_ = _tmp1_.msec;
	_tmp3_ = g_strdup_printf ("%hu", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (*msg).timing_config_ntf;
	_tmp6_ = _tmp5_.usec;
	_tmp7_ = g_strdup_printf ("%hu", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("modem UL timing update: msec = ", _tmp4_, " usec = ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = fso_framework_logger_debug (_tmp0_, _tmp10_);
	g_assert (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	_tmp12_ = (*msg).timing_config_ntf;
	_tmp13_ = _tmp12_.msec;
	self->priv->timing = (gint) _tmp13_;
}


static const char* _cmtspeech_state_to_string (gint value) {
	switch (value) {
		case CMTSPEECH_STATE_INVALID:
		return "CMTSPEECH_STATE_INVALID";
		case CMTSPEECH_STATE_DISCONNECTED:
		return "CMTSPEECH_STATE_DISCONNECTED";
		case CMTSPEECH_STATE_CONNECTED:
		return "CMTSPEECH_STATE_CONNECTED";
		case CMTSPEECH_STATE_ACTIVE_DL:
		return "CMTSPEECH_STATE_ACTIVE_DL";
		case CMTSPEECH_STATE_ACTIVE_DLUL:
		return "CMTSPEECH_STATE_ACTIVE_DLUL";
		case CMTSPEECH_STATE_TEST_RAMP_PING_ACTIVE:
		return "CMTSPEECH_STATE_TEST_RAMP_PING_ACTIVE";
	}
	return NULL;
}


static void cmt_handler_handleDataEvent (CmtHandler* self) {
	FsoFrameworkLogger* _tmp0_;
	cmtspeech_t* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	struct cmtspeech_buffer_s* dlbuf;
	cmtspeech_t* _tmp7_;
	struct cmtspeech_buffer_s* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint ok;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = self->priv->connection;
	_tmp2_ = cmtspeech_protocol_state (_tmp1_);
	_tmp3_ = _cmtspeech_state_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("handleDataEvent during protocol state ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = fso_framework_logger_debug (_tmp0_, _tmp5_);
	g_assert (_tmp6_);
	_g_free0 (_tmp5_);
	dlbuf = NULL;
	_tmp7_ = self->priv->connection;
	_tmp9_ = cmtspeech_dl_buffer_acquire (_tmp7_, &_tmp8_);
	_0 (dlbuf);
	dlbuf = _tmp8_;
	ok = _tmp9_;
	_tmp10_ = ok;
	if (_tmp10_ == 0) {
		FsoFrameworkLogger* _tmp11_;
		struct cmtspeech_buffer_s* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		struct cmtspeech_buffer_s* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		cmtspeech_t* _tmp37_;
		struct cmtspeech_buffer_s* _tmp38_;
		_tmp11_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp12_ = dlbuf;
		_tmp13_ = _tmp12_->count;
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = dlbuf;
		_tmp17_ = _tmp16_->pcount;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("received DL packet w/ ", _tmp15_, " bytes (payload is ", _tmp19_, ")", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = fso_framework_logger_debug (_tmp11_, _tmp21_);
		g_assert (_tmp22_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp15_);
		{
			GMutex* _tmp23_;
			RingBuffer* _tmp24_;
			struct cmtspeech_buffer_s* _tmp25_;
			guint8* _tmp26_;
			struct cmtspeech_buffer_s* _tmp27_;
			gint _tmp28_;
			GMutex* _tmp29_;
			_tmp23_ = self->priv->playbackMutex;
			g_mutex_lock (_tmp23_);
			_tmp24_ = self->priv->fromModem;
			_tmp25_ = dlbuf;
			_tmp26_ = _tmp25_->payload;
			_tmp27_ = dlbuf;
			_tmp28_ = _tmp27_->pcount;
			ring_buffer_write (_tmp24_, (guint8*) _tmp26_, -1, _tmp28_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RING_ERROR) {
					goto __catch9_ring_error;
				}
				_0 (dlbuf);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp29_ = self->priv->playbackMutex;
			g_mutex_unlock (_tmp29_);
		}
		goto __finally9;
		__catch9_ring_error:
		{
			GError* e = NULL;
			GMutex* _tmp30_;
			FsoFrameworkLogger* _tmp31_;
			GError* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp30_ = self->priv->playbackMutex;
			g_mutex_unlock (_tmp30_);
			_tmp31_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			_tmp34_ = string_to_string (_tmp33_);
			_tmp35_ = g_strconcat ("RingBuffer error: ", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			fso_framework_logger_warning (_tmp31_, _tmp36_);
			_g_free0 (_tmp36_);
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_0 (dlbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp37_ = self->priv->connection;
		_tmp38_ = dlbuf;
		cmtspeech_dl_buffer_release (_tmp37_, _tmp38_);
	}
	_0 (dlbuf);
}


static const char* _cmtspeech_transition_to_string (gint value) {
	switch (value) {
		case CMTSPEECH_TR_INVALID:
		return "CMTSPEECH_TR_INVALID";
		case CMTSPEECH_TR_0_NO_CHANGE:
		return "CMTSPEECH_TR_0_NO_CHANGE";
		case CMTSPEECH_TR_1_CONNECTED:
		return "CMTSPEECH_TR_1_CONNECTED";
		case CMTSPEECH_TR_2_DISCONNECTED:
		return "CMTSPEECH_TR_2_DISCONNECTED";
		case CMTSPEECH_TR_3_DL_START:
		return "CMTSPEECH_TR_3_DL_START";
		case CMTSPEECH_TR_4_DLUL_STOP:
		return "CMTSPEECH_TR_4_DLUL_STOP";
		case CMTSPEECH_TR_5_PARAM_UPDATE:
		return "CMTSPEECH_TR_5_PARAM_UPDATE";
		case CMTSPEECH_TR_6_TIMING_UPDATE:
		return "CMTSPEECH_TR_6_TIMING_UPDATE";
		case CMTSPEECH_TR_7_TIMING_UPDATE:
		return "CMTSPEECH_TR_7_TIMING_UPDATE";
		case CMTSPEECH_TR_10_RESET:
		return "CMTSPEECH_TR_10_RESET";
		case CMTSPEECH_TR_11_UL_STOP:
		return "CMTSPEECH_TR_11_UL_STOP";
		case CMTSPEECH_TR_12_UL_START:
		return "CMTSPEECH_TR_12_UL_START";
	}
	return NULL;
}


static void cmt_handler_handleControlEvent (CmtHandler* self) {
	FsoFrameworkLogger* _tmp0_;
	cmtspeech_t* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	struct cmtspeech_event_s event = {0};
	gint transition;
	cmtspeech_t* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	struct cmtspeech_event_s _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	cmtspeech_t* _tmp16_;
	struct cmtspeech_event_s _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp1_ = self->priv->connection;
	_tmp2_ = cmtspeech_protocol_state (_tmp1_);
	_tmp3_ = _cmtspeech_state_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("handleControlEvent during protocol state ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = fso_framework_logger_debug (_tmp0_, _tmp5_);
	g_assert (_tmp6_);
	_g_free0 (_tmp5_);
	memset (&event, 0, sizeof (struct cmtspeech_event_s));
	transition = 0;
	_tmp7_ = self->priv->connection;
	cmtspeech_read_event (_tmp7_, &event);
	_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp9_ = event;
	_tmp10_ = _tmp9_.msg_type;
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("read event, type is ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = fso_framework_logger_debug (_tmp8_, _tmp14_);
	g_assert (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp16_ = self->priv->connection;
	_tmp17_ = event;
	_tmp18_ = cmtspeech_event_to_state_transition (_tmp16_, &_tmp17_);
	transition = _tmp18_;
	_tmp19_ = transition;
	switch (_tmp19_) {
		case CMTSPEECH_TR_INVALID:
		{
			FsoFrameworkLogger* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp21_ = fso_framework_logger_debug (_tmp20_, "ERROR: invalid state transition");
			g_assert (_tmp21_);
			break;
		}
		case CMTSPEECH_TR_6_TIMING_UPDATE:
		case CMTSPEECH_TR_7_TIMING_UPDATE:
		{
			struct cmtspeech_event_s _tmp22_;
			_tmp22_ = event;
			cmt_handler_handleTimingUpdate (self, &_tmp22_);
			break;
		}
		case CMTSPEECH_TR_3_DL_START:
		{
			cmt_handler_alsaSinkSetup (self);
			break;
		}
		case CMTSPEECH_TR_12_UL_START:
		{
			cmt_handler_alsaSrcSetup (self);
			break;
		}
		case CMTSPEECH_TR_4_DLUL_STOP:
		{
			cmt_handler_alsaSinkCleanup (self);
			cmt_handler_alsaSrcCleanup (self);
			break;
		}
		case CMTSPEECH_TR_1_CONNECTED:
		case CMTSPEECH_TR_2_DISCONNECTED:
		case CMTSPEECH_TR_5_PARAM_UPDATE:
		case CMTSPEECH_TR_10_RESET:
		case CMTSPEECH_TR_11_UL_STOP:
		{
			FsoFrameworkLogger* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp24_ = transition;
			_tmp25_ = _cmtspeech_transition_to_string (_tmp24_);
			_tmp26_ = g_strconcat ("State transition ok, new state is ", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = fso_framework_logger_debug (_tmp23_, _tmp27_);
			g_assert (_tmp28_);
			_g_free0 (_tmp27_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
			break;
		}
	}
	 (&event);
}


static gboolean cmt_handler_onInputFromChannel (CmtHandler* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GIOCondition _tmp1_;
	gboolean _tmp3_;
	GIOCondition _tmp4_;
	gint flags;
	cmtspeech_t* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint ok;
	gint _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp1_ = condition;
	if (_tmp1_ == G_IO_HUP) {
		_tmp0_ = TRUE;
	} else {
		GIOCondition _tmp2_;
		_tmp2_ = condition;
		_tmp0_ = _tmp2_ == G_IO_IN;
	}
	_tmp3_ = _tmp0_;
	g_assert (_tmp3_);
	_tmp4_ = condition;
	if (_tmp4_ == G_IO_HUP) {
		FsoFrameworkLogger* _tmp5_;
		_tmp5_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp5_, "HUP! Will no longer handle input from cmtspeechdata");
		result = FALSE;
		return result;
	}
	flags = 0;
	_tmp6_ = self->priv->connection;
	_tmp8_ = cmtspeech_check_pending (_tmp6_, &_tmp7_);
	flags = _tmp7_;
	ok = _tmp8_;
	_tmp9_ = ok;
	if (_tmp9_ < 0) {
		FsoFrameworkLogger* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp11_ = fso_framework_logger_debug (_tmp10_, "Error while checking for pending events...");
		g_assert (_tmp11_);
	} else {
		gint _tmp12_;
		_tmp12_ = ok;
		if (_tmp12_ == 0) {
			FsoFrameworkLogger* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp14_ = fso_framework_logger_debug (_tmp13_, "D'oh, cmt speech readable, but no events pending...");
			g_assert (_tmp14_);
		} else {
			FsoFrameworkLogger* _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			gint _tmp20_;
			_tmp15_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp16_ = flags;
			_tmp17_ = g_strdup_printf ("Connection reports pending events with flags 0x%0X", (guint) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = fso_framework_logger_debug (_tmp15_, _tmp18_);
			g_assert (_tmp19_);
			_g_free0 (_tmp18_);
			_tmp20_ = flags;
			if ((_tmp20_ & CMTSPEECH_EVENT_DL_DATA) == CMTSPEECH_EVENT_DL_DATA) {
				cmt_handler_handleDataEvent (self);
			} else {
				gint _tmp21_;
				_tmp21_ = flags;
				if ((_tmp21_ & CMTSPEECH_EVENT_CONTROL) == CMTSPEECH_EVENT_CONTROL) {
					cmt_handler_handleControlEvent (self);
				} else {
					FsoFrameworkLogger* _tmp22_;
					gboolean _tmp23_ = FALSE;
					_tmp22_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp23_ = fso_framework_logger_debug (_tmp22_, "Event no DL_DATA nor CONTROL, ignoring");
					g_assert (_tmp23_);
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar* cmt_handler_real_repr (FsoFrameworkAbstractObject* base) {
	CmtHandler * self;
	gchar* result = NULL;
	gint _tmp0_ = 0;
	cmtspeech_t* _tmp1_;
	gint _tmp4_;
	gint state;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (CmtHandler*) base;
	_tmp1_ = self->priv->connection;
	if (_tmp1_ != NULL) {
		cmtspeech_t* _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->connection;
		_tmp3_ = cmtspeech_protocol_state (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = 0;
	}
	_tmp4_ = _tmp0_;
	state = _tmp4_;
	_tmp5_ = _cmtspeech_state_to_string (state);
	_tmp6_ = g_strconcat ("<", _tmp5_, ">", NULL);
	result = _tmp6_;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void cmt_handler_setAudioStatus (CmtHandler* self, gboolean enabled) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	FsoFrameworkLogger* _tmp9_;
	gboolean _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	cmtspeech_t* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = enabled;
	_tmp1_ = self->priv->status;
	if (_tmp0_ == _tmp1_) {
		FsoFrameworkLogger* _tmp2_;
		gboolean _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp2_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp3_ = self->priv->status;
		_tmp4_ = bool_to_string (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("Status already ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = fso_framework_logger_debug (_tmp2_, _tmp7_);
		g_assert (_tmp8_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		return;
	}
	_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp10_ = enabled;
	_tmp11_ = bool_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("Setting call status to ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = fso_framework_logger_debug (_tmp9_, _tmp14_);
	g_assert (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp16_ = self->priv->connection;
	_tmp17_ = enabled;
	cmtspeech_state_change_call_status (_tmp16_, _tmp17_);
	_tmp18_ = enabled;
	self->priv->status = _tmp18_;
}


static void cmt_handler_class_init (CmtHandlerClass * klass) {
	cmt_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CmtHandlerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = cmt_handler_real_repr;
	G_OBJECT_CLASS (klass)->finalize = cmt_handler_finalize;
}


static void cmt_handler_instance_init (CmtHandler * self) {
	GMutex* _tmp0_;
	GMutex* _tmp1_;
	self->priv = CMT_HANDLER_GET_PRIVATE (self);
	self->priv->pcmout = NULL;
	self->priv->pcmin = NULL;
	self->priv->format = SND_PCM_FORMAT_S16_LE;
	self->priv->access = SND_PCM_ACCESS_RW_INTERLEAVED;
	self->priv->silence_buffer = NULL;
	self->priv->playbackThread = NULL;
	self->priv->runPlaybackThread = 0;
	_tmp0_ = g_mutex_new ();
	self->priv->playbackMutex = _tmp0_;
	self->priv->recordThread = NULL;
	self->priv->runRecordThread = FALSE;
	_tmp1_ = g_mutex_new ();
	self->priv->recordMutex = _tmp1_;
}


static void cmt_handler_finalize (GObject* obj) {
	CmtHandler * self;
	self = CMT_HANDLER (obj);
	_cmtspeech_close0 (self->priv->connection);
	_g_io_channel_unref0 (self->priv->channel);
	_fso_audio_pcm_device_unref0 (self->priv->pcmout);
	_fso_audio_pcm_device_unref0 (self->priv->pcmin);
	self->priv->silence_buffer = (g_free (self->priv->silence_buffer), NULL);
	_g_mutex_free0 (self->priv->playbackMutex);
	_g_object_unref0 (self->priv->fromModem);
	_g_mutex_free0 (self->priv->recordMutex);
	_g_object_unref0 (self->priv->toModem);
	G_OBJECT_CLASS (cmt_handler_parent_class)->finalize (obj);
}


/**
 * @class CmtHandler
 *
 * Handles Audio via libcmtspeechdata
 **/
GType cmt_handler_get_type (void) {
	return cmt_handler_type_id;
}


GType cmt_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CmtHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cmt_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CmtHandler), 0, (GInstanceInitFunc) cmt_handler_instance_init, NULL };
	cmt_handler_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "CmtHandler", &g_define_type_info, 0);
	return cmt_handler_type_id;
}



