#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ʣΥեϢ뤹뤿Υ饹
#
package FreePWING::Link;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Reference;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length
	    $block_reference
	    $position_reference
	    $tag_reference);

@ISA = qw(Exporter);
@EXPORT = qw($block_length
	     $block_reference
	     $position_reference
	     $tag_reference
	     new
  	     open
	     close
	     bcd
	     close_internal
	     add_file
	     file_name
	     output_file_name
	     error_message);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# Ⱦμ
#
$block_reference = 0;
$position_reference = 1;
$tag_reference = 2;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ϥեΥϥɥ
	'output_handle' => FileHandle->new(),

	# ϥե̾
	'output_file_name' => '',

	# Ϣ뤹ƥեΥեå
	'offset_table' => {},

	# ϥե 3 
	# (ϥե롢Ⱦե롢ե)
	'input_file_trios' => [],

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(output_file_name)
#           output_file_name
#		ϥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹Ѥˡե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($output_file_name) = @ARG;

    #
    # ե򳫤
    #
    $self->{'output_file_name'} = $output_file_name;
    if (!$self->{'output_handle'}->open($self->{'output_file_name'}, 'w+')) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: " . $self->{'output_file_name'};
	$self->close_internal();
	return 0;
    }
    binmode($self->{'output_handle'});

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦ󡢥˽äƷե񤭴Ƥ顢ե
#	Ĥ롣ե򳫤ƤʤС⤷ʤ
# :
#	 1 ֤Ԥ 0 ֤
#
sub close {
    my $self = shift;

    #
    # ե򳫤ƤʤС᥽åɤȴ롣
    #
    if (!$self->{'output_handle'}->fileno()) {
	return 1;
    }

    #
    # եθߤΥ롣
    #
    my $output_file_length = $self->{'output_handle'}->tell();

    #
    # input_file_trios Ͽ줿ġΥե롣
    #
    my $tag_table = {};
    my $file_trio;
    foreach $file_trio (@{$self->{'input_file_trios'}}) {
	my ($file_name, $reference_file_name, $tag_file_name) = @{$file_trio};

	if (!defined($tag_file_name) || $tag_file_name eq '') {
	    next;
	}

	#
	# ե򳫤
	#
	my $handle = FileHandle->new();
	if (!$handle->open($tag_file_name, 'r')) {
	    $self->{'error_message'} = 
		"failed to open the file, $ERRNO: $tag_file_name";
	    $self->close_internal();
	    return 0;
	}

	#
	# ȾγƹԤɤࡣ
	#
	my $line;
	my @line_fields;
	for (;;) {
	    $line = $handle->getline();
	    if (!defined($line)) {
		last;
	    }
	    chomp $line;
	    @line_fields = split(/\t/, $line);
	    if (defined($tag_table->{$line_fields[0]})) {
		$self->{'error_message'} = 
		    "redefined tag, $line_fields[0]: line $NR, $tag_file_name";
		$self->close_internal();
		return 0;
	    }
	    $tag_table->{$line_fields[0]} = [hex($line_fields[1]), $file_name];
	}

	#
	# եĤ롣
	#
	$handle->close();
    }

    #
    # input_file_trios Ͽ줿Ⱦե˽롣
    #
    my $file_trio;
    foreach $file_trio (@{$self->{'input_file_trios'}}) {
	my ($file_name, $reference_file_name, $tag_file_name) = @{$file_trio};

	if (!defined($reference_file_name) || $reference_file_name eq '') {
	    next;
	}

	#
	# Ⱦե򳫤
	#
	my $handle = FileHandle->new();
	if (!$handle->open($reference_file_name, 'r')) {
	    $self->{'error_message'} = 
		"failed to open the file, $ERRNO: $reference_file_name";
	    $self->close_internal();
	    return 0;
	}

	#
	# ȾγƹԤɤࡣ
	#
	my $line;
	my @line_fields;
	my $buffer = '';
	my $max_buffer_size = $block_length * 32;
	my $buffer_position = 0;
	my $position_size;
	for (;;) {
	    $line = $handle->getline();
	    if (!defined($line)) {
		last;
	    }
	    chomp $line;
	    @line_fields = split(/\t/, $line);
	    
	    #
	    # ԤƤǧ
	    #
	    my ($reference_type, $source_position, $target_position, 
		$target_file_name);
	    if ($line_fields[0] eq 'block') {
		$reference_type = $block_reference;
		$source_position = hex($line_fields[1]);
		$target_position = hex($line_fields[2]);
		$target_file_name = $line_fields[3];
	    } elsif ($line_fields[0] eq 'position') {
		$reference_type = $position_reference;
		$source_position = hex($line_fields[1]);
		$target_position = hex($line_fields[2]);
		$target_file_name = $line_fields[3];
	    } elsif ($line_fields[0] eq 'tag') {
		if (!defined($tag_table->{$line_fields[2]})) {
		    $self->{'error_message'} = "unknown tag name, $line_fields[2]: line $NR, $reference_file_name";
		    $self->close_internal();
		    return 0;
		}
		$reference_type = $tag_reference;
		$source_position = hex($line_fields[1]);
		$target_position = $tag_table->{$line_fields[2]}->[0];
		$target_file_name = $tag_table->{$line_fields[2]}->[1];
	    } else {
		$self->{'error_message'} = 
		    "invalid line: line $NR, $reference_file_name";
		$self->close_internal();
		return 0;
	    }

	    $position_size
		= ($reference_type == $block_reference) ? 4 : 6;

	    #
	    # ȸȻΰ֤򻻽Ф롣
	    #
	    if (!defined($self->{'offset_table'}->{$target_file_name})) {
		$self->{'error_message'} = 
		    "unknown target file name, $target_file_name: line $NR, $reference_file_name";
		next;
	    }
	    $source_position += $self->{'offset_table'}->{$file_name};
	    $target_position += $self->{'offset_table'}->{$target_file_name};

	    #
	    # եλȰ֤񤭴
	    #
	    if (($buffer_position + length($buffer) < $source_position)
		|| ($buffer_position > $source_position)) {
	        # 
	        # 񤭹֤߰Ϣ³ʤϥХåեݤФ
	        #
 		if (length($buffer)) {
 		    if (!$self->{'output_handle'}
 			->seek($buffer_position, FileHandle->SEEK_SET)
 			|| !$self->{'output_handle'}->print($buffer)) {
 			$self->{'error_message'} = 
 			    "failed to seek or write the file, $ERRNO: "
		    . $self->{'output_file_name'};
		$handle->close();
		$self->close_internal();
		return 0;
	    }
 		    # $buffer_position += length($buffer);
 		    $buffer = '';
 		}
 		$buffer_position = $source_position;
	    }
	    
	    if ($buffer_position + length($buffer)
		   < $source_position + $position_size) {
		#
		# Хåեؤɤ߹ߡ
		#
		my $tmp_buffer;

		if (!$self->{'output_handle'}
		    ->seek($buffer_position + length($buffer),
			   FileHandle->SEEK_SET)
		    || !$self->{'output_handle'}
		    ->read($tmp_buffer, $block_length)) {
		    $self->{'error_message'}
		    = "failed to seek or read the file, $ERRNO: "
			    . $self->{'output_file_name'};
		    $handle->close();
		    $self->close_internal();
		    return 0;
		}
		$buffer .= $tmp_buffer;
	    }

	    #
	    # ǰΰ٥顼å
	    #
	    if ($buffer_position + length($buffer)
		< $source_position + $position_size) {
		$self->{'error_message'}
		= "unexpected position.: $reference_file_name";
		    $handle->close();
		    $self->close_internal();
		    return 0;
		}

	    if ($reference_type == $block_reference) {
		substr($buffer, $source_position - $buffer_position, 4)
		    = pack('N', $target_position / $block_length + 1);
	    } elsif ($reference_type == $position_reference) {
		substr($buffer, $source_position - $buffer_position, 6)
		    = pack('Nn', $target_position / $block_length + 1,
			   $target_position % $block_length);
	    } else {
		my $target_block = bcd($target_position / $block_length + 1);
		my $target_offset = bcd($target_position % $block_length);
		substr($buffer, $source_position - $buffer_position, 6)
		    = pack('Nn', $target_block, $target_offset);
	    }

 	    if ($source_position + $position_size - $buffer_position
 		> $max_buffer_size) {
 		#
 		# 礭ʤäХåեݤФ
 		#
		if (!$self->{'output_handle'}
 		    ->seek($buffer_position, FileHandle->SEEK_SET)
 		    || !$self->{'output_handle'}
 		    ->print(substr($buffer, 0, $max_buffer_size))) {
		    $self->{'error_message'} = 
 			"failed to seek or write the file, $ERRNO: "
			    . $self->{'output_file_name'};
		    $handle->close();
		    $self->close_internal();
		    return 0;
		}
 		$buffer_position += $max_buffer_size;
 		substr($buffer, 0, $max_buffer_size) = '';
 	    }
	}

 	if (length($buffer)) {
 	    #
 	    # λȤƥХåեݤФ
 	    # 
 	    if (!$self->{'output_handle'}
 		->seek($buffer_position, FileHandle->SEEK_SET)
 		|| !$self->{'output_handle'}
 		->print($buffer)) {
 		$self->{'error_message'} = 
 		    "failed to seek or write the file, $ERRNO: "
 		    . $self->{'output_file_name'};
 		$handle->close();
 		$self->close_internal();
 		return 0;
	    }
	}

	#
	# ȾեĤ롣
	#
	$handle->close();
    }

    #
    # եĤ롣
    #
    $self->close_internal();

    return 1;
}

#
# $position  bcd ͤ׻롣
#
sub bcd {
    my ($position) = shift;

    my $bcd = 0;
    $bcd += (($position)             % 10);
    $bcd += (($position / 10)        % 10) << 4;
    $bcd += (($position / 100)       % 10) << 8;
    $bcd += (($position / 1000)      % 10) << 12;
    $bcd += (($position / 10000)     % 10) << 16;
    $bcd += (($position / 100000)    % 10) << 20;
    $bcd += (($position / 1000000)   % 10) << 24;
    $bcd += (($position / 10000000)  % 10) << 28;
    $bcd += (($position / 100000000) % 10) << 32;

    return $bcd;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#       close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'output_handle'}->fileno()) {
	$self->{'output_handle'}->close();
    }
}

#
# :
#	add_file(file_name, [[reference_file_name, tag_file_name]])
#           file_name
#		󥯤ե̾
#           reference_file_name
#		󥯤եб뻲Ⱦե̾
#           reference_file_name
#		󥯤եб륿ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ե˥եķҤ롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_file {
    my $self = shift;
    my ($file_name, $reference_file_name, $tag_file_name) = @ARG;

    #
    # $file_name, $reference_file_name  input_file_trios Ͽ
    #
    $self->{'offset_table'}->{$file_name} = $self->{'output_handle'}->tell();
    push(@{$self->{'input_file_trios'}},
	 [$file_name, $reference_file_name, $tag_file_name]);

    #
    # $file_name 򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: $file_name";
	$self->close_internal();
	return 0;
    }
    binmode($handle);

    #
    # $file_name  $self->{'output_file_name'} ɲá
    #
    my ($buffer, $input_bytes);
    for (;;) {
	$input_bytes = $handle->read($buffer, $block_length);
	if (!defined($input_bytes)) {
	    $self->{'error_message'} =
		"failed to read the file, $ERRNO: $file_name";
	    $handle->close();
	    $self->close_internal();
	    return 0;
	}
	if ($input_bytes == 0) {
	    last;
	}
	if (!$self->{'output_handle'}->print($buffer)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: " 
		    . $self->{'output_file_name'};
	    $handle->close();
	    $self->close_internal();
	    return 0;
	}
    }

    #
    # $file_name Ĥ롣
    #
    $handle->close();

    #
    # $self->{'output_file_name'} ΡȾüʥ֥åθ "\0" 
    # 롣
    #
    my $pad_length = $block_length
	- $self->{'output_handle'}->tell() % $block_length;
    if ($pad_length < $block_length
	&& !$self->{'output_handle'}->print("\0" x $pad_length)) {
	$self->{'error_message'} = "failed to write the file, $ERRNO: "
	    . $self->{'output_file_name'};
	$self->close_internal();
	return 0;
    }

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'output_file_name'};
}

sub output_file_name {
    my $self = shift;
    return $self->{'output_file_name'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;

