/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.quantization.dequantizer;

import ucar.jpeg.jj2000.j2k.decoder.DecoderSpecs;
import ucar.jpeg.jj2000.j2k.image.DataBlk;
import ucar.jpeg.jj2000.j2k.image.DataBlkFloat;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.quantization.GuardBitsSpec;
import ucar.jpeg.jj2000.j2k.quantization.QuantStepSizeSpec;
import ucar.jpeg.jj2000.j2k.quantization.QuantTypeSpec;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.Dequantizer;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import ucar.jpeg.jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class StdDequantizer
extends Dequantizer {
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private StdDequantizerParams params;
    private DataBlkInt inblk;
    private int outdtype;

    public StdDequantizer(CBlkQuantDataSrcDec src, int[] utrb, DecoderSpecs decSpec) {
        super(src, utrb, decSpec);
        if (utrb.length != src.getNumComps()) {
            throw new IllegalArgumentException("Invalid rb argument");
        }
        this.qsss = decSpec.qsss;
        this.qts = decSpec.qts;
        this.gbs = decSpec.gbs;
    }

    public int getFixedPoint(int c) {
        return 0;
    }

    public final DataBlk getCodeBlock(int c, int m, int n, SubbandSyn sb, DataBlk cblk) {
        return this.getInternCodeBlock(c, m, n, sb, cblk);
    }

    public final DataBlk getInternCodeBlock(int c, int m, int n, SubbandSyn sb, DataBlk cblk) {
        boolean reversible = this.qts.isReversible(this.tIdx, c);
        boolean derived = this.qts.isDerived(this.tIdx, c);
        StdDequantizerParams params = (StdDequantizerParams)this.qsss.getTileCompVal(this.tIdx, c);
        int G = (Integer)this.gbs.getTileCompVal(this.tIdx, c);
        this.outdtype = cblk.getDataType();
        if (reversible && this.outdtype != 3) {
            throw new IllegalArgumentException("Reversible quantizations must use int data");
        }
        int[] outiarr = null;
        float[] outfarr = null;
        int[] inarr = null;
        switch (this.outdtype) {
            case 3: {
                cblk = this.src.getCodeBlock(c, m, n, sb, cblk);
                outiarr = (int[])cblk.getData();
                break;
            }
            case 4: {
                this.inblk = (DataBlkInt)this.src.getInternCodeBlock(c, m, n, sb, this.inblk);
                inarr = this.inblk.getDataInt();
                if (cblk == null) {
                    cblk = new DataBlkFloat();
                }
                cblk.ulx = this.inblk.ulx;
                cblk.uly = this.inblk.uly;
                cblk.w = this.inblk.w;
                cblk.h = this.inblk.h;
                cblk.offset = 0;
                cblk.scanw = cblk.w;
                cblk.progressive = this.inblk.progressive;
                outfarr = (float[])cblk.getData();
                if (outfarr != null && outfarr.length >= cblk.w * cblk.h) break;
                outfarr = new float[cblk.w * cblk.h];
                cblk.setData(outfarr);
            }
        }
        int magBits = sb.magbits;
        if (reversible) {
            int shiftBits = 31 - magBits;
            for (int j = outiarr.length - 1; j >= 0; --j) {
                int temp = outiarr[j];
                outiarr[j] = temp >= 0 ? temp >> shiftBits : -((temp & Integer.MAX_VALUE) >> shiftBits);
            }
        } else {
            float step;
            if (derived) {
                int mrl = this.src.getSynSubbandTree((int)this.getTileIdx(), (int)c).resLvl;
                step = params.nStep[0][0] * (float)(1L << this.rb[c] + sb.anGainExp + mrl - sb.level);
            } else {
                step = params.nStep[sb.resLvl][sb.sbandIdx] * (float)(1L << this.rb[c] + sb.anGainExp);
            }
            int shiftBits = 31 - magBits;
            step /= (float)(1 << shiftBits);
            switch (this.outdtype) {
                case 3: {
                    for (int j = outiarr.length - 1; j >= 0; --j) {
                        int temp = outiarr[j];
                        outiarr[j] = (int)((float)(temp >= 0 ? temp : -(temp & Integer.MAX_VALUE)) * step);
                    }
                    break;
                }
                case 4: {
                    int w = cblk.w;
                    int h = cblk.h;
                    int j = w * h - 1;
                    int k = this.inblk.offset + (h - 1) * this.inblk.scanw + w - 1;
                    int jmin = w * (h - 1);
                    while (j >= 0) {
                        while (j >= jmin) {
                            int temp = inarr[k];
                            outfarr[j] = (float)(temp >= 0 ? temp : -(temp & Integer.MAX_VALUE)) * step;
                            --k;
                            --j;
                        }
                        k -= this.inblk.scanw - w;
                        jmin -= w;
                    }
                    break;
                }
            }
        }
        return cblk;
    }
}

