/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import net.sf.ehcache.CacheException;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader getStandardClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getFallbackClassLoader() {
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static Object createNewInstance(String className) throws CacheException {
        Object newInstance;
        Class<?> clazz;
        try {
            clazz = Class.forName(className, true, ClassLoaderUtil.getStandardClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName(className, true, ClassLoaderUtil.getFallbackClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
            }
        }
        try {
            newInstance = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new CacheException("Unable to load class " + className + ". Initial cause was " + e.getMessage(), e);
        }
        return newInstance;
    }
}

