
//Values are sorted so that H is more important than S which is more important than V
var hsv = 
[
['Chestnut',0,55,80],
['Falu red',0,81,50],
['Firebrick',0,81,70],
['Maroon',0,100,50],
['Red',0,100,100],
['Red (RYB)',0,100,100],
['Coral red',3,82,100],
['Persian red',5,50,50],
['Medium carmine',5,69,68],
['Pale carmine',5,69,68],
['Cinnabar',5,77,89],
['Vermilion',5,77,89],
['Orange-Red',5,100,52],
['Caput Mortuum',7,64,35],
['Auburn',7,67,45],
['Scarlet',8,100,100],
['Burnt umber',9,74,54],
['Dark chestnut',10,37,60],
['Dark coral',10,66,80],
['Terra cotta',10,70,62],
['Persimmon',10,85,94],
['Salmon',14,59,100],
['Burnt sienna',14,65,91],
['Dark salmon',15,48,91],
['Coral',16,69,100],
['Tea rose (orange)',16,70,70],
['Rust',18,92,72],
['Zinnwaldite',19,25,92],
['International orange',19,100,100],
['Pink-orange',20,60,100],
['Bronze',21,155,128],
['Bistre',24,49,24],
['Pumpkin',24,90,100],
['Safety Orange (Blaze Orange)',24,100,100],
['Seashell',25,7,100],
['Russet',25,78,50],
['Cinnamon',25,86,82],
['Burnt orange',25,100,80],
['Tenne (Tawny)',25,100,80],
['Sandy brown',28,61,96],
['Copper',29,72,72],
['Linen',30,8,98],
['Taupe',30,17,34],
['Apricot',30,25,87],
['Peach-orange',30,40,100],
['Pale brown',30,45,60],
['Dark brown',30,67,40],
['Sepia',30,82,44],
['Ochre',30,83,80],
['Brown',30,100,59],
['Orange (color wheel)',30,100,100],
['Chocolate',31,100,48],
['Navajo white',32,27,100],
['Carrot orange',33,86,93],
['Tangerine yellow',33,100,50],
['Tangerine',33,100,95],
['Tan',34,33,82],
['Raw umber',34,84,45],
['School bus yellow',36,100,50],
['Papaya whip',37,16,100],
['Khaki',37,26,76],
['Brass',37,119,124],
['Dark tangerine',38,93,100],
['Gamboge',38,94,94],
['Orange Peel',38,100,100],
['Wheat',39,26,96],
['Ecru',39,27,77],
['Peach',39,29,100],
['Peach-yellow',39,31,98],
['Orange (web)',39,100,100],
['Platinum',40,1,90],
['Old Lace',40,6,100],
['Deep peach',40,34,100],
['Cosmic latte',40,94,90],
['Goldenrod',43,85,85],
['Dark goldenrod',43,94,72],
['Selective yellow',44,100,100],
['Dark tan',45,44,57],
['Saffron',45,80,96],
['Amber',45,100,100],
['Army green',46,106,54],
['Mustard',47,65,100],
['Buff',49,46,94],
['Old Gold',49,71,81],
['Satin sheen gold',49,74,76],
['Flax',50,45,93],
['Golden brown',51,37,47],
['Gold (metallic)',51,67,72],
['Gold (web) (Golden)',51,100,100],
['Golden yellow',52.5,100,100],
['Lemon chiffon',54,20,100],
['Khaki (X11) (Light khaki)',54,41,94],
['Corn',54,63,98],
['Lemon',55,94,99],
['Dark khaki',56,43,74],
['Cream',57,18,100],
['Olivine',58,80,141],
['Ivory',60,5,100],
['Beige',60,10,96],
['Yellow-green',60,60,54],
['Olive',60,100,50],
['Orange (RYB)',60,100,100],
['Yellow',60,100,100],
['Pear',65,78,88],
['Chartreuse (traditional)',67.5,100,100],
['Electric lime',75,100,63],
['Lime (color wheel)',75,100,100],
['Olive Drab',80,75,56],
['Green-yellow',84,100,67],
['Spring bud',88,90,63],
['Lawn green',90,98,48],
['Chartreuse (web color)',90,100,100],
['Camouflage green',91,20,53],
['Asparagus',92,43,63],
['Bright green',96,100,100],
['Tea Green',100,20,94],
['Harlequin',105,100,100],
['Fern green',106,45,47],
['Myrtle',115,54,26],
['Grey-asparagus',117,22,35],
['Moss green',120,22,87],
['Pastel green',120,46,87],
['Kelly green',120,48,48],
['Lime green',120,67,40],
['Forest green',120,76,55],
['Green (HTML/CSS green)',120,80,50],
['Office green',120,80,50],
['Islamic green',120,90,60],
['Shamrock green',120,90,75],
['Electric green (X11 green)',120,100,100],
['Green (color wheel) (X11 green)',120,100,100],
['Lime (X11 green)',120,100,100],
['Yellow (RYB)',120,100,100],
['Celadon',123,24,88],
['Persian green',135,75,60],
['Dark pastel green',138,98,75],
['Mint Green',140,40,100],
['Emerald',140,60,78],
['Malachite',140,95,85],
['Sea Green',146,67,55],
['Midnight Blue',148,100,20],
['Dark spring green',150,80,45],
['Spring green',150,100,100],
['Dark green',158,98,20],
['Jade',158,100,66],
['Aquamarine',160,50,100],
['Viridian',161,51,51],
['Turquoise',175,77,84],
['Pine Green',175,99,47],
['Bright turquoise',177,97,91],
['Baby blue',180,12,100],
['Pale blue',180,26,93],
['Electric blue',180,40,90],
['Dark slate gray',180,41,31],
['Blue-green',180,100,50],
['Teal',180,100,50],
['Robin egg blue',180,100,80],
['Aqua',180,100,100],
['Cyan',180,100,100],
['Green (RYB)',180,100,100],
['Dark turquoise',181,83,38],
['Bondi blue',191,100,71],
['Cerulean',196,100,65],
['Columbia blue',200,39,100],
['Smalt (Dark powder blue)',200,70,60],
['Prussian blue',205,100,33],
['Steel blue',207,61,71],
['Alice blue',208,6,100],
['Dark cerulean',209,94,49],
['Slate grey',210,22,56],
['Pale cornflower blue',210,28,94],
['Sky Blue',210,67,96],
['Dodger blue',210,88,100],
['Maya blue',210,96,87],
['Azure (color wheel)',210,100,50],
['Azure (web)',210,100,98],
['Carolina blue',210.9,30.80,86.70],
['Denim',213,89,74],
['Cobalt',215,100,67],
['Cornflower blue',219,58,93],
['Powder blue (web)',220,70,90],
['Sapphire',222,92,40],
['International Klein Blue',223,100,65],
['Cerulean blue',224,78,75],
['Royal blue',225,71,88],
['Razzmatazz',239,231,119],
['Periwinkle',240,20,100],
['Lavender blue',240,75,88],
['Light blue',240,90,80],
['Dark blue',240,100,25],
['Medium blue',240,100,40],
['Navy Blue',240,100,50],
['Blue',240,100,100],
['Blue (RYB)',240,100,100],
['Lavender grey',242,8,75],
['Egyptian blue',244,77,42],
['Ultramarine',244,93,56],
['Lavender (web)',245,40,96],
['Magnolia',247,94,92],
['Persian blue',248,75,50],
['Persian indigo',249,85,49],
['Dark violet',252,64,54],
['Han Purple',260,97,47],
['Electric indigo',264,100,50],
['Old Lavender',270,3,22],
['Amethyst',270,50,80],
['Lavender purple',270,60,65],
['Deep lilac',270,68,67],
['Medium purple',270,68,72],
['Lavender (floral)',270,76,76],
['Blue-violet',271,81,42],
['Royal purple',273,62,54],
['Violet',273,100,100],
['Indigo (dye)',275,40,40],
['Indigo (web)',275,100,27],
['Mauve',276,31,100],
['Tyrian purple',277,67,44],
['Wisteria',281,27,86],
['Purple Taupe',285,19,33],
['Mauve Taupe',285,37,54],
['Purple (X11)',285,97,77],
['Electric purple',285,100,80],
['Heliotrope',286,55,100],
['Psychedelic purple',290,100,92],
['Thistle',300,12,85],
['Lilac',300,19,78],
['Fuchsia Pink',300,47,84],
['Purple (HTML/CSS)',300,67,44],
['Deep fuchsia',300,67,72],
['Lavender magenta',300,67,88],
['Violet (web)',300,67,88],
['(Light) Plum',300,80,25],
['Deep magenta',300,80,37],
['Fuchsia',300,100,100],
['Magenta',300,100,100],
['Violet (RYB)',300,100,100],
['Orchid',302,49,85],
['Pale magenta',310,47,98],
['Hot Magenta',310,57,74],
['Lavender pink',310,57,90],
['Lavender rose',310,57,90],
['Shocking Pink',315,94,99],
['Deep cerise',317,57,62],
['Persian rose',318,96,88],
['Eggplant',320,100,60],
['Hollywood Cerise',320,100,96],
['Red-violet',322,89,78],
['Mountbatten pink',323,20,60],
['Rich magenta',327,96,34],
['Deep pink',328,100,49],
['Rose Taupe',330,42,46],
['Old Rose',330,59,57],
['Persian pink',330,72,77],
['Brilliant rose',330,75,84],
['French Rose',330,76,55],
['Carnation pink',330,100,80],
['Rose',330,100,100],
['Misty rose',337,37,94],
['Tea rose (rose)',337,47,93],
['Ruby',338,100,40],
['Lavender blush',340,6,100],
['Pale red-violet',340,49,86],
['Dark pink',342,64,91],
['Cerise',343,78,87],
['Copper rose',344,35,57],
['Puce',345,33,80],
['Burgundy',345,50,50],
['Amaranth',345,78,64],
['Pastel pink',346,18,100],
['Crimson',348,91,86],
['Pink',350,25,100],
['Hot Pink',350,84,75],
['Cardinal',350,85,77],
['Carmine',350,100,59],
['Pale pink',354,13,98],
['Alizarin',355,83,89],
['Rich carmine',356,94,44],
['Sangria',356,100,57],
['Pale chestnut',358,22,87]
];


function idSVOnlyColor(h,s,v){
  // This causes Platinum and Old Lavendar to be ignored.
  // Platinum 	40	1	90
  // Old Lavender 	270	3	22
  if (s > 5){
    return '';
  }	
  if (v < 25){
    return 'Black';
  }
  if (v < 70){
    return 'Grey';
  }
  if (v < 90){
    return 'Silver';
  }
  return 'White';
}


function identifyHSVColor(h,s,v){
  var colorName = idSVOnlyColor(h,s,v);
  if (colorName !== ''){
    return colorName;
  }
  var length = hsv.length;
  var hIndicesToCheck = new Array();
  var currentColor;
  var nextColor;
  var i;
  // Find the best H matches
  for (i=0; i < length; i++){
    hIndicesToCheck.push(i);
	currentColor = hsv[i];
    if (i+1 >= length){
	  break;
	}	
	nextColor = hsv[i+1];
	var currentHDelta = Math.abs(currentColor[1] - h);
	var nextHDelta = Math.abs(nextColor[1] - h);
    if (nextHDelta > currentHDelta){
      break;
	}
    if (nextHDelta < currentHDelta){
      hIndicesToCheck = new Array();
	}
  }

  // Now find the best S matches out of those  
  var length = hIndicesToCheck.length; 
  var sIndicesToCheck = new Array();
  for (i=0; currentColor = hsv[hIndicesToCheck[i]]; i++){
    sIndicesToCheck.push(hIndicesToCheck[i]);
	currentColor = hsv[hIndicesToCheck[i]];
    if (i+1 >= length){
	  break;
	}	
	nextColor = hsv[hIndicesToCheck[i+1]];
	var currentSDelta = Math.abs(currentColor[2] - s);
	var nextSDelta = Math.abs(nextColor[2] - s);
    if (nextSDelta > currentSDelta){
      break;
	}
    if (nextHDelta < currentHDelta){
      sIndicesToCheck = new Array();
	}
  }
  
  
  // Now find the best V matches out of those  
  var length = sIndicesToCheck.length; 
  for (i=0; currentColor = hsv[sIndicesToCheck[i]]; i++){
	currentColor = hsv[sIndicesToCheck[i]];
    if (i+1 >= length){
	  break;
	}	
	nextColor = hsv[sIndicesToCheck[i+1]];
	var currentVDelta = Math.abs(currentColor[3] - v);
	var nextVDelta = Math.abs(nextColor[3] - v);
    if (nextVDelta > currentVDelta){
      break;
	}
  }
  colorName = currentColor[0];
  return colorName;
}


function identifyRGBColor(r,g,b){
  var h = 0;
  var s = 0;
  var v = 0;
  
  r = r/255;
  g = g/255;
  b = b/255;
  
  var min = Math.min(r, g, b);
  var max = Math.max(r, g, b);
  var delta = max - min;
  v = max * 100;

  if (delta === 0){
    h = 0;
	s = 0;
  } else {
    s = (delta / max) * 100;
	
	deltaR = (((max - r) / 6) + (delta / 2)) / delta;
	deltaG = (((max - g) / 6) + (delta / 2)) / delta;
	deltaB = (((max - b) / 6) + (delta / 2)) / delta;
    // Find where H belongs on the circle
    if (r == max){
	  h = deltaB - deltaG;
	} else if (g == max) {
	  h = (1 / 3) + deltaR - deltaB;
	} else {
	  h = (2 / 3) + deltaG - deltaR;	
	}
    // Loop around the circle if needed
	if (h < 0){
	  h = h + 1;
	}  
	if (h > 1){
	  h = h - 1;
	}  
    h = h * 360;
  }
  return(identifyHSVColor(h,s,v));
}