# Stereo Tools

Easy Effects uses the Stereo Tools developed by Calf Studio Gear which provides some handy utilities to manage Stereo streams handling Left and Right channels in conjunction with Mid and Side signals.

Mid/Side is a recording technique which registers Mid and Side signals rather then plain Left and Right channels. Its basic setup makes use of one cardioid microphone (Mid) and one bidirectional (figure-eight) microphone (Sides). In mastering stage Mid and Side can be used to shape the balance of the Stereo image having more control over the mix to get a wider, deeper, and more focused track.

Having a Stereo stream, Mid is obtained summing both channels `(L+R)` while Side is the result of the difference between Left and Right `(L-R)`. Mid and Side signals can be decoded back to Left `(M+S)/2` and Right `(M-S)/2`.

## Input

**Balance**  
Sets the balance between both channels.

**Softclip (button)**  
Makes a kind of analog distortion instead of harsh digital 0 dB clipping.

**Softclip (value)**  
Level of Softclip.

## Stereo Matrix

**Mode**  
Allows to choose between different channel configurations such as normal Stereo Mode, Mid-Side or Mono simulation.

**Mute L/R**  
Mutes the Left/Right channel.

**Invert Phase L/R**  
Changes the Phase of the Left/Right channel.

**Side Level**  
The level of the Side signal.

**Side Balance**  
The balance of the Side signal.

**Middle Level**  
The level of the Middle signal.

**Middle Panorama**  
The position in the Panorama of the Middle signal.

## Output

**Balance**  
Sets the balance between both channels.

**Delay L/R**  
Delays the Left or the Right channel. Negative values delay the Left channel and positive values the Right channel.

**Stereo Base**  
Sets the Stereo Base of the content seamless between Mono and inverted channels.

**Stereo Phase**  
Set the Stereo Phase of the content.

## References

- [Wikipedia Stereophonic Sound](https://en.wikipedia.org/wiki/Stereophonic_sound)
- [Calf Stereo Tools](https://calf-studio-gear.org/doc/Stereo%20Tools.html)
- [Unlock Your Sound - Stereo, Mono, Mid, Side, Panning, and Imaging Explained](https://unlockyoursound.com/stereo/)
