﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Windows.Forms;

/// <summary>
///  Provides data for the <see cref="ListView.OnItemDrag"/> event.
/// </summary>
public class ItemDragEventArgs : EventArgs
{
    public ItemDragEventArgs(MouseButtons button)
        : this(button, null)
    {
    }

    public ItemDragEventArgs(MouseButtons button, object? item)
    {
        Button = button;
        Item = item;
    }

    public MouseButtons Button { get; }

    public object? Item { get; }
}
