# Microsoft.NET.Build.Containers 8.0.200

This version brings the following new features and enhancements:

* The .NET SDK now natively supports containerizing any kind of publishable project! Web and Worker projects work with no modifications, but console applications will need to add an MSBuild property to signal support. Supported projects must:
  * Set `<IsPublishable>true</IsPublishable>`, and
  * Set `<EnableSdkContainerSupport>true</EnableSdkContainerSupport>`

* Improved support for applications targeting `alpine` base images (meaning those publishing for `linux-musl` Runtime Identifiers). Now when you specify a `linux-musl` RuntimeIdentifier, the containers tooling will automatically look for `-alpine` variants of the base images. This means that you can now target `alpine` base images without needing to specify the `ContainerFamily` property at all.

* Projects that target Native AOT and projects that opt into Invariant Globalization have improved base image selection. Native AOT projects will use the `-aot` variants of relevant base images, and if `InvariantGlobalization` is true will use the `-extra` variants of relevant base images, so that required localization dependencies are included in the image. This means that for these projects you can now target these base images without needing to specify the `ContainerFamily` property at all.

* Better error messages and stack traces when communicating with registries where authentication has failed, and when the container creation is canceled by users.

* Better support for more kinds of registries - we now support registries that send CSRF tokens unconditionally, like Harbor and Harbor-derived registries.
