// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#nullable disable

using System.CommandLine;
using Microsoft.DotNet.Cli.Commands.Reference.Remove;

namespace Microsoft.DotNet.Cli.Commands.Hidden.Remove.Reference;

internal static class RemoveReferenceCommandParser
{
    private static readonly Command Command = ConstructCommand();

    public static Command GetCommand()
    {
        return Command;
    }

    private static Command ConstructCommand()
    {
        var command = new Command("reference", CliCommandStrings.ReferenceRemoveAppFullName);

        command.Arguments.Add(ReferenceRemoveCommandParser.ProjectPathArgument);
        command.Options.Add(ReferenceRemoveCommandParser.FrameworkOption);

        command.SetAction((parseResult) => new ReferenceRemoveCommand(parseResult).Execute());

        return command;
    }
}
