/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, NONE, DEEP, NF1), // BATLOW_N
	PAD_CFG_NF(GPD1, NATIVE, DEEP, NF1), // AC_PRESENT
	PAD_CFG_GPI(GPD2, NATIVE, PWROK), // PCH_LAN_WAKE#
	PAD_CFG_NF(GPD3, UP_20K, DEEP, NF1), // PWR_BTN#
	PAD_CFG_NF(GPD4, NONE, DEEP, NF1), // SUSB#_PCH
	PAD_CFG_NF(GPD5, NONE, DEEP, NF1), // SUSC#_PCH
	PAD_NC(GPD6, UP_20K),
	PAD_CFG_GPI(GPD7, UP_20K, PWROK),
	PAD_CFG_NF(GPD8, NONE, DEEP, NF1), // SUS_CLK
	PAD_NC(GPD9, NONE),
	PAD_NC(GPD10, NONE),
	PAD_CFG_GPI(GPD11, UP_20K, PWROK), // LANPHYPC

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1), // SB_KBCRST#
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1), // LPC_AD0
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1), // LPC_AD1
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1), // LPC_AD2
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1), // LPC_AD3
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1), // LPC_FRAME#
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1), // SERIRQ
	PAD_CFG_NF(GPP_A7, NONE, DEEP, NF1), // 10k pull up
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1), // PM_CLKRUN#
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1), // PCLK_KBC
	PAD_NC(GPP_A10, UP_20K),
	_PAD_CFG_STRUCT(GPP_A11, 0x80100100, 0x0000), // INTP_OUT
	PAD_CFG_GPI(GPP_A12, UP_20K, DEEP), // 10k pull up
	PAD_CFG_GPI(GPP_A13, UP_20K, DEEP), // SUS_PWR_ACK
	PAD_NC(GPP_A14, UP_20K),
	PAD_CFG_GPI(GPP_A15, UP_20K, DEEP), // SUSACK#
	PAD_NC(GPP_A16, NONE),
	PAD_NC(GPP_A17, UP_20K),
	PAD_CFG_GPO(GPP_A18, 1, DEEP), // SB_BLON
	PAD_CFG_GPI(GPP_A19, UP_20K, DEEP), // XFI_GAIN
	PAD_CFG_GPO(GPP_A20, 1, DEEP), // GPP_A20 (MB det)
	PAD_NC(GPP_A21, UP_20K),
	PAD_CFG_GPI(GPP_A22, UP_20K, DEEP), // GPP_A22 (MB det)
	PAD_CFG_GPI(GPP_A23, UP_20K, DEEP), // GPP_A23 (MB det)

	/* ------- GPIO Group GPP_B ------- */
	_PAD_CFG_STRUCT(GPP_B0, 0x42080100, 0x3000), // TPM_PIRQ#
	PAD_NC(GPP_B1, UP_20K),
	PAD_CFG_NF(GPP_B2, NONE, DEEP, NF1), // BT_UART_WAKE_N
	PAD_CFG_GPO(GPP_B3, 1, DEEP), // BT_EN
	PAD_NC(GPP_B4, UP_20K),
	PAD_CFG_NF(GPP_B5, NONE, DEEP, NF1), // WLAN_CLKREQ#
	PAD_CFG_NF(GPP_B6, NONE, DEEP, NF1), // GLAN_CLKREQ#
	PAD_CFG_GPI(GPP_B7, UP_20K, PLTRST), // GPIO_CR_RESET_R
	PAD_CFG_GPI(GPP_B8, UP_20K, PLTRST), // CR_GPIO_WAKE_N_R
	PAD_CFG_NF(GPP_B9, NONE, DEEP, NF1), // CR_CLKREQ#
	PAD_CFG_GPI(GPP_B10, UP_20K, PLTRST), // PRSNT#
	PAD_CFG_GPO(GPP_B11, 1, DEEP), // PCIE_GLAN_RESET
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1), // SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1), // PLT_RST#
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF1), // HDA_SPKR
	PAD_NC(GPP_B15, UP_20K),
	PAD_NC(GPP_B16, UP_20K),
	PAD_CFG_GPI(GPP_B17, UP_20K, DEEP), // LPSS_GSPI0_MISO
	PAD_CFG_GPI(GPP_B18, UP_20K, DEEP), // LPSS_GSPI0_MOSI
	PAD_NC(GPP_B19, UP_20K),
	_PAD_CFG_STRUCT(GPP_B20, 0x42040100, 0x0000), // SMI#_3242
	PAD_NC(GPP_B21, UP_20K),
	PAD_CFG_GPI(GPP_B22, UP_20K, DEEP), // LPSS_GSPI1_MOSI
	PAD_CFG_NF(GPP_B23, NONE, DEEP, NF2), // EXI BOOT STALL STRAP

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1), // SMB_CLK
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1), // SMB_DATA
	PAD_CFG_GPI(GPP_C2, UP_20K, DEEP), // TLS CONFIDENTIALITY STRAP
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1), // SMLINK0_CLK
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1), // SMLINK0_DATA
	PAD_CFG_NF(GPP_C5, NONE, DEEP, NF1), // ESPI/LPC SELECT STRAP
	PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1), // SMC_CPU_THERM_R
	PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1), // SMD_CPU_THERM
	PAD_CFG_GPI(GPP_C8, NONE, PLTRST), // TPM_DET#
	PAD_CFG_GPI(GPP_C9, NONE, DEEP), // GSYNC_ID
	PAD_NC(GPP_C10, DN_20K),
	PAD_CFG_GPO(GPP_C11, 1, DEEP), // FW_RST#
	PAD_NC(GPP_C12, UP_20K),
	PAD_NC(GPP_C13, UP_20K),
	PAD_NC(GPP_C14, UP_20K),
	PAD_NC(GPP_C15, UP_20K),
	PAD_CFG_NF(GPP_C16, NONE, PLTRST, NF1), // T_SDA
	PAD_CFG_NF(GPP_C17, NONE, PLTRST, NF1), // T_SCL
	PAD_CFG_NF(GPP_C18, NONE, PLTRST, NF1), // SMD_7411
	PAD_CFG_NF(GPP_C19, NONE, PLTRST, NF1), // SMC_7411
	//PAD_CFG_NF(GPP_C20, NONE, PLTRST, NF1), // UART2_RXD
	//PAD_CFG_NF(GPP_C21, NONE, PLTRST, NF1), // UART2_TXD
	PAD_NC(GPP_C22, UP_20K),
	PAD_NC(GPP_C23, UP_20K),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, UP_20K),
	PAD_NC(GPP_D1, UP_20K),
	PAD_NC(GPP_D2, UP_20K),
	PAD_NC(GPP_D3, UP_20K),
	PAD_NC(GPP_D4, UP_20K),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF3), // M.2_BT_PCMFRM_CRF_RST_N
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF3), // M.2_BT_PCMOUR_CLKREQ0
	PAD_CFG_NF(GPP_D7, NONE, PLTRST, NF1), // M.2_BT_PCMIN
	PAD_CFG_NF(GPP_D8, NONE, PLTRST, NF1), // M.2_BT_PCMCLK
	PAD_NC(GPP_D9, UP_20K),
	PAD_NC(GPP_D10, UP_20K),
	PAD_NC(GPP_D11, UP_20K),
	PAD_NC(GPP_D12, UP_20K),
	PAD_CFG_GPI(GPP_D13, UP_20K, DEEP), // 5825_I2C_DAT
	PAD_CFG_GPI(GPP_D14, UP_20K, DEEP), // 5825_I2C_CLK
	PAD_NC(GPP_D15, UP_20K),
	PAD_NC(GPP_D16, UP_20K),
	PAD_NC(GPP_D17, UP_20K),
	PAD_NC(GPP_D18, UP_20K),
	PAD_NC(GPP_D19, UP_20K),
	PAD_NC(GPP_D20, UP_20K),
	PAD_NC(GPP_D21, UP_20K),
	PAD_NC(GPP_D22, UP_20K),
	PAD_NC(GPP_D23, UP_20K),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, DEEP, NF2), // 10k pull up
	PAD_CFG_NF(GPP_E1, NONE, DEEP, NF1), // M.2_SSD1_DET_N
	PAD_CFG_NF(GPP_E2, NONE, DEEP, NF2), // VCCIO_0_CTRL
	PAD_CFG_GPI(GPP_E3, UP_20K, DEEP), // SMI#
	PAD_NC(GPP_E4, UP_20K),
	PAD_CFG_NF(GPP_E5, NONE, DEEP, NF1), // SSD1_SATA_DEVSLP
	PAD_CFG_NF(GPP_E6, NONE, DEEP, NF1), // SSD3_SATA_DEVSLP
	PAD_CFG_GPI_APIC(GPP_E7, NONE, PLTRST, EDGE_SINGLE, INVERT), // TP_ATTN#
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1), // PCH_SATAHDD_LED#
	PAD_CFG_GPI(GPP_E9, UP_20K, DEEP), // RING OSCILLATOR BYPASS STRAP
	PAD_CFG_GPI(GPP_E10, UP_20K, DEEP), // XTAL INPUT FREQUENCY STRAP
	PAD_CFG_GPI(GPP_E11, UP_20K, DEEP), // XTAL INPUT FREQUENCY STRAP
	PAD_CFG_GPI(GPP_E12, UP_20K, DEEP), // DFX TEST MODE

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF2), // 10k pull up
	PAD_CFG_NF(GPP_F1, NONE, DEEP, NF1), // M.2_SSD2_DET_N
	PAD_CFG_TERM_GPO(GPP_F2, 1, UP_20K, RSMRST), // GPP_F2_TBT_RST#
	PAD_CFG_NF(GPP_F3, NONE, DEEP, NF2), // 10k pull up
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF2), // 10k pull up
	PAD_CFG_NF(GPP_F5, NONE, DEEP, NF1), // SSD4_SATA_DEVSLP
	PAD_CFG_NF(GPP_F6, NONE, DEEP, NF1), // SSD2_SATA_DEVSLP
	PAD_NC(GPP_F7, UP_20K),
	PAD_CFG_GPI(GPP_F8, UP_20K, DEEP), // GPU_PWR_EN#
	PAD_NC(GPP_F9, UP_20K),
	PAD_CFG_GPI(GPP_F10, UP_20K, DEEP), // PCH_CONFIG_JUMPER
	PAD_CFG_GPO(GPP_F11, 0, DEEP), // SSD1_PWR_DN#
	PAD_CFG_GPI(GPP_F12, UP_20K, DEEP),
	PAD_CFG_GPI(GPP_F13, UP_20K, DEEP),
	PAD_NC(GPP_F14, NONE),
	PAD_NC(GPP_F15, UP_20K),
	PAD_NC(GPP_F16, UP_20K),
	PAD_NC(GPP_F17, UP_20K),
	PAD_CFG_GPI(GPP_F18, UP_20K, DEEP), // GPIO_PCIESLOT_RST_R
	PAD_NC(GPP_F19, UP_20K),
	PAD_NC(GPP_F20, UP_20K),
	PAD_NC(GPP_F21, UP_20K),
	//PAD_CFG_TERM_GPO(GPP_F22, 1, UP_20K, DEEP), // DGPU_RST#_PCH
	PAD_CFG_GPO(GPP_F23, 0, DEEP), // GC_OFF_EN

	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, UP_20K),
	PAD_NC(GPP_G1, UP_20K),
	PAD_NC(GPP_G2, UP_20K),
	PAD_NC(GPP_G3, UP_20K),
	PAD_NC(GPP_G4, UP_20K),
	PAD_NC(GPP_G5, UP_20K),
	PAD_NC(GPP_G6, UP_20K),
	PAD_NC(GPP_G7, UP_20K),

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_NF(GPP_H0, NONE, DEEP, NF1), // TBT_CLKREQ#
	PAD_CFG_NF(GPP_H1, NONE, DEEP, NF1), // MXM_REQ#
	PAD_CFG_NF(GPP_H2, NONE, DEEP, NF1), // SSD_CLKREQ#
	PAD_NC(GPP_H3, NONE),
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1), // PE_CLKREQ#
	PAD_NC(GPP_H5, NONE),
	PAD_CFG_GPI(GPP_H6, NONE, PLTRST), // WLAN_GPIO_WAKE_N
	PAD_CFG_GPO(GPP_H7, 0, DEEP), // PCIE_SSD2_RESET
	PAD_CFG_NF(GPP_H8, NONE, DEEP, NF1), // SSD2_CLKREQ#
	PAD_CFG_NF(GPP_H9, NONE, DEEP, NF1), // SSD3_CLKREQ#
	PAD_NC(GPP_H10, NONE),
	PAD_CFG_GPO(GPP_H11, 0, DEEP), // SSD3_PWR_DN#
	PAD_CFG_GPI(GPP_H12, UP_20K, DEEP), // GPP_H_12
	PAD_NC(GPP_H13, UP_20K),
	PAD_NC(GPP_H14, UP_20K),
	_PAD_CFG_STRUCT(GPP_H15, 0x40880100, 0x3000), // GPP_H15_TBT_WAKE#
	PAD_NC(GPP_H16, UP_20K),
	PAD_NC(GPP_H17, UP_20K),
	PAD_NC(GPP_H18, UP_20K),
	PAD_CFG_GPI(GPP_H19, UP_20K, DEEP), // GPIO_CARD_AUX
	PAD_CFG_GPI(GPP_H20, UP_20K, DEEP), // GPIO_CARD
	PAD_NC(GPP_H21, UP_20K),
	PAD_NC(GPP_H22, UP_20K),
	PAD_NC(GPP_H23, UP_20K),

	/* ------- GPIO Group GPP_I ------- */
	_PAD_CFG_STRUCT(GPP_I0, 0x46080100, 0x0000), // GPPDPA_I0
	_PAD_CFG_STRUCT(GPP_I1, 0x46080100, 0x0000), // GPPDPB_I1
	_PAD_CFG_STRUCT(GPP_I2, 0x46080100, 0x0000), // HDMI_HPD
	_PAD_CFG_STRUCT(GPP_I3, 0x46080100, 0x0000), // DP_F_HPD
	PAD_CFG_NF(GPP_I4, NONE, DEEP, NF1), // 100k pull down
	PAD_CFG_GPO(GPP_I5, 0, DEEP), // GPIO_TBT_RESET
	PAD_CFG_GPI(GPP_I6, UP_20K, DEEP), // MXM_GPIO0
	PAD_CFG_GPI(GPP_I7, UP_20K, DEEP), // 10k pull up
	PAD_CFG_GPI(GPP_I8, UP_20K, DEEP), // GPIO_WIFI_RESET_R
	PAD_CFG_GPO(GPP_I9, 1, DEEP), // WLAN_EN
	PAD_CFG_GPO(GPP_I10, 0, DEEP), // SSD2_PWR_DN#
	PAD_CFG_GPI(GPP_I11, UP_20K, DEEP), // H_SKTOCC_N
	PAD_CFG_GPO(GPP_I12, 0, DEEP), // PCIE_SSD3_RESET
	PAD_CFG_GPO(GPP_I13, 0, DEEP), // PCIE_SSD1_RESET
	PAD_NC(GPP_I14, UP_20K),

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_NF(GPP_J0, NONE, DEEP, NF1), // CNVI_GNSS_PA_BLANKING
	PAD_CFG_NF(GPP_J1, NONE, DEEP, NF2), // CPI_C10_GATE_N (VCCIO_3P3_PWRGATE)
	PAD_NC(GPP_J2, UP_20K),
	PAD_NC(GPP_J3, UP_20K),
	PAD_CFG_NF(GPP_J4, NONE, DEEP, NF1), // CNVI_BRI_DT_R
	PAD_CFG_NF(GPP_J5, UP_20K, DEEP, NF1), // CNVI_BRI_RSP
	PAD_CFG_NF(GPP_J6, NONE, DEEP, NF1), // CNVI_RGI_DT_R
	PAD_CFG_NF(GPP_J7, UP_20K, DEEP, NF1), // CNVI_RGI_RSP
	PAD_CFG_NF(GPP_J8, NONE, DEEP, NF1), // CNVI_MFUART2_RXD
	PAD_CFG_NF(GPP_J9, UP_20K, DEEP, NF1), // CNVI_MFUART2_TXD
	PAD_CFG_GPI(GPP_J10, UP_20K, DEEP), // EDP_OD_EN
	PAD_CFG_GPI(GPP_J11, UP_20K, DEEP),

	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPI(GPP_K0, UP_20K, DEEP), // PCH_GPIO_PK_MUTE
	PAD_CFG_GPI(GPP_K1, UP_20K, DEEP), // PCH_GPIO_WOOFER_MUTE
	PAD_CFG_GPI(GPP_K2, UP_20K, DEEP), // DGPU_PWRGD
	_PAD_CFG_STRUCT(GPP_K3, 0x80880100, 0x3000), // SCI#
	PAD_CFG_GPI(GPP_K4, UP_20K, DEEP), // GPU_EVENT#_R
	PAD_CFG_GPO(GPP_K5, 0, DEEP), // DP_MUX_SW
	_PAD_CFG_STRUCT(GPP_K6, 0x40880100, 0x0000), // SWI#
	PAD_CFG_GPI(GPP_K7, UP_20K, DEEP), // E3100_PWR_EN
	PAD_CFG_GPO(GPP_K8, 0, DEEP), // SSD4_PWR_DN#
	PAD_CFG_GPI(GPP_K9, UP_20K, DEEP), // TBTA_HRESET
	PAD_CFG_GPI(GPP_K10, UP_20K, DEEP), // MIC_SENSE_PCH
	PAD_CFG_GPI(GPP_K11, UP_20K, DEEP), // XFI_SENSE_PCH
	_PAD_CFG_STRUCT(GPP_K12, 0x82880100, 0x3000), // TBCIO_PLUG_EVENT#
	PAD_NC(GPP_K13, UP_20K),
	PAD_CFG_GPO(GPP_K14, 0, DEEP), // 7411_TEST_R
	PAD_NC(GPP_K15, UP_20K),
	PAD_CFG_TERM_GPO(GPP_K16, 1, UP_20K, DEEP), // TBT_FORCE_PWR_R
	PAD_NC(GPP_K17, UP_20K),
	PAD_CFG_GPO(GPP_K18, 1, DEEP), // PCH_MUTE#
	PAD_NC(GPP_K19, UP_20K),
	PAD_CFG_GPI(GPP_K20, UP_20K, DEEP), // TEST_SETUP_MENU
	PAD_CFG_GPI(GPP_K21, NONE, DEEP), // GC6_FB_EN
	//PAD_CFG_TERM_GPO(GPP_K22, 0, UP_5K, DEEP), // GPU_PWR_EN#
	PAD_CFG_GPO(GPP_K23, 1, RSMRST), // TBT_RTD3_PWR_EN_R
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
