clojure.core.cache
========================================

core.cache is a new Clojure contrib library providing the following features:

* An underlying `CacheProtocol` used as the base abstraction for implementing new synchronous caches

* A `defcache` macro for hooking your `CacheProtocol` implementations into the Clojure associative data capabilities.

* Implementations of some basic caching strategies
  - First-in-first-out (FIFOCache)
  - Least-recently-used (LRUCache)
  - Least-used (LUCache -- sometimes called Least Frequently Used)
  - Time-to-live (TTLCache)
  - Naive cache (BasicCache)
  - Naive cache backed with soft references (SoftCache)

* Implementation of an efficient buffer replacement policy based on the *low inter-reference recency set* algorithm (LIRSCache) described in the [LIRS](http://citeseer.ist.psu.edu/viewdoc/summary?doi=10.1.1.116.2184) paper

* Factory functions for each existing cache type

core.cache is based on an old library named Clache that has been thouroughly deprecated.


Releases and Dependency Information
========================================

Latest stable release: 0.6.4

* [All Released Versions](http://search.maven.org/#search%7Cgav%7C1%7Cg%3A%22org.clojure%22%20AND%20a%3A%22core.cache%22)

* [Development Snapshot Versions](https://oss.sonatype.org/index.html#nexus-search;gav~org.clojure~core.cache~~~)

[Leiningen](https://github.com/technomancy/leiningen) dependency information:

    [org.clojure/core.cache "0.6.4"]

[Maven](http://maven.apache.org/) dependency information:

    <dependency>
      <groupId>org.clojure</groupId>
      <artifactId>core.cache</artifactId>
      <version>0.6.4</version>
    </dependency>



Example Usage
========================================

```clojure
    (require '[clojure.core.cache :as cache])
	
    (def C (cache/fifo-cache-factory {:a 1, :b 2}))
	
    (if (cache/has? C :c)
      (cache/hit C :c)
      (cache/miss C :c 42))
	
    ;=> {:a 1, :b 2, :c 42}
	
    (cache/evict C :b)
	
    ;=> {:a 1}
```

Refer to docstrings in the `clojure.core.cache` namespace, or the [autogenerated API documentation](http://clojure.github.com/core.cache/) for additional documentation



Developer Information
========================================

* [GitHub project](https://github.com/clojure/core.cache)

* [Bug Tracker](http://dev.clojure.org/jira/browse/CCACHE)

* [Continuous Integration](http://build.clojure.org/job/core.cache/)

* [Compatibility Test Matrix](http://build.clojure.org/job/core.cache-test-matrix/)



Change Log
====================

* Release 0.6.4 on 2014.08.06
  * Thanks to Paul Stadig and Nicola Mometto who contributed patches for this release
  * [CCACHE-34](http://dev.clojure.org/jira/browse/CCACHE-34) bump tools.priority-map dependency to 0.0.4
  * [CCACHE-28](http://dev.clojure.org/jira/browse/CCACHE-28) concurrency bug in has? for SoftCache
  * [CCACHE-29](http://dev.clojure.org/jira/browse/CCACHE-29) fix conj implementation for caches
  * [CCACHE-30](http://dev.clojure.org/jira/browse/CCACHE-30) make-reference need not be dynamic
  * [CCACHE-26](http://dev.clojure.org/jira/browse/CCACHE-26) hit function in LRU cache can give funny results
* Release 0.6.3 on 2013.03.15
  * Added through to encapsulate check logic
* Release 0.6.2 on 2012.08.07 [more information](http://blog.fogus.me/?p=4527)
  * Removed reflection warnings
  * Fixed eviction of items from LU, TTL and LRU caches with thresholds less than two
  * Fixed eviction of items from FIFO cache prior to threshold
* Release 0.6.2 on 2012.07.13 [more information](http://blog.fogus.me/2012/07/13/announcing-core-cache-version-0-6-1/)
  * Added SoftCache
  * Fixed eviction of items from LU and LRU caches prior to threshold
  * Adjusted default thresholds in factory functions
* Release 0.5.0 on 2011.12.13 [more information](http://blog.fogus.me/2011/12/13/announcing-core-cache-v0-5-0/)
  * Added `evict`
  * Added cache factory functions
  * Added associatve operation support


Copyright and License
========================================

Copyright (c) Rich Hickey, Michael Fogus and contributors, 2012. All rights reserved.  The use and distribution terms for this software are covered by the Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) which can be found in the file epl-v10.html at the root of this distribution. By using this software in any fashion, you are agreeing to be bound bythe terms of this license.  You must not remove this notice, or any other, from this software.
