<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/UFField.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:4777c5b97760d4bd4b7138468d18ded5)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_UFField constructor.
 */
class CRM_Core_DAO_UFField extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_uf_field';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Unique table ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Which form does this field belong to.
   *
   * @var int unsigned
   */
  public $uf_group_id;
  /**
   * Name for CiviCRM field which is being exposed for sharing.
   *
   * @var string
   */
  public $field_name;
  /**
   * Is this field currently shareable? If false, hide the field for all sharing contexts.
   *
   * @var boolean
   */
  public $is_active;
  /**
   * the field is view only and not editable in user forms.
   *
   * @var boolean
   */
  public $is_view;
  /**
   * Is this field required when included in a user or registration form?
   *
   * @var boolean
   */
  public $is_required;
  /**
   * Controls field display order when user framework fields are displayed in registration and account editing forms.
   *
   * @var int
   */
  public $weight;
  /**
   * Description and/or help text to display after this field.
   *
   * @var text
   */
  public $help_post;
  /**
   * Description and/or help text to display before this field.
   *
   * @var text
   */
  public $help_pre;
  /**
   * In what context(s) is this field visible.
   *
   * @var string
   */
  public $visibility;
  /**
   * Is this field included as a column in the selector table?
   *
   * @var boolean
   */
  public $in_selector;
  /**
   * Is this field included search form of profile?
   *
   * @var boolean
   */
  public $is_searchable;
  /**
   * Location type of this mapping, if required
   *
   * @var int unsigned
   */
  public $location_type_id;
  /**
   * Phone Type Id, if required
   *
   * @var int unsigned
   */
  public $phone_type_id;
  /**
   * Website Type Id, if required
   *
   * @var int unsigned
   */
  public $website_type_id;
  /**
   * To save label for fields.
   *
   * @var string
   */
  public $label;
  /**
   * This field saves field type (ie individual,household.. field etc).
   *
   * @var string
   */
  public $field_type;
  /**
   * Is this field reserved for use by some other CiviCRM functionality?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Include in multi-record listing?
   *
   * @var boolean
   */
  public $is_multi_summary;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_uf_field';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'uf_group_id', 'civicrm_uf_group', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'location_type_id', 'civicrm_location_type', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field ID') ,
          'description' => 'Unique table ID',
          'required' => true,
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'uf_group_id' => array(
          'name' => 'uf_group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile ID') ,
          'description' => 'Which form does this field belong to.',
          'required' => true,
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_UFGroup',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_uf_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          )
        ) ,
        'field_name' => array(
          'name' => 'field_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Name') ,
          'description' => 'Name for CiviCRM field which is being exposed for sharing.',
          'required' => true,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Active') ,
          'description' => 'Is this field currently shareable? If false, hide the field for all sharing contexts.',
          'default' => '1',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_view' => array(
          'name' => 'is_view',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Is View Only') ,
          'description' => 'the field is view only and not editable in user forms.',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_required' => array(
          'name' => 'is_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Required') ,
          'description' => 'Is this field required when included in a user or registration form?',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'weight' => array(
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order') ,
          'description' => 'Controls field display order when user framework fields are displayed in registration and account editing forms.',
          'required' => true,
          'default' => '1',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'help_post' => array(
          'name' => 'help_post',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Profile Field Post Help') ,
          'description' => 'Description and/or help text to display after this field.',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
        ) ,
        'help_pre' => array(
          'name' => 'help_pre',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Profile Field Pre Help') ,
          'description' => 'Description and/or help text to display before this field.',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
        ) ,
        'visibility' => array(
          'name' => 'visibility',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Visibility') ,
          'description' => 'In what context(s) is this field visible.',
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'default' => 'User and User Admin Only',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::ufVisibility',
          )
        ) ,
        'in_selector' => array(
          'name' => 'in_selector',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is a Filter') ,
          'description' => 'Is this field included as a column in the selector table?',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_searchable' => array(
          'name' => 'is_searchable',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Searchable') ,
          'description' => 'Is this field included search form of profile?',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'location_type_id' => array(
          'name' => 'location_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field Location Type') ,
          'description' => 'Location type of this mapping, if required',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_LocationType',
        ) ,
        'phone_type_id' => array(
          'name' => 'phone_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field Phone Type') ,
          'description' => 'Phone Type Id, if required',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'website_type_id' => array(
          'name' => 'website_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field Website Type') ,
          'description' => 'Website Type Id, if required',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'label' => array(
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Label') ,
          'description' => 'To save label for fields.',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
        ) ,
        'field_type' => array(
          'name' => 'field_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Type') ,
          'description' => 'This field saves field type (ie individual,household.. field etc).',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Reserved') ,
          'description' => 'Is this field reserved for use by some other CiviCRM functionality?',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
        'is_multi_summary' => array(
          'name' => 'is_multi_summary',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Supports Multiple') ,
          'description' => 'Include in multi-record listing?',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'uf_field', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'uf_field', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'IX_website_type_id' => array(
        'name' => 'IX_website_type_id',
        'field' => array(
          0 => 'website_type_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_uf_field::0::website_type_id',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
