// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUI.h"
#include "GUIContext.pypp.hpp"

namespace bp = boost::python;

struct GUIContext_wrapper : CEGUI::GUIContext, bp::wrapper< CEGUI::GUIContext > {

    GUIContext_wrapper(::CEGUI::RenderTarget & target )
    : CEGUI::GUIContext( boost::ref(target) )
      , bp::wrapper< CEGUI::GUIContext >(){
        // constructor
    
    }

    bool areaChangedHandler( ::CEGUI::EventArgs const & args ){
        return CEGUI::GUIContext::areaChangedHandler( boost::ref(args) );
    }

    void createDefaultTooltipWindowInstance(  ) const {
        CEGUI::GUIContext::createDefaultTooltipWindowInstance(  );
    }

    void destroyDefaultTooltipWindowInstance(  ){
        CEGUI::GUIContext::destroyDefaultTooltipWindowInstance(  );
    }

    virtual void draw(  ) {
        if( bp::override func_draw = this->get_override( "draw" ) )
            func_draw(  );
        else{
            this->CEGUI::GUIContext::draw(  );
        }
    }
    
    void default_draw(  ) {
        CEGUI::GUIContext::draw( );
    }

    virtual void drawContent(  ){
        if( bp::override func_drawContent = this->get_override( "drawContent" ) )
            func_drawContent(  );
        else{
            this->CEGUI::GUIContext::drawContent(  );
        }
    }
    
    virtual void default_drawContent(  ){
        CEGUI::GUIContext::drawContent( );
    }

    void drawWindowContentToTarget(  ){
        CEGUI::GUIContext::drawWindowContentToTarget(  );
    }

    ::CEGUI::Window * getCommonAncestor( ::CEGUI::Window * w1, ::CEGUI::Window * w2 ) const {
        return CEGUI::GUIContext::getCommonAncestor( boost::python::ptr(w1), boost::python::ptr(w2) );
    }

    ::CEGUI::Window * getKeyboardTargetWindow(  ) const {
        return CEGUI::GUIContext::getKeyboardTargetWindow(  );
    }

    ::CEGUI::Window * getTargetWindow( ::CEGUI::Vector2f const & pt, bool const allow_disabled ) const {
        return CEGUI::GUIContext::getTargetWindow( boost::ref(pt), allow_disabled );
    }

    virtual bool injectChar( ::CEGUI::utf32 code_point ) {
        if( bp::override func_injectChar = this->get_override( "injectChar" ) )
            return func_injectChar( code_point );
        else{
            return this->CEGUI::GUIContext::injectChar( code_point );
        }
    }
    
    bool default_injectChar( ::CEGUI::utf32 code_point ) {
        return CEGUI::GUIContext::injectChar( code_point );
    }

    virtual bool injectCopyRequest(  ) {
        if( bp::override func_injectCopyRequest = this->get_override( "injectCopyRequest" ) )
            return func_injectCopyRequest(  );
        else{
            return this->CEGUI::GUIContext::injectCopyRequest(  );
        }
    }
    
    bool default_injectCopyRequest(  ) {
        return CEGUI::GUIContext::injectCopyRequest( );
    }

    virtual bool injectCutRequest(  ) {
        if( bp::override func_injectCutRequest = this->get_override( "injectCutRequest" ) )
            return func_injectCutRequest(  );
        else{
            return this->CEGUI::GUIContext::injectCutRequest(  );
        }
    }
    
    bool default_injectCutRequest(  ) {
        return CEGUI::GUIContext::injectCutRequest( );
    }

    virtual bool injectKeyDown( ::CEGUI::Key::Scan scan_code ) {
        if( bp::override func_injectKeyDown = this->get_override( "injectKeyDown" ) )
            return func_injectKeyDown( scan_code );
        else{
            return this->CEGUI::GUIContext::injectKeyDown( scan_code );
        }
    }
    
    bool default_injectKeyDown( ::CEGUI::Key::Scan scan_code ) {
        return CEGUI::GUIContext::injectKeyDown( scan_code );
    }

    virtual bool injectKeyUp( ::CEGUI::Key::Scan scan_code ) {
        if( bp::override func_injectKeyUp = this->get_override( "injectKeyUp" ) )
            return func_injectKeyUp( scan_code );
        else{
            return this->CEGUI::GUIContext::injectKeyUp( scan_code );
        }
    }
    
    bool default_injectKeyUp( ::CEGUI::Key::Scan scan_code ) {
        return CEGUI::GUIContext::injectKeyUp( scan_code );
    }

    virtual bool injectMouseButtonClick( ::CEGUI::MouseButton const button ) {
        if( bp::override func_injectMouseButtonClick = this->get_override( "injectMouseButtonClick" ) )
            return func_injectMouseButtonClick( button );
        else{
            return this->CEGUI::GUIContext::injectMouseButtonClick( button );
        }
    }
    
    bool default_injectMouseButtonClick( ::CEGUI::MouseButton const button ) {
        return CEGUI::GUIContext::injectMouseButtonClick( button );
    }

    virtual bool injectMouseButtonDoubleClick( ::CEGUI::MouseButton const button ) {
        if( bp::override func_injectMouseButtonDoubleClick = this->get_override( "injectMouseButtonDoubleClick" ) )
            return func_injectMouseButtonDoubleClick( button );
        else{
            return this->CEGUI::GUIContext::injectMouseButtonDoubleClick( button );
        }
    }
    
    bool default_injectMouseButtonDoubleClick( ::CEGUI::MouseButton const button ) {
        return CEGUI::GUIContext::injectMouseButtonDoubleClick( button );
    }

    virtual bool injectMouseButtonDown( ::CEGUI::MouseButton button ) {
        if( bp::override func_injectMouseButtonDown = this->get_override( "injectMouseButtonDown" ) )
            return func_injectMouseButtonDown( button );
        else{
            return this->CEGUI::GUIContext::injectMouseButtonDown( button );
        }
    }
    
    bool default_injectMouseButtonDown( ::CEGUI::MouseButton button ) {
        return CEGUI::GUIContext::injectMouseButtonDown( button );
    }

    virtual bool injectMouseButtonTripleClick( ::CEGUI::MouseButton const button ) {
        if( bp::override func_injectMouseButtonTripleClick = this->get_override( "injectMouseButtonTripleClick" ) )
            return func_injectMouseButtonTripleClick( button );
        else{
            return this->CEGUI::GUIContext::injectMouseButtonTripleClick( button );
        }
    }
    
    bool default_injectMouseButtonTripleClick( ::CEGUI::MouseButton const button ) {
        return CEGUI::GUIContext::injectMouseButtonTripleClick( button );
    }

    virtual bool injectMouseButtonUp( ::CEGUI::MouseButton button ) {
        if( bp::override func_injectMouseButtonUp = this->get_override( "injectMouseButtonUp" ) )
            return func_injectMouseButtonUp( button );
        else{
            return this->CEGUI::GUIContext::injectMouseButtonUp( button );
        }
    }
    
    bool default_injectMouseButtonUp( ::CEGUI::MouseButton button ) {
        return CEGUI::GUIContext::injectMouseButtonUp( button );
    }

    virtual bool injectMouseLeaves(  ) {
        if( bp::override func_injectMouseLeaves = this->get_override( "injectMouseLeaves" ) )
            return func_injectMouseLeaves(  );
        else{
            return this->CEGUI::GUIContext::injectMouseLeaves(  );
        }
    }
    
    bool default_injectMouseLeaves(  ) {
        return CEGUI::GUIContext::injectMouseLeaves( );
    }

    virtual bool injectMouseMove( float delta_x, float delta_y ) {
        if( bp::override func_injectMouseMove = this->get_override( "injectMouseMove" ) )
            return func_injectMouseMove( delta_x, delta_y );
        else{
            return this->CEGUI::GUIContext::injectMouseMove( delta_x, delta_y );
        }
    }
    
    bool default_injectMouseMove( float delta_x, float delta_y ) {
        return CEGUI::GUIContext::injectMouseMove( delta_x, delta_y );
    }

    virtual bool injectMousePosition( float x_pos, float y_pos ) {
        if( bp::override func_injectMousePosition = this->get_override( "injectMousePosition" ) )
            return func_injectMousePosition( x_pos, y_pos );
        else{
            return this->CEGUI::GUIContext::injectMousePosition( x_pos, y_pos );
        }
    }
    
    bool default_injectMousePosition( float x_pos, float y_pos ) {
        return CEGUI::GUIContext::injectMousePosition( x_pos, y_pos );
    }

    virtual bool injectMouseWheelChange( float delta ) {
        if( bp::override func_injectMouseWheelChange = this->get_override( "injectMouseWheelChange" ) )
            return func_injectMouseWheelChange( delta );
        else{
            return this->CEGUI::GUIContext::injectMouseWheelChange( delta );
        }
    }
    
    bool default_injectMouseWheelChange( float delta ) {
        return CEGUI::GUIContext::injectMouseWheelChange( delta );
    }

    virtual bool injectPasteRequest(  ) {
        if( bp::override func_injectPasteRequest = this->get_override( "injectPasteRequest" ) )
            return func_injectPasteRequest(  );
        else{
            return this->CEGUI::GUIContext::injectPasteRequest(  );
        }
    }
    
    bool default_injectPasteRequest(  ) {
        return CEGUI::GUIContext::injectPasteRequest( );
    }

    virtual bool injectTimePulse( float timeElapsed ) {
        if( bp::override func_injectTimePulse = this->get_override( "injectTimePulse" ) )
            return func_injectTimePulse( timeElapsed );
        else{
            return this->CEGUI::GUIContext::injectTimePulse( timeElapsed );
        }
    }
    
    bool default_injectTimePulse( float timeElapsed ) {
        return CEGUI::GUIContext::injectTimePulse( timeElapsed );
    }

    bool mouseMoveInjection_impl( ::CEGUI::MouseEventArgs & ma ){
        return CEGUI::GUIContext::mouseMoveInjection_impl( boost::ref(ma) );
    }

    void notifyDefaultFontChanged( ::CEGUI::Window * hierarchy_root ) const {
        CEGUI::GUIContext::notifyDefaultFontChanged( boost::python::ptr(hierarchy_root) );
    }

    virtual void onDefaultFontChanged( ::CEGUI::EventArgs & args ){
        if( bp::override func_onDefaultFontChanged = this->get_override( "onDefaultFontChanged" ) )
            func_onDefaultFontChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onDefaultFontChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onDefaultFontChanged( ::CEGUI::EventArgs & args ){
        CEGUI::GUIContext::onDefaultFontChanged( boost::ref(args) );
    }

    virtual void onMouseButtonClickTimeoutChanged( ::CEGUI::GUIContextEventArgs & args ){
        if( bp::override func_onMouseButtonClickTimeoutChanged = this->get_override( "onMouseButtonClickTimeoutChanged" ) )
            func_onMouseButtonClickTimeoutChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onMouseButtonClickTimeoutChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onMouseButtonClickTimeoutChanged( ::CEGUI::GUIContextEventArgs & args ){
        CEGUI::GUIContext::onMouseButtonClickTimeoutChanged( boost::ref(args) );
    }

    virtual void onMouseButtonMultiClickTimeoutChanged( ::CEGUI::GUIContextEventArgs & args ){
        if( bp::override func_onMouseButtonMultiClickTimeoutChanged = this->get_override( "onMouseButtonMultiClickTimeoutChanged" ) )
            func_onMouseButtonMultiClickTimeoutChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onMouseButtonMultiClickTimeoutChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onMouseButtonMultiClickTimeoutChanged( ::CEGUI::GUIContextEventArgs & args ){
        CEGUI::GUIContext::onMouseButtonMultiClickTimeoutChanged( boost::ref(args) );
    }

    virtual void onMouseButtonMultiClickToleranceChanged( ::CEGUI::GUIContextEventArgs & args ){
        if( bp::override func_onMouseButtonMultiClickToleranceChanged = this->get_override( "onMouseButtonMultiClickToleranceChanged" ) )
            func_onMouseButtonMultiClickToleranceChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onMouseButtonMultiClickToleranceChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onMouseButtonMultiClickToleranceChanged( ::CEGUI::GUIContextEventArgs & args ){
        CEGUI::GUIContext::onMouseButtonMultiClickToleranceChanged( boost::ref(args) );
    }

    virtual void onMouseMoveScalingFactorChanged( ::CEGUI::GUIContextEventArgs & args ){
        if( bp::override func_onMouseMoveScalingFactorChanged = this->get_override( "onMouseMoveScalingFactorChanged" ) )
            func_onMouseMoveScalingFactorChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onMouseMoveScalingFactorChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onMouseMoveScalingFactorChanged( ::CEGUI::GUIContextEventArgs & args ){
        CEGUI::GUIContext::onMouseMoveScalingFactorChanged( boost::ref(args) );
    }

    virtual void onRenderTargetChanged( ::CEGUI::GUIContextRenderTargetEventArgs & args ){
        if( bp::override func_onRenderTargetChanged = this->get_override( "onRenderTargetChanged" ) )
            func_onRenderTargetChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onRenderTargetChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onRenderTargetChanged( ::CEGUI::GUIContextRenderTargetEventArgs & args ){
        CEGUI::GUIContext::onRenderTargetChanged( boost::ref(args) );
    }

    virtual void onRootWindowChanged( ::CEGUI::WindowEventArgs & args ){
        if( bp::override func_onRootWindowChanged = this->get_override( "onRootWindowChanged" ) )
            func_onRootWindowChanged( boost::ref(args) );
        else{
            this->CEGUI::GUIContext::onRootWindowChanged( boost::ref(args) );
        }
    }
    
    virtual void default_onRootWindowChanged( ::CEGUI::WindowEventArgs & args ){
        CEGUI::GUIContext::onRootWindowChanged( boost::ref(args) );
    }

    void renderWindowHierarchyToSurfaces(  ){
        CEGUI::GUIContext::renderWindowHierarchyToSurfaces(  );
    }

    void resetWindowContainingMouse(  ){
        CEGUI::GUIContext::resetWindowContainingMouse(  );
    }

    void updateRootWindowAreaRects(  ) const {
        CEGUI::GUIContext::updateRootWindowAreaRects(  );
    }

    bool updateWindowContainingMouse_impl(  ) const {
        return CEGUI::GUIContext::updateWindowContainingMouse_impl(  );
    }

    bool windowDestroyedHandler( ::CEGUI::EventArgs const & args ){
        return CEGUI::GUIContext::windowDestroyedHandler( boost::ref(args) );
    }

    void attachWindow( ::CEGUI::RenderingWindow & w ){
        CEGUI::RenderingSurface::attachWindow( boost::ref(w) );
    }

    virtual void destroyRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        if( bp::override func_destroyRenderingWindow = this->get_override( "destroyRenderingWindow" ) )
            func_destroyRenderingWindow( boost::ref(window) );
        else{
            this->CEGUI::RenderingSurface::destroyRenderingWindow( boost::ref(window) );
        }
    }
    
    void default_destroyRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        CEGUI::RenderingSurface::destroyRenderingWindow( boost::ref(window) );
    }

    void detatchWindow( ::CEGUI::RenderingWindow & w ){
        CEGUI::RenderingSurface::detatchWindow( boost::ref(w) );
    }

    void draw( ::CEGUI::RenderQueue const & queue, ::CEGUI::RenderQueueEventArgs & args ){
        CEGUI::RenderingSurface::draw( boost::ref(queue), boost::ref(args) );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    void fireEvent_impl( ::CEGUI::String const & name, ::CEGUI::EventArgs & args ){
        CEGUI::EventSet::fireEvent_impl( boost::ref(name), boost::ref(args) );
    }

    ::CEGUI::ScriptModule * getScriptModule(  ) const {
        return CEGUI::EventSet::getScriptModule(  );
    }

    virtual void invalidate(  ) {
        if( bp::override func_invalidate = this->get_override( "invalidate" ) )
            func_invalidate(  );
        else{
            this->CEGUI::RenderingSurface::invalidate(  );
        }
    }
    
    void default_invalidate(  ) {
        CEGUI::RenderingSurface::invalidate( );
    }

    virtual bool isRenderingWindow(  ) const  {
        if( bp::override func_isRenderingWindow = this->get_override( "isRenderingWindow" ) )
            return func_isRenderingWindow(  );
        else{
            return this->CEGUI::RenderingSurface::isRenderingWindow(  );
        }
    }
    
    bool default_isRenderingWindow(  ) const  {
        return CEGUI::RenderingSurface::isRenderingWindow( );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

    virtual void transferRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        if( bp::override func_transferRenderingWindow = this->get_override( "transferRenderingWindow" ) )
            func_transferRenderingWindow( boost::ref(window) );
        else{
            this->CEGUI::RenderingSurface::transferRenderingWindow( boost::ref(window) );
        }
    }
    
    void default_transferRenderingWindow( ::CEGUI::RenderingWindow & window ) {
        CEGUI::RenderingSurface::transferRenderingWindow( boost::ref(window) );
    }

};

void register_GUIContext_class(){

    { //::CEGUI::GUIContext
        typedef bp::class_< GUIContext_wrapper, bp::bases< CEGUI::RenderingSurface >, boost::noncopyable > GUIContext_exposer_t;
        GUIContext_exposer_t GUIContext_exposer = GUIContext_exposer_t( "GUIContext", bp::init< CEGUI::RenderTarget & >(( bp::arg("target") )) );
        bp::scope GUIContext_scope( GUIContext_exposer );
        bp::implicitly_convertible< CEGUI::RenderTarget &, CEGUI::GUIContext >();
        { //::CEGUI::GUIContext::areaChangedHandler
        
            typedef bool ( GUIContext_wrapper::*areaChangedHandler_function_type )( ::CEGUI::EventArgs const & ) ;
            
            GUIContext_exposer.def( 
                "areaChangedHandler"
                , areaChangedHandler_function_type( &GUIContext_wrapper::areaChangedHandler )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::createDefaultTooltipWindowInstance
        
            typedef void ( GUIContext_wrapper::*createDefaultTooltipWindowInstance_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "createDefaultTooltipWindowInstance"
                , createDefaultTooltipWindowInstance_function_type( &GUIContext_wrapper::createDefaultTooltipWindowInstance ) );
        
        }
        { //::CEGUI::GUIContext::destroyDefaultTooltipWindowInstance
        
            typedef void ( GUIContext_wrapper::*destroyDefaultTooltipWindowInstance_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "destroyDefaultTooltipWindowInstance"
                , destroyDefaultTooltipWindowInstance_function_type( &GUIContext_wrapper::destroyDefaultTooltipWindowInstance ) );
        
        }
        { //::CEGUI::GUIContext::draw
        
            typedef void ( ::CEGUI::GUIContext::*draw_function_type )(  ) ;
            typedef void ( GUIContext_wrapper::*default_draw_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "draw"
                , draw_function_type(&::CEGUI::GUIContext::draw)
                , default_draw_function_type(&GUIContext_wrapper::default_draw) );
        
        }
        { //::CEGUI::GUIContext::drawContent
        
            typedef void ( GUIContext_wrapper::*drawContent_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "drawContent"
                , drawContent_function_type( &GUIContext_wrapper::default_drawContent )
                , "protected overrides\n" );
        
        }
        { //::CEGUI::GUIContext::drawWindowContentToTarget
        
            typedef void ( GUIContext_wrapper::*drawWindowContentToTarget_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "drawWindowContentToTarget"
                , drawWindowContentToTarget_function_type( &GUIContext_wrapper::drawWindowContentToTarget ) );
        
        }
        { //::CEGUI::GUIContext::getCommonAncestor
        
            typedef ::CEGUI::Window * ( GUIContext_wrapper::*getCommonAncestor_function_type )( ::CEGUI::Window *,::CEGUI::Window * ) const;
            
            GUIContext_exposer.def( 
                "getCommonAncestor"
                , getCommonAncestor_function_type( &GUIContext_wrapper::getCommonAncestor )
                , ( bp::arg("w1"), bp::arg("w2") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getDefaultFont
        
            typedef ::CEGUI::Font * ( ::CEGUI::GUIContext::*getDefaultFont_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getDefaultFont"
                , getDefaultFont_function_type( &::CEGUI::GUIContext::getDefaultFont )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the default Font for the GUIContext\n\
            \n\
                @return\n\
                    Pointer to a Font object that is the default for this GUIContext.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::getDefaultTooltipObject
        
            typedef ::CEGUI::Tooltip * ( ::CEGUI::GUIContext::*getDefaultTooltipObject_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getDefaultTooltipObject"
                , getDefaultTooltipObject_function_type( &::CEGUI::GUIContext::getDefaultTooltipObject )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Returns a pointer to the context's default tooltip object.  May return 0.\n" );
        
        }
        { //::CEGUI::GUIContext::getInputCaptureWindow
        
            typedef ::CEGUI::Window * ( ::CEGUI::GUIContext::*getInputCaptureWindow_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getInputCaptureWindow"
                , getInputCaptureWindow_function_type( &::CEGUI::GUIContext::getInputCaptureWindow )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getKeyboardTargetWindow
        
            typedef ::CEGUI::Window * ( GUIContext_wrapper::*getKeyboardTargetWindow_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getKeyboardTargetWindow"
                , getKeyboardTargetWindow_function_type( &GUIContext_wrapper::getKeyboardTargetWindow )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getModalWindow
        
            typedef ::CEGUI::Window * ( ::CEGUI::GUIContext::*getModalWindow_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getModalWindow"
                , getModalWindow_function_type( &::CEGUI::GUIContext::getModalWindow )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Return a pointer to the Window that is currently set as modal.\n" );
        
        }
        { //::CEGUI::GUIContext::getMouseButtonClickTimeout
        
            typedef float ( ::CEGUI::GUIContext::*getMouseButtonClickTimeout_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getMouseButtonClickTimeout"
                , getMouseButtonClickTimeout_function_type( &::CEGUI::GUIContext::getMouseButtonClickTimeout ) );
        
        }
        { //::CEGUI::GUIContext::getMouseButtonMultiClickTimeout
        
            typedef float ( ::CEGUI::GUIContext::*getMouseButtonMultiClickTimeout_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getMouseButtonMultiClickTimeout"
                , getMouseButtonMultiClickTimeout_function_type( &::CEGUI::GUIContext::getMouseButtonMultiClickTimeout ) );
        
        }
        { //::CEGUI::GUIContext::getMouseButtonMultiClickTolerance
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::GUIContext::*getMouseButtonMultiClickTolerance_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getMouseButtonMultiClickTolerance"
                , getMouseButtonMultiClickTolerance_function_type( &::CEGUI::GUIContext::getMouseButtonMultiClickTolerance )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::GUIContext::getMouseCursor
        
            typedef ::CEGUI::MouseCursor & ( ::CEGUI::GUIContext::*getMouseCursor_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "getMouseCursor"
                , getMouseCursor_function_type( &::CEGUI::GUIContext::getMouseCursor )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getMouseMoveScalingFactor
        
            typedef float ( ::CEGUI::GUIContext::*getMouseMoveScalingFactor_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getMouseMoveScalingFactor"
                , getMouseMoveScalingFactor_function_type( &::CEGUI::GUIContext::getMouseMoveScalingFactor ) );
        
        }
        { //::CEGUI::GUIContext::getRootWindow
        
            typedef ::CEGUI::Window * ( ::CEGUI::GUIContext::*getRootWindow_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getRootWindow"
                , getRootWindow_function_type( &::CEGUI::GUIContext::getRootWindow )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getSurfaceSize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::GUIContext::*getSurfaceSize_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getSurfaceSize"
                , getSurfaceSize_function_type( &::CEGUI::GUIContext::getSurfaceSize )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::GUIContext::getSystemKeys
        
            typedef ::CEGUI::SystemKeys const & ( ::CEGUI::GUIContext::*getSystemKeys_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getSystemKeys"
                , getSystemKeys_function_type( &::CEGUI::GUIContext::getSystemKeys )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::GUIContext::getTargetWindow
        
            typedef ::CEGUI::Window * ( GUIContext_wrapper::*getTargetWindow_function_type )( ::CEGUI::Vector2f const &,bool const ) const;
            
            GUIContext_exposer.def( 
                "getTargetWindow"
                , getTargetWindow_function_type( &GUIContext_wrapper::getTargetWindow )
                , ( bp::arg("pt"), bp::arg("allow_disabled") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::getWindowContainingMouse
        
            typedef ::CEGUI::Window * ( ::CEGUI::GUIContext::*getWindowContainingMouse_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getWindowContainingMouse"
                , getWindowContainingMouse_function_type( &::CEGUI::GUIContext::getWindowContainingMouse )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::GUIContext::injectChar
        
            typedef bool ( ::CEGUI::GUIContext::*injectChar_function_type )( ::CEGUI::utf32 ) ;
            typedef bool ( GUIContext_wrapper::*default_injectChar_function_type )( ::CEGUI::utf32 ) ;
            
            GUIContext_exposer.def( 
                "injectChar"
                , injectChar_function_type(&::CEGUI::GUIContext::injectChar)
                , default_injectChar_function_type(&GUIContext_wrapper::default_injectChar)
                , ( bp::arg("code_point") ) );
        
        }
        { //::CEGUI::GUIContext::injectCopyRequest
        
            typedef bool ( ::CEGUI::GUIContext::*injectCopyRequest_function_type )(  ) ;
            typedef bool ( GUIContext_wrapper::*default_injectCopyRequest_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "injectCopyRequest"
                , injectCopyRequest_function_type(&::CEGUI::GUIContext::injectCopyRequest)
                , default_injectCopyRequest_function_type(&GUIContext_wrapper::default_injectCopyRequest) );
        
        }
        { //::CEGUI::GUIContext::injectCutRequest
        
            typedef bool ( ::CEGUI::GUIContext::*injectCutRequest_function_type )(  ) ;
            typedef bool ( GUIContext_wrapper::*default_injectCutRequest_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "injectCutRequest"
                , injectCutRequest_function_type(&::CEGUI::GUIContext::injectCutRequest)
                , default_injectCutRequest_function_type(&GUIContext_wrapper::default_injectCutRequest) );
        
        }
        { //::CEGUI::GUIContext::injectKeyDown
        
            typedef bool ( ::CEGUI::GUIContext::*injectKeyDown_function_type )( ::CEGUI::Key::Scan ) ;
            typedef bool ( GUIContext_wrapper::*default_injectKeyDown_function_type )( ::CEGUI::Key::Scan ) ;
            
            GUIContext_exposer.def( 
                "injectKeyDown"
                , injectKeyDown_function_type(&::CEGUI::GUIContext::injectKeyDown)
                , default_injectKeyDown_function_type(&GUIContext_wrapper::default_injectKeyDown)
                , ( bp::arg("scan_code") ) );
        
        }
        { //::CEGUI::GUIContext::injectKeyUp
        
            typedef bool ( ::CEGUI::GUIContext::*injectKeyUp_function_type )( ::CEGUI::Key::Scan ) ;
            typedef bool ( GUIContext_wrapper::*default_injectKeyUp_function_type )( ::CEGUI::Key::Scan ) ;
            
            GUIContext_exposer.def( 
                "injectKeyUp"
                , injectKeyUp_function_type(&::CEGUI::GUIContext::injectKeyUp)
                , default_injectKeyUp_function_type(&GUIContext_wrapper::default_injectKeyUp)
                , ( bp::arg("scan_code") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseButtonClick
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseButtonClick_function_type )( ::CEGUI::MouseButton const ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseButtonClick_function_type )( ::CEGUI::MouseButton const ) ;
            
            GUIContext_exposer.def( 
                "injectMouseButtonClick"
                , injectMouseButtonClick_function_type(&::CEGUI::GUIContext::injectMouseButtonClick)
                , default_injectMouseButtonClick_function_type(&GUIContext_wrapper::default_injectMouseButtonClick)
                , ( bp::arg("button") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseButtonDoubleClick
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseButtonDoubleClick_function_type )( ::CEGUI::MouseButton const ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseButtonDoubleClick_function_type )( ::CEGUI::MouseButton const ) ;
            
            GUIContext_exposer.def( 
                "injectMouseButtonDoubleClick"
                , injectMouseButtonDoubleClick_function_type(&::CEGUI::GUIContext::injectMouseButtonDoubleClick)
                , default_injectMouseButtonDoubleClick_function_type(&GUIContext_wrapper::default_injectMouseButtonDoubleClick)
                , ( bp::arg("button") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseButtonDown
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseButtonDown_function_type )( ::CEGUI::MouseButton ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseButtonDown_function_type )( ::CEGUI::MouseButton ) ;
            
            GUIContext_exposer.def( 
                "injectMouseButtonDown"
                , injectMouseButtonDown_function_type(&::CEGUI::GUIContext::injectMouseButtonDown)
                , default_injectMouseButtonDown_function_type(&GUIContext_wrapper::default_injectMouseButtonDown)
                , ( bp::arg("button") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseButtonTripleClick
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseButtonTripleClick_function_type )( ::CEGUI::MouseButton const ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseButtonTripleClick_function_type )( ::CEGUI::MouseButton const ) ;
            
            GUIContext_exposer.def( 
                "injectMouseButtonTripleClick"
                , injectMouseButtonTripleClick_function_type(&::CEGUI::GUIContext::injectMouseButtonTripleClick)
                , default_injectMouseButtonTripleClick_function_type(&GUIContext_wrapper::default_injectMouseButtonTripleClick)
                , ( bp::arg("button") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseButtonUp
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseButtonUp_function_type )( ::CEGUI::MouseButton ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseButtonUp_function_type )( ::CEGUI::MouseButton ) ;
            
            GUIContext_exposer.def( 
                "injectMouseButtonUp"
                , injectMouseButtonUp_function_type(&::CEGUI::GUIContext::injectMouseButtonUp)
                , default_injectMouseButtonUp_function_type(&GUIContext_wrapper::default_injectMouseButtonUp)
                , ( bp::arg("button") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseLeaves
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseLeaves_function_type )(  ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseLeaves_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "injectMouseLeaves"
                , injectMouseLeaves_function_type(&::CEGUI::GUIContext::injectMouseLeaves)
                , default_injectMouseLeaves_function_type(&GUIContext_wrapper::default_injectMouseLeaves) );
        
        }
        { //::CEGUI::GUIContext::injectMouseMove
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseMove_function_type )( float,float ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseMove_function_type )( float,float ) ;
            
            GUIContext_exposer.def( 
                "injectMouseMove"
                , injectMouseMove_function_type(&::CEGUI::GUIContext::injectMouseMove)
                , default_injectMouseMove_function_type(&GUIContext_wrapper::default_injectMouseMove)
                , ( bp::arg("delta_x"), bp::arg("delta_y") ) );
        
        }
        { //::CEGUI::GUIContext::injectMousePosition
        
            typedef bool ( ::CEGUI::GUIContext::*injectMousePosition_function_type )( float,float ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMousePosition_function_type )( float,float ) ;
            
            GUIContext_exposer.def( 
                "injectMousePosition"
                , injectMousePosition_function_type(&::CEGUI::GUIContext::injectMousePosition)
                , default_injectMousePosition_function_type(&GUIContext_wrapper::default_injectMousePosition)
                , ( bp::arg("x_pos"), bp::arg("y_pos") ) );
        
        }
        { //::CEGUI::GUIContext::injectMouseWheelChange
        
            typedef bool ( ::CEGUI::GUIContext::*injectMouseWheelChange_function_type )( float ) ;
            typedef bool ( GUIContext_wrapper::*default_injectMouseWheelChange_function_type )( float ) ;
            
            GUIContext_exposer.def( 
                "injectMouseWheelChange"
                , injectMouseWheelChange_function_type(&::CEGUI::GUIContext::injectMouseWheelChange)
                , default_injectMouseWheelChange_function_type(&GUIContext_wrapper::default_injectMouseWheelChange)
                , ( bp::arg("delta") ) );
        
        }
        { //::CEGUI::GUIContext::injectPasteRequest
        
            typedef bool ( ::CEGUI::GUIContext::*injectPasteRequest_function_type )(  ) ;
            typedef bool ( GUIContext_wrapper::*default_injectPasteRequest_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "injectPasteRequest"
                , injectPasteRequest_function_type(&::CEGUI::GUIContext::injectPasteRequest)
                , default_injectPasteRequest_function_type(&GUIContext_wrapper::default_injectPasteRequest) );
        
        }
        { //::CEGUI::GUIContext::injectTimePulse
        
            typedef bool ( ::CEGUI::GUIContext::*injectTimePulse_function_type )( float ) ;
            typedef bool ( GUIContext_wrapper::*default_injectTimePulse_function_type )( float ) ;
            
            GUIContext_exposer.def( 
                "injectTimePulse"
                , injectTimePulse_function_type(&::CEGUI::GUIContext::injectTimePulse)
                , default_injectTimePulse_function_type(&GUIContext_wrapper::default_injectTimePulse)
                , ( bp::arg("timeElapsed") ) );
        
        }
        { //::CEGUI::GUIContext::isDirty
        
            typedef bool ( ::CEGUI::GUIContext::*isDirty_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "isDirty"
                , isDirty_function_type( &::CEGUI::GUIContext::isDirty )
                , "! call to indicate that some redrawing is required.\n" );
        
        }
        { //::CEGUI::GUIContext::isMouseClickEventGenerationEnabled
        
            typedef bool ( ::CEGUI::GUIContext::*isMouseClickEventGenerationEnabled_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "isMouseClickEventGenerationEnabled"
                , isMouseClickEventGenerationEnabled_function_type( &::CEGUI::GUIContext::isMouseClickEventGenerationEnabled )
                , "*!\n\
                \n\
                    Return whether automatic mouse button click and multi-click (i.e.\n\
                    double-click and treble-click) event generation is enabled.\n\
            \n\
                @return\n\
                    - true if mouse button click and multi-click events will be\n\
                    automatically generated by the system from the basic button up and down\n\
                    event injections.\n\
                    - false if no automatic generation of events will occur.  In this\n\
                    instance the user may wish to use the additional event injectors to\n\
                    manually inform the system of such events.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::markAsDirty
        
            typedef void ( ::CEGUI::GUIContext::*markAsDirty_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "markAsDirty"
                , markAsDirty_function_type( &::CEGUI::GUIContext::markAsDirty )
                , "! call to indicate that some redrawing is required.\n" );
        
        }
        { //::CEGUI::GUIContext::mouseMoveInjection_impl
        
            typedef bool ( GUIContext_wrapper::*mouseMoveInjection_impl_function_type )( ::CEGUI::MouseEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "mouseMoveInjection_impl"
                , mouseMoveInjection_impl_function_type( &GUIContext_wrapper::mouseMoveInjection_impl )
                , ( bp::arg("ma") ) );
        
        }
        { //::CEGUI::GUIContext::notifyDefaultFontChanged
        
            typedef void ( GUIContext_wrapper::*notifyDefaultFontChanged_function_type )( ::CEGUI::Window * ) const;
            
            GUIContext_exposer.def( 
                "notifyDefaultFontChanged"
                , notifyDefaultFontChanged_function_type( &GUIContext_wrapper::notifyDefaultFontChanged )
                , ( bp::arg("hierarchy_root") )
                , "! notify windows in a hierarchy using default font, when font changes.\n" );
        
        }
        { //::CEGUI::GUIContext::onDefaultFontChanged
        
            typedef void ( GUIContext_wrapper::*onDefaultFontChanged_function_type )( ::CEGUI::EventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onDefaultFontChanged"
                , onDefaultFontChanged_function_type( &GUIContext_wrapper::default_onDefaultFontChanged )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::onMouseButtonClickTimeoutChanged
        
            typedef void ( GUIContext_wrapper::*onMouseButtonClickTimeoutChanged_function_type )( ::CEGUI::GUIContextEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onMouseButtonClickTimeoutChanged"
                , onMouseButtonClickTimeoutChanged_function_type( &GUIContext_wrapper::default_onMouseButtonClickTimeoutChanged )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::onMouseButtonMultiClickTimeoutChanged
        
            typedef void ( GUIContext_wrapper::*onMouseButtonMultiClickTimeoutChanged_function_type )( ::CEGUI::GUIContextEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onMouseButtonMultiClickTimeoutChanged"
                , onMouseButtonMultiClickTimeoutChanged_function_type( &GUIContext_wrapper::default_onMouseButtonMultiClickTimeoutChanged )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::onMouseButtonMultiClickToleranceChanged
        
            typedef void ( GUIContext_wrapper::*onMouseButtonMultiClickToleranceChanged_function_type )( ::CEGUI::GUIContextEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onMouseButtonMultiClickToleranceChanged"
                , onMouseButtonMultiClickToleranceChanged_function_type( &GUIContext_wrapper::default_onMouseButtonMultiClickToleranceChanged )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::onMouseMoveScalingFactorChanged
        
            typedef void ( GUIContext_wrapper::*onMouseMoveScalingFactorChanged_function_type )( ::CEGUI::GUIContextEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onMouseMoveScalingFactorChanged"
                , onMouseMoveScalingFactorChanged_function_type( &GUIContext_wrapper::default_onMouseMoveScalingFactorChanged )
                , ( bp::arg("args") )
                , "event trigger functions.\n" );
        
        }
        { //::CEGUI::GUIContext::onRenderTargetChanged
        
            typedef void ( GUIContext_wrapper::*onRenderTargetChanged_function_type )( ::CEGUI::GUIContextRenderTargetEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onRenderTargetChanged"
                , onRenderTargetChanged_function_type( &GUIContext_wrapper::default_onRenderTargetChanged )
                , ( bp::arg("args") ) );
        
        }
        { //::CEGUI::GUIContext::onRootWindowChanged
        
            typedef void ( GUIContext_wrapper::*onRootWindowChanged_function_type )( ::CEGUI::WindowEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "onRootWindowChanged"
                , onRootWindowChanged_function_type( &GUIContext_wrapper::default_onRootWindowChanged )
                , ( bp::arg("args") )
                , "event trigger functions.\n" );
        
        }
        { //::CEGUI::GUIContext::renderWindowHierarchyToSurfaces
        
            typedef void ( GUIContext_wrapper::*renderWindowHierarchyToSurfaces_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "renderWindowHierarchyToSurfaces"
                , renderWindowHierarchyToSurfaces_function_type( &GUIContext_wrapper::renderWindowHierarchyToSurfaces ) );
        
        }
        { //::CEGUI::GUIContext::resetWindowContainingMouse
        
            typedef void ( GUIContext_wrapper::*resetWindowContainingMouse_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "resetWindowContainingMouse"
                , resetWindowContainingMouse_function_type( &GUIContext_wrapper::resetWindowContainingMouse )
                , "! returns whether the window containing the mouse had changed.\n" );
        
        }
        { //::CEGUI::GUIContext::setDefaultFont
        
            typedef void ( ::CEGUI::GUIContext::*setDefaultFont_function_type )( ::CEGUI::String const & ) ;
            
            GUIContext_exposer.def( 
                "setDefaultFont"
                , setDefaultFont_function_type( &::CEGUI::GUIContext::setDefaultFont )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Set the default font to be used by the GUIContext\n\
            \n\
                @param name\n\
                    String object containing the name of the font to be used as the\n\
                    default for this GUIContext\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setDefaultFont
        
            typedef void ( ::CEGUI::GUIContext::*setDefaultFont_function_type )( ::CEGUI::Font * ) ;
            
            GUIContext_exposer.def( 
                "setDefaultFont"
                , setDefaultFont_function_type( &::CEGUI::GUIContext::setDefaultFont )
                , ( bp::arg("font") )
                , "*!\n\
                \n\
                    Set the default font to be used by the GUIContext\n\
            \n\
                @param font\n\
                    Pointer to the font to be used as the default for this GUIContext.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setDefaultTooltipObject
        
            typedef void ( ::CEGUI::GUIContext::*setDefaultTooltipObject_function_type )( ::CEGUI::Tooltip * ) ;
            
            GUIContext_exposer.def( 
                "setDefaultTooltipObject"
                , setDefaultTooltipObject_function_type( &::CEGUI::GUIContext::setDefaultTooltipObject )
                , ( bp::arg("tooltip") )
                , "*!\n\
                \n\
                    Set the default Tooltip object for this GUIContext. This value may be 0\n\
                    to indicate that no default Tooltip object will be available.\n\
            \n\
                @param tooltip\n\
                    Pointer to a valid Tooltip based object which should be used as the\n\
                    default tooltip for the GUIContext, or 0 to indicate that no default\n\
                    Tooltip is required.\n\
            \n\
                \note\n\
                    When passing a pointer to a Tooltip object, ownership of the Tooltip\n\
                    does not pass to the GUIContext.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setDefaultTooltipType
        
            typedef void ( ::CEGUI::GUIContext::*setDefaultTooltipType_function_type )( ::CEGUI::String const & ) ;
            
            GUIContext_exposer.def( 
                "setDefaultTooltipType"
                , setDefaultTooltipType_function_type( &::CEGUI::GUIContext::setDefaultTooltipType )
                , ( bp::arg("tooltip_type") )
                , "*!\n\
                \n\
                    Set the default Tooltip to be used by specifying a Window type.\n\
            \n\
                    The GUIContext will internally attempt to create an instance of the\n\
                    specified window type (which must be derived from the base Tooltip\n\
                    class).  If the Tooltip creation fails, the error is logged and no\n\
                    default Tooltip will be available on the GUIContext.\n\
            \n\
                @param tooltipType\n\
                    String holding the name of a Tooltip based Window type.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setInputCaptureWindow
        
            typedef void ( ::CEGUI::GUIContext::*setInputCaptureWindow_function_type )( ::CEGUI::Window * ) ;
            
            GUIContext_exposer.def( 
                "setInputCaptureWindow"
                , setInputCaptureWindow_function_type( &::CEGUI::GUIContext::setInputCaptureWindow )
                , ( bp::arg("window") ) );
        
        }
        { //::CEGUI::GUIContext::setModalWindow
        
            typedef void ( ::CEGUI::GUIContext::*setModalWindow_function_type )( ::CEGUI::Window * ) ;
            
            GUIContext_exposer.def( 
                "setModalWindow"
                , setModalWindow_function_type( &::CEGUI::GUIContext::setModalWindow )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Internal function to directly set the current modal window.\n\
            \n\
                \note\n\
                    This function is called internally by Window, and should not be called\n\
                    by client code.  Doing so will likely not give the expected results.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setMouseButtonClickTimeout
        
            typedef void ( ::CEGUI::GUIContext::*setMouseButtonClickTimeout_function_type )( float ) ;
            
            GUIContext_exposer.def( 
                "setMouseButtonClickTimeout"
                , setMouseButtonClickTimeout_function_type( &::CEGUI::GUIContext::setMouseButtonClickTimeout )
                , ( bp::arg("seconds") ) );
        
        }
        { //::CEGUI::GUIContext::setMouseButtonMultiClickTimeout
        
            typedef void ( ::CEGUI::GUIContext::*setMouseButtonMultiClickTimeout_function_type )( float ) ;
            
            GUIContext_exposer.def( 
                "setMouseButtonMultiClickTimeout"
                , setMouseButtonMultiClickTimeout_function_type( &::CEGUI::GUIContext::setMouseButtonMultiClickTimeout )
                , ( bp::arg("seconds") ) );
        
        }
        { //::CEGUI::GUIContext::setMouseButtonMultiClickTolerance
        
            typedef void ( ::CEGUI::GUIContext::*setMouseButtonMultiClickTolerance_function_type )( ::CEGUI::Sizef const & ) ;
            
            GUIContext_exposer.def( 
                "setMouseButtonMultiClickTolerance"
                , setMouseButtonMultiClickTolerance_function_type( &::CEGUI::GUIContext::setMouseButtonMultiClickTolerance )
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::GUIContext::setMouseClickEventGenerationEnabled
        
            typedef void ( ::CEGUI::GUIContext::*setMouseClickEventGenerationEnabled_function_type )( bool const ) ;
            
            GUIContext_exposer.def( 
                "setMouseClickEventGenerationEnabled"
                , setMouseClickEventGenerationEnabled_function_type( &::CEGUI::GUIContext::setMouseClickEventGenerationEnabled )
                , ( bp::arg("enable") )
                , "*!\n\
                \n\
                    Set whether automatic mouse button click and multi-click (i.e.\n\
                    double-click and treble-click) event generation will occur.\n\
            \n\
                @param enable\n\
                    - true to have mouse button click and multi-click events automatically\n\
                    generated by the system from the basic button up and down event\n\
                    injections.\n\
                    - false if no automatic generation of events should occur.  In this\n\
                    instance the user may wish to use the additional event injectors to\n\
                    manually inform the system of such events.\n\
                *\n" );
        
        }
        { //::CEGUI::GUIContext::setMouseMoveScalingFactor
        
            typedef void ( ::CEGUI::GUIContext::*setMouseMoveScalingFactor_function_type )( float ) ;
            
            GUIContext_exposer.def( 
                "setMouseMoveScalingFactor"
                , setMouseMoveScalingFactor_function_type( &::CEGUI::GUIContext::setMouseMoveScalingFactor )
                , ( bp::arg("factor") ) );
        
        }
        { //::CEGUI::GUIContext::setRenderTarget
        
            typedef void ( ::CEGUI::GUIContext::*setRenderTarget_function_type )( ::CEGUI::RenderTarget & ) ;
            
            GUIContext_exposer.def( 
                "setRenderTarget"
                , setRenderTarget_function_type( &::CEGUI::GUIContext::setRenderTarget )
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::GUIContext::setRootWindow
        
            typedef void ( ::CEGUI::GUIContext::*setRootWindow_function_type )( ::CEGUI::Window * ) ;
            
            GUIContext_exposer.def( 
                "setRootWindow"
                , setRootWindow_function_type( &::CEGUI::GUIContext::setRootWindow )
                , ( bp::arg("new_root") ) );
        
        }
        { //::CEGUI::GUIContext::updateRootWindowAreaRects
        
            typedef void ( GUIContext_wrapper::*updateRootWindowAreaRects_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "updateRootWindowAreaRects"
                , updateRootWindowAreaRects_function_type( &GUIContext_wrapper::updateRootWindowAreaRects ) );
        
        }
        { //::CEGUI::GUIContext::updateWindowContainingMouse
        
            typedef void ( ::CEGUI::GUIContext::*updateWindowContainingMouse_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "updateWindowContainingMouse"
                , updateWindowContainingMouse_function_type( &::CEGUI::GUIContext::updateWindowContainingMouse )
                , "! Tell the context to reconsider which window it thinks the mouse is in.\n" );
        
        }
        { //::CEGUI::GUIContext::updateWindowContainingMouse_impl
        
            typedef bool ( GUIContext_wrapper::*updateWindowContainingMouse_impl_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "updateWindowContainingMouse_impl"
                , updateWindowContainingMouse_impl_function_type( &GUIContext_wrapper::updateWindowContainingMouse_impl )
                , "! returns whether the window containing the mouse had changed.\n" );
        
        }
        { //::CEGUI::GUIContext::windowDestroyedHandler
        
            typedef bool ( GUIContext_wrapper::*windowDestroyedHandler_function_type )( ::CEGUI::EventArgs const & ) ;
            
            GUIContext_exposer.def( 
                "windowDestroyedHandler"
                , windowDestroyedHandler_function_type( &GUIContext_wrapper::windowDestroyedHandler )
                , ( bp::arg("args") ) );
        
        }
        GUIContext_exposer.def_readonly( "DefaultMouseButtonClickTimeout", CEGUI::GUIContext::DefaultMouseButtonClickTimeout );
        GUIContext_exposer.def_readonly( "DefaultMouseButtonMultiClickTimeout", CEGUI::GUIContext::DefaultMouseButtonMultiClickTimeout );
        GUIContext_exposer.def_readonly( "DefaultMouseButtonMultiClickTolerance", CEGUI::GUIContext::DefaultMouseButtonMultiClickTolerance );
        GUIContext_exposer.add_static_property( "EventDefaultFontChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventDefaultFontChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventMouseButtonClickTimeoutChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventMouseButtonClickTimeoutChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventMouseButtonMultiClickTimeoutChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventMouseButtonMultiClickTimeoutChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventMouseButtonMultiClickToleranceChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventMouseButtonMultiClickToleranceChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventMouseMoveScalingFactorChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventMouseMoveScalingFactorChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventRenderTargetChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventRenderTargetChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        GUIContext_exposer.add_static_property( "EventRootWindowChanged"
                        , bp::make_getter( &CEGUI::GUIContext::EventRootWindowChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        { //::CEGUI::RenderingSurface::attachWindow
        
            typedef void ( GUIContext_wrapper::*attachWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            GUIContext_exposer.def( 
                "attachWindow"
                , attachWindow_function_type( &GUIContext_wrapper::attachWindow )
                , ( bp::arg("w") )
                , "! attach ReneringWindow from this RenderingSurface\n" );
        
        }
        { //::CEGUI::RenderingSurface::createRenderingWindow
        
            typedef ::CEGUI::RenderingWindow & ( ::CEGUI::RenderingSurface::*createRenderingWindow_function_type )( ::CEGUI::TextureTarget & ) ;
            
            GUIContext_exposer.def( 
                "createRenderingWindow"
                , createRenderingWindow_function_type(&::CEGUI::RenderingSurface::createRenderingWindow)
                , ( bp::arg("target") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::RenderingSurface::destroyRenderingWindow
        
            typedef void ( ::CEGUI::RenderingSurface::*destroyRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            typedef void ( GUIContext_wrapper::*default_destroyRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            GUIContext_exposer.def( 
                "destroyRenderingWindow"
                , destroyRenderingWindow_function_type(&::CEGUI::RenderingSurface::destroyRenderingWindow)
                , default_destroyRenderingWindow_function_type(&GUIContext_wrapper::default_destroyRenderingWindow)
                , ( bp::arg("window") ) );
        
        }
        { //::CEGUI::RenderingSurface::detatchWindow
        
            typedef void ( GUIContext_wrapper::*detatchWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            GUIContext_exposer.def( 
                "detatchWindow"
                , detatchWindow_function_type( &GUIContext_wrapper::detatchWindow )
                , ( bp::arg("w") )
                , "! detatch ReneringWindow from this RenderingSurface\n" );
        
        }
        { //::CEGUI::RenderingSurface::draw
        
            typedef void ( GUIContext_wrapper::*draw_function_type )( ::CEGUI::RenderQueue const &,::CEGUI::RenderQueueEventArgs & ) ;
            
            GUIContext_exposer.def( 
                "draw"
                , draw_function_type( &GUIContext_wrapper::draw )
                , ( bp::arg("queue"), bp::arg("args") )
                , "! draw a rendering queue, firing events before and after.\n" );
        
        }
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( GUIContext_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            GUIContext_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&GUIContext_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::EventSet::fireEvent_impl
        
            typedef void ( GUIContext_wrapper::*fireEvent_impl_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs & ) ;
            
            GUIContext_exposer.def( 
                "fireEvent_impl"
                , fireEvent_impl_function_type( &GUIContext_wrapper::fireEvent_impl )
                , ( bp::arg("name"), bp::arg("args") )
                , "! Implementation event firing member\n" );
        
        }
        { //::CEGUI::EventSet::getScriptModule
        
            typedef ::CEGUI::ScriptModule * ( GUIContext_wrapper::*getScriptModule_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "getScriptModule"
                , getScriptModule_function_type( &GUIContext_wrapper::getScriptModule )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Implementation event firing member\n\
            ! Helper to return the script module pointer or throw.\n" );
        
        }
        { //::CEGUI::RenderingSurface::invalidate
        
            typedef void ( ::CEGUI::RenderingSurface::*invalidate_function_type )(  ) ;
            typedef void ( GUIContext_wrapper::*default_invalidate_function_type )(  ) ;
            
            GUIContext_exposer.def( 
                "invalidate"
                , invalidate_function_type(&::CEGUI::RenderingSurface::invalidate)
                , default_invalidate_function_type(&GUIContext_wrapper::default_invalidate) );
        
        }
        { //::CEGUI::RenderingSurface::isRenderingWindow
        
            typedef bool ( ::CEGUI::RenderingSurface::*isRenderingWindow_function_type )(  ) const;
            typedef bool ( GUIContext_wrapper::*default_isRenderingWindow_function_type )(  ) const;
            
            GUIContext_exposer.def( 
                "isRenderingWindow"
                , isRenderingWindow_function_type(&::CEGUI::RenderingSurface::isRenderingWindow)
                , default_isRenderingWindow_function_type(&GUIContext_wrapper::default_isRenderingWindow) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( GUIContext_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            GUIContext_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&GUIContext_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( GUIContext_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            GUIContext_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&GUIContext_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::RenderingSurface::transferRenderingWindow
        
            typedef void ( ::CEGUI::RenderingSurface::*transferRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            typedef void ( GUIContext_wrapper::*default_transferRenderingWindow_function_type )( ::CEGUI::RenderingWindow & ) ;
            
            GUIContext_exposer.def( 
                "transferRenderingWindow"
                , transferRenderingWindow_function_type(&::CEGUI::RenderingSurface::transferRenderingWindow)
                , default_transferRenderingWindow_function_type(&GUIContext_wrapper::default_transferRenderingWindow)
                , ( bp::arg("window") ) );
        
        }
    }

}
