{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetShadows: Boolean;
    procedure SetShadows(const Value: Boolean);
    function GetShadowVolumesMain: Boolean;
    procedure SetShadowVolumesMain(const Value: Boolean);
    function GetProjectionNear: Single;
    procedure SetProjectionNear(const Value: Single);
    function GetProjectionFar: Single;
    procedure SetProjectionFar(const Value: Single);
    function GetUp: TVector3;
    procedure SetUp(const Value: TVector3);
    function GetDefaultShadowMap: TGeneratedShadowMapNode;
    procedure SetDefaultShadowMap(const Value: TGeneratedShadowMapNode);
  public
    { X3D field "shadows". } { }
    property Shadows: Boolean read GetShadows write SetShadows;
    { X3D field "shadowVolumesMain". } { }
    property ShadowVolumesMain: Boolean read GetShadowVolumesMain write SetShadowVolumesMain;
    { X3D field "projectionNear". } { }
    property ProjectionNear: Single read GetProjectionNear write SetProjectionNear;
    { X3D field "projectionFar". } { }
    property ProjectionFar: Single read GetProjectionFar write SetProjectionFar;
    { X3D field "up". } { }
    property Up: TVector3 read GetUp write SetUp;
    { X3D field "defaultShadowMap". } { }
    property DefaultShadowMap: TGeneratedShadowMapNode read GetDefaultShadowMap write SetDefaultShadowMap;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractPunctualLightNode ----------------------------------------------- }

function TAbstractPunctualLightNode.GetShadows: Boolean;
begin
  Result := FdShadows.Value;
end;

procedure TAbstractPunctualLightNode.SetShadows(const Value: Boolean);
begin
  FdShadows.Send(Value);
end;

function TAbstractPunctualLightNode.GetShadowVolumesMain: Boolean;
begin
  Result := FdShadowVolumesMain.Value;
end;

procedure TAbstractPunctualLightNode.SetShadowVolumesMain(const Value: Boolean);
begin
  FdShadowVolumesMain.Send(Value);
end;

function TAbstractPunctualLightNode.GetProjectionNear: Single;
begin
  Result := FdProjectionNear.Value;
end;

procedure TAbstractPunctualLightNode.SetProjectionNear(const Value: Single);
begin
  FdProjectionNear.Send(Value);
end;

function TAbstractPunctualLightNode.GetProjectionFar: Single;
begin
  Result := FdProjectionFar.Value;
end;

procedure TAbstractPunctualLightNode.SetProjectionFar(const Value: Single);
begin
  FdProjectionFar.Send(Value);
end;

function TAbstractPunctualLightNode.GetUp: TVector3;
begin
  Result := FdUp.Value;
end;

procedure TAbstractPunctualLightNode.SetUp(const Value: TVector3);
begin
  FdUp.Send(Value);
end;

function TAbstractPunctualLightNode.GetDefaultShadowMap: TGeneratedShadowMapNode;
begin
  if FdDefaultShadowMap.Value is TGeneratedShadowMapNode then
    Result := TGeneratedShadowMapNode(FdDefaultShadowMap.Value)
  else
    Result := nil;
end;

procedure TAbstractPunctualLightNode.SetDefaultShadowMap(const Value: TGeneratedShadowMapNode);
begin
  FdDefaultShadowMap.Send(Value);
end;

{$endif read_implementation}
