{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetEmissiveColor: TCastleColorRGB;
    procedure SetEmissiveColor(const Value: TCastleColorRGB);
    function GetEmissiveTexture: TAbstractSingleTextureNode;
    procedure SetEmissiveTexture(const Value: TAbstractSingleTextureNode);
    function GetEmissiveTextureMapping: String;
    procedure SetEmissiveTextureMapping(const Value: String);
    function GetNormalTexture: TAbstractTexture2DNode;
    procedure SetNormalTexture(const Value: TAbstractTexture2DNode);
    function GetNormalTextureMapping: String;
    procedure SetNormalTextureMapping(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdEmissiveColor: TSFColor;
    { X3D field "emissiveColor". } { }
    public property FdEmissiveColor: TSFColor read FFdEmissiveColor;
    { X3D field "emissiveColor". } { }
    property EmissiveColor: TCastleColorRGB read GetEmissiveColor write SetEmissiveColor;

    strict private FFdEmissiveTexture: TSFNode;
    { X3D field "emissiveTexture". } { }
    public property FdEmissiveTexture: TSFNode read FFdEmissiveTexture;
    { X3D field "emissiveTexture". } { }
    property EmissiveTexture: TAbstractSingleTextureNode read GetEmissiveTexture write SetEmissiveTexture;

    strict private FFdEmissiveTextureMapping: TSFString;
    { X3D field "emissiveTextureMapping". } { }
    public property FdEmissiveTextureMapping: TSFString read FFdEmissiveTextureMapping;
    { X3D field "emissiveTextureMapping". } { }
    property EmissiveTextureMapping: String read GetEmissiveTextureMapping write SetEmissiveTextureMapping;

    strict private FFdNormalTexture: TSFNode;
    { X3D field "normalTexture". } { }
    public property FdNormalTexture: TSFNode read FFdNormalTexture;
    { X3D field "normalTexture". } { }
    property NormalTexture: TAbstractTexture2DNode read GetNormalTexture write SetNormalTexture;

    strict private FFdNormalTextureMapping: TSFString;
    { X3D field "normalTextureMapping". } { }
    public property FdNormalTextureMapping: TSFString read FFdNormalTextureMapping;
    { X3D field "normalTextureMapping". } { }
    property NormalTextureMapping: String read GetNormalTextureMapping write SetNormalTextureMapping;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractOneSidedMaterialNode ----------------------------------------------- }

function TAbstractOneSidedMaterialNode.GetEmissiveColor: TCastleColorRGB;
begin
  Result := FdEmissiveColor.Value;
end;

procedure TAbstractOneSidedMaterialNode.SetEmissiveColor(const Value: TCastleColorRGB);
begin
  FdEmissiveColor.Send(Value);
end;

function TAbstractOneSidedMaterialNode.GetEmissiveTexture: TAbstractSingleTextureNode;
begin
  if FdEmissiveTexture.Value is TAbstractSingleTextureNode then
    Result := TAbstractSingleTextureNode(FdEmissiveTexture.Value)
  else
    Result := nil;
end;

procedure TAbstractOneSidedMaterialNode.SetEmissiveTexture(const Value: TAbstractSingleTextureNode);
begin
  FdEmissiveTexture.Send(Value);
end;

function TAbstractOneSidedMaterialNode.GetEmissiveTextureMapping: String;
begin
  Result := FdEmissiveTextureMapping.Value;
end;

procedure TAbstractOneSidedMaterialNode.SetEmissiveTextureMapping(const Value: String);
begin
  FdEmissiveTextureMapping.Send(Value);
end;

function TAbstractOneSidedMaterialNode.GetNormalTexture: TAbstractTexture2DNode;
begin
  if FdNormalTexture.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdNormalTexture.Value)
  else
    Result := nil;
end;

procedure TAbstractOneSidedMaterialNode.SetNormalTexture(const Value: TAbstractTexture2DNode);
begin
  FdNormalTexture.Send(Value);
end;

function TAbstractOneSidedMaterialNode.GetNormalTextureMapping: String;
begin
  Result := FdNormalTextureMapping.Value;
end;

procedure TAbstractOneSidedMaterialNode.SetNormalTextureMapping(const Value: String);
begin
  FdNormalTextureMapping.Send(Value);
end;

class function TAbstractOneSidedMaterialNode.ClassX3DType: String;
begin
  Result := 'X3DOneSidedMaterialNode';
end;

procedure TAbstractOneSidedMaterialNode.CreateNode;
begin
  inherited;

  FFdEmissiveColor := TSFColor.Create(Self, True, 'emissiveColor', Vector3(0, 0, 0));
   FdEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveColor);
  { X3D specification comment: [0, 1] }

  FFdEmissiveTexture := TSFNode.Create(Self, True, 'emissiveTexture', [TAbstractSingleTextureNode]);
   FdEmissiveTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTexture);

  FFdEmissiveTextureMapping := TSFString.Create(Self, True, 'emissiveTextureMapping', '');
   FdEmissiveTextureMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTextureMapping);

  FFdNormalTexture := TSFNode.Create(Self, True, 'normalTexture', [TAbstractTexture2DNode]);
   FdNormalTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTexture);

  FFdNormalTextureMapping := TSFString.Create(Self, True, 'normalTextureMapping', '');
   FdNormalTextureMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTextureMapping);

  DefaultContainerField := 'material';
end;

{$endif read_implementation}
