{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    { X3D field "closed". } { }
    property Closed: Boolean read GetClosed write SetClosed;
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: array of TVector3);
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: TVector3List);
    { Set X3D field "keyVelocity". } { }
    procedure SetKeyVelocity(const Value: array of TVector3);
    { Set X3D field "keyVelocity". } { }
    procedure SetKeyVelocity(const Value: TVector3List);
    { X3D field "normalizeVelocity". } { }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

{$endif read_interface}

{$ifdef read_implementation}

{ TSplinePositionInterpolatorNode ----------------------------------------------- }

function TSplinePositionInterpolatorNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TSplinePositionInterpolatorNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TSplinePositionInterpolatorNode.SetKeyValue(const Value: array of TVector3);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplinePositionInterpolatorNode.SetKeyValue(const Value: TVector3List);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplinePositionInterpolatorNode.SetKeyVelocity(const Value: array of TVector3);
begin
  FdKeyVelocity.Send(Value);
end;

procedure TSplinePositionInterpolatorNode.SetKeyVelocity(const Value: TVector3List);
begin
  FdKeyVelocity.Send(Value);
end;

function TSplinePositionInterpolatorNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSplinePositionInterpolatorNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

{$endif read_implementation}
